/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.transients;

import com.jme.renderer.ColorRGBA;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import com.jmex.effects.transients.Transient;

public class FadeInOut
extends Transient {
    private static final long serialVersionUID = 1L;
    private Geometry fadeQ;
    private Node fadeInNode;
    private Node fadeOutNode;
    private ColorRGBA fadeColor;
    private float speed;

    public FadeInOut(String string, Geometry geometry, Node node, Node node2, ColorRGBA colorRGBA) {
        super(string);
        this.initialise(geometry, node, node2, colorRGBA, 0.01f);
    }

    public FadeInOut(String string, Geometry geometry, Node node, Node node2, ColorRGBA colorRGBA, float f) {
        super(string);
        this.initialise(geometry, node, node2, colorRGBA, f);
    }

    private void initialise(Geometry geometry, Node node, Node node2, ColorRGBA colorRGBA, float f) {
        this.setMaxNumOfStages(2);
        this.setCurrentStage(0);
        this.setSpeed(f);
        this.fadeColor = colorRGBA.clone();
        this.fadeColor.a = 0.0f;
        this.fadeInNode = node2;
        this.fadeOutNode = node;
        this.fadeQ = geometry;
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(false);
        alphaState.setTestFunction(6);
        alphaState.setEnabled(true);
        this.fadeQ.setRenderState((RenderState)alphaState);
        this.attachChild((Spatial)this.fadeOutNode);
    }

    public Geometry getFadeQuad() {
        return this.fadeQ;
    }

    public void setFadeQuad(Geometry geometry) {
        this.fadeQ = geometry;
    }

    public Node getFadeInNode() {
        return this.fadeInNode;
    }

    public void setFadeInNode(Node node) {
        this.fadeInNode = node;
    }

    public Node getFadeOutNode() {
        return this.fadeOutNode;
    }

    public void setFadeOutNode(Node node) {
        this.fadeOutNode = node;
    }

    public ColorRGBA getFadeColor() {
        return this.fadeColor;
    }

    public void setFadeColor(ColorRGBA colorRGBA) {
        this.fadeColor = colorRGBA.clone();
        this.fadeQ.setDefaultColor(this.fadeColor);
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public void updateWorldData(float f) {
        if (this.getControllers().size() != 0) {
            for (int i = 0; i < this.getControllers().size(); ++i) {
                this.getController(i).update(f);
            }
        }
    }
}

