/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.scene.batch.TriangleBatch;

public class VertMap {
    private int[] lookupTable;

    public VertMap(TriangleBatch triangleBatch) {
        this.setupTable(triangleBatch);
    }

    private void setupTable(TriangleBatch triangleBatch) {
        this.lookupTable = new int[triangleBatch.getVertexCount()];
        for (int i = 0; i < this.lookupTable.length; ++i) {
            this.lookupTable[i] = i;
        }
    }

    public int getNewIndex(int n) {
        return this.lookupTable[n];
    }

    public void replaceIndex(int n, int n2) {
        for (int i = 0; i < this.lookupTable.length; ++i) {
            if (this.lookupTable[i] != n) continue;
            this.lookupTable[i] = n2;
        }
    }

    public void decrementIndices(int n) {
        int n2 = this.lookupTable.length;
        while (--n2 >= 0) {
            if (this.lookupTable[n2] < n) continue;
            int n3 = n2;
            this.lookupTable[n3] = this.lookupTable[n3] - 1;
        }
    }
}

