/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.export.binary;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryLoaderModule;
import com.jme.util.export.binary.modules.BinaryAbstractCameraModule;
import com.jme.util.export.binary.modules.BinaryAlphaStateModule;
import com.jme.util.export.binary.modules.BinaryAttributeStateModule;
import com.jme.util.export.binary.modules.BinaryClipStateModule;
import com.jme.util.export.binary.modules.BinaryColorMaskStateModule;
import com.jme.util.export.binary.modules.BinaryCullStateModule;
import com.jme.util.export.binary.modules.BinaryDitherStateModule;
import com.jme.util.export.binary.modules.BinaryFogStateModule;
import com.jme.util.export.binary.modules.BinaryFragmentProgramStateModule;
import com.jme.util.export.binary.modules.BinaryGLSLShaderObjectsStateModule;
import com.jme.util.export.binary.modules.BinaryLightStateModule;
import com.jme.util.export.binary.modules.BinaryMaterialStateModule;
import com.jme.util.export.binary.modules.BinaryShadeStateModule;
import com.jme.util.export.binary.modules.BinaryStencilStateModule;
import com.jme.util.export.binary.modules.BinaryTextureStateModule;
import com.jme.util.export.binary.modules.BinaryVertexProgramStateModule;
import com.jme.util.export.binary.modules.BinaryWireframeStateModule;
import com.jme.util.export.binary.modules.BinaryZBufferStateModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

public class BinaryClassLoader {
    private static HashMap<String, BinaryLoaderModule> modules = new HashMap();

    public static void registerModule(BinaryLoaderModule binaryLoaderModule) {
        modules.put(binaryLoaderModule.getKey(), binaryLoaderModule);
    }

    public static void unregisterModule(BinaryLoaderModule binaryLoaderModule) {
        modules.remove(binaryLoaderModule.getKey());
    }

    public static Savable fromName(String string, InputCapsule inputCapsule) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        BinaryLoaderModule binaryLoaderModule = modules.get(string);
        if (binaryLoaderModule != null) {
            return binaryLoaderModule.load(inputCapsule);
        }
        try {
            return (Savable)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(BinaryClassLoader.class.getName()).severe("Could not access constructor of class '" + string + "'! \n" + "Some types need to have the BinaryImporter set up in a special way. Please doublecheck the setup.");
            throw instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(BinaryClassLoader.class.getName()).severe(illegalAccessException.getMessage() + " \n" + "Some types need to have the BinaryImporter set up in a special way. Please doublecheck the setup.");
            throw illegalAccessException;
        }
    }

    static {
        BinaryClassLoader.registerModule(new BinaryAbstractCameraModule());
        BinaryClassLoader.registerModule(new BinaryAlphaStateModule());
        BinaryClassLoader.registerModule(new BinaryAttributeStateModule());
        BinaryClassLoader.registerModule(new BinaryClipStateModule());
        BinaryClassLoader.registerModule(new BinaryColorMaskStateModule());
        BinaryClassLoader.registerModule(new BinaryCullStateModule());
        BinaryClassLoader.registerModule(new BinaryDitherStateModule());
        BinaryClassLoader.registerModule(new BinaryFogStateModule());
        BinaryClassLoader.registerModule(new BinaryFragmentProgramStateModule());
        BinaryClassLoader.registerModule(new BinaryGLSLShaderObjectsStateModule());
        BinaryClassLoader.registerModule(new BinaryLightStateModule());
        BinaryClassLoader.registerModule(new BinaryMaterialStateModule());
        BinaryClassLoader.registerModule(new BinaryShadeStateModule());
        BinaryClassLoader.registerModule(new BinaryStencilStateModule());
        BinaryClassLoader.registerModule(new BinaryTextureStateModule());
        BinaryClassLoader.registerModule(new BinaryVertexProgramStateModule());
        BinaryClassLoader.registerModule(new BinaryWireframeStateModule());
        BinaryClassLoader.registerModule(new BinaryZBufferStateModule());
    }
}

