/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl.records;

import com.jme.renderer.ColorRGBA;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.util.geom.BufferUtils;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.GL11;

public class RendererRecord
extends StateRecord {
    private int matrixMode = -1;
    private int currentElementVboId = -1;
    private int currentVboId = -1;
    private boolean matrixValid;
    private boolean vboValid;
    private boolean elementVboValid;
    private transient ColorRGBA tempColor = new ColorRGBA();
    private ArrayList<Integer> vboCleanupCache = new ArrayList();
    private IntBuffer idBuff = BufferUtils.createIntBuffer(16);

    public void switchMode(int n) {
        if (!this.matrixValid || this.matrixMode != n) {
            GL11.glMatrixMode((int)n);
            this.matrixMode = n;
            this.matrixValid = true;
        }
    }

    public void setCurrentColor(ColorRGBA colorRGBA) {
        GL11.glColor4f((float)colorRGBA.r, (float)colorRGBA.g, (float)colorRGBA.b, (float)colorRGBA.a);
    }

    public void setBoundVBO(int n) {
        if (!this.vboValid || this.currentVboId != n) {
            ARBBufferObject.glBindBufferARB((int)34962, (int)n);
            this.currentVboId = n;
            this.vboValid = true;
        }
    }

    public void setBoundElementVBO(int n) {
        if (!this.elementVboValid || this.currentElementVboId != n) {
            ARBBufferObject.glBindBufferARB((int)34963, (int)n);
            this.currentElementVboId = n;
            this.elementVboValid = true;
        }
    }

    public void setCurrentColor(float f, float f2, float f3, float f4) {
        this.tempColor.set(f, f2, f3, f4);
        this.setCurrentColor(this.tempColor);
    }

    public void invalidate() {
        this.invalidateMatrix();
        this.invalidateVBO();
        this.tempColor.set(-1.0f, -1.0f, -1.0f, -1.0f);
    }

    public void validate() {
    }

    public void invalidateMatrix() {
        this.matrixValid = false;
        this.matrixMode = -1;
    }

    public void invalidateVBO() {
        this.vboValid = false;
        this.elementVboValid = false;
        this.currentVboId = -1;
        this.currentElementVboId = -1;
    }

    public int makeVBOId() {
        this.idBuff.rewind();
        ARBBufferObject.glGenBuffersARB((IntBuffer)this.idBuff);
        int n = this.idBuff.get(0);
        this.vboCleanupCache.add(n);
        return n;
    }

    public void deleteVBOId(int n) {
        this.idBuff.rewind();
        this.idBuff.put(n).flip();
        ARBBufferObject.glDeleteBuffersARB((IntBuffer)this.idBuff);
        this.vboCleanupCache.remove((Object)n);
    }

    public void cleanupVBOs() {
        int n = this.vboCleanupCache.size();
        while (--n >= 0) {
            this.deleteVBOId(this.vboCleanupCache.get(n));
        }
    }
}

