/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class BillboardNode
extends Node {
    private static final long serialVersionUID = 1L;
    private float lastTime;
    private Matrix3f orient;
    private Vector3f look;
    private Vector3f left;
    private int alignment;
    public static final int SCREEN_ALIGNED = 0;
    public static final int AXIAL = 1;
    public static final int AXIAL_Y = 1;
    public static final int CAMERA_ALIGNED = 2;
    public static final int AXIAL_Z = 3;

    public BillboardNode() {
    }

    public BillboardNode(String string) {
        super(string);
        this.orient = new Matrix3f();
        this.look = new Vector3f();
        this.left = new Vector3f();
        this.alignment = 0;
    }

    public void updateWorldData(float f) {
        this.lastTime = 0.0f;
        super.updateWorldData(f);
    }

    public void draw(Renderer renderer) {
        Camera camera = renderer.getCamera();
        this.rotateBillboard(camera);
        super.draw(renderer);
    }

    public void rotateBillboard(Camera camera) {
        this.updateWorldVectors();
        switch (this.alignment) {
            case 1: {
                this.rotateAxial(camera, Vector3f.UNIT_Y);
                break;
            }
            case 3: {
                this.rotateAxial(camera, Vector3f.UNIT_Z);
                break;
            }
            case 0: {
                this.rotateScreenAligned(camera);
                break;
            }
            case 2: {
                this.rotateCameraAligned(camera);
            }
        }
        if (this.children == null) {
            return;
        }
        int n = this.getChildren().size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.getChildren().get(i);
            if (spatial == null) continue;
            spatial.updateGeometricState(this.lastTime, false);
        }
    }

    private void rotateCameraAligned(Camera camera) {
        this.look.set(camera.getLocation()).subtractLocal(this.worldTranslation);
        Vector3f vector3f = this.left;
        vector3f.set(this.look.x, 0.0f, this.look.z);
        if (vector3f.equals(Vector3f.ZERO)) {
            return;
        }
        this.look.normalizeLocal();
        vector3f.normalizeLocal();
        float f = this.look.dot(vector3f);
        this.orient.m00 = vector3f.z;
        this.orient.m01 = vector3f.x * -this.look.y;
        this.orient.m02 = vector3f.x * f;
        this.orient.m10 = 0.0f;
        this.orient.m11 = f;
        this.orient.m12 = this.look.y;
        this.orient.m20 = -vector3f.x;
        this.orient.m21 = vector3f.z * -this.look.y;
        this.orient.m22 = vector3f.z * f;
        this.worldRotation.apply(this.orient);
    }

    private void rotateScreenAligned(Camera camera) {
        this.look.set(camera.getDirection()).negateLocal();
        this.left.set(camera.getLeft()).negateLocal();
        this.orient.fromAxes(this.left, camera.getUp(), this.look);
        this.worldRotation.fromRotationMatrix(this.orient);
    }

    private void rotateAxial(Camera camera, Vector3f vector3f) {
        this.look.set(camera.getLocation()).subtractLocal(this.worldTranslation);
        this.worldRotation.mult(this.look, this.left);
        this.left.x *= 1.0f / this.worldScale.x;
        this.left.y *= 1.0f / this.worldScale.y;
        this.left.z *= 1.0f / this.worldScale.z;
        float f = this.left.x * this.left.x + this.left.z * this.left.z;
        if (f < 1.1920929E-7f) {
            return;
        }
        float f2 = FastMath.invSqrt(f);
        if (vector3f.y == 1.0f) {
            this.left.x *= f2;
            this.left.y = 0.0f;
            this.left.z *= f2;
            this.orient.m00 = this.left.z;
            this.orient.m01 = 0.0f;
            this.orient.m02 = this.left.x;
            this.orient.m10 = 0.0f;
            this.orient.m11 = 1.0f;
            this.orient.m12 = 0.0f;
            this.orient.m20 = -this.left.x;
            this.orient.m21 = 0.0f;
            this.orient.m22 = this.left.z;
        } else if (vector3f.z == 1.0f) {
            this.left.x *= f2;
            this.left.y *= f2;
            this.left.z = 0.0f;
            this.orient.m00 = this.left.y;
            this.orient.m01 = this.left.x;
            this.orient.m02 = 0.0f;
            this.orient.m10 = -this.left.y;
            this.orient.m11 = this.left.x;
            this.orient.m12 = 0.0f;
            this.orient.m20 = 0.0f;
            this.orient.m21 = 0.0f;
            this.orient.m22 = 1.0f;
        }
        this.worldRotation.apply(this.orient);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.orient, "orient", new Matrix3f());
        outputCapsule.write(this.look, "look", Vector3f.ZERO);
        outputCapsule.write(this.left, "left", Vector3f.ZERO);
        outputCapsule.write(this.alignment, "alignment", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.orient = (Matrix3f)inputCapsule.readSavable("orient", new Matrix3f());
        this.look = (Vector3f)inputCapsule.readSavable("look", Vector3f.ZERO.clone());
        this.left = (Vector3f)inputCapsule.readSavable("left", Vector3f.ZERO.clone());
        this.alignment = inputCapsule.readInt("alignment", 0);
    }
}

