/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.pass;

import com.jme.renderer.RenderContext;
import com.jme.renderer.Renderer;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class Pass
implements Serializable {
    protected ArrayList<Spatial> spatials = new ArrayList();
    protected boolean enabled = true;
    protected float zFactor;
    protected float zOffset;
    protected RenderState[] passStates = new RenderState[17];
    protected RenderState[] savedStates = new RenderState[17];
    protected RenderContext context = null;

    public final void renderPass(Renderer renderer) {
        if (!this.enabled) {
            return;
        }
        this.context = DisplaySystem.getDisplaySystem().getCurrentContext();
        this.applyPassStates();
        renderer.setPolygonOffset(this.zFactor, this.zOffset);
        this.doRender(renderer);
        renderer.clearPolygonOffset();
        this.resetOldStates();
        this.context = null;
    }

    public void setPassState(RenderState renderState) {
        this.passStates[renderState.getType()] = renderState;
    }

    public void clearPassState(int n) {
        this.passStates[n] = null;
    }

    public void clearPassStates() {
        for (int i = 0; i < this.passStates.length; ++i) {
            this.passStates[i] = null;
        }
    }

    protected void applyPassStates() {
        int n = 17;
        while (--n >= 0) {
            if (this.passStates[n] == null) continue;
            this.savedStates[n] = this.context.enforcedStateList[n];
            this.context.enforcedStateList[n] = this.passStates[n];
        }
    }

    protected abstract void doRender(Renderer var1);

    protected void resetOldStates() {
        int n = 17;
        while (--n >= 0) {
            if (this.passStates[n] == null) continue;
            this.context.enforcedStateList[n] = this.savedStates[n];
        }
    }

    public final void updatePass(float f) {
        if (!this.enabled) {
            return;
        }
        this.doUpdate(f);
    }

    protected void doUpdate(float f) {
    }

    public void add(Spatial spatial) {
        this.spatials.add(spatial);
    }

    public Spatial get(int n) {
        return this.spatials.get(n);
    }

    public boolean contains(Spatial spatial) {
        return this.spatials.contains(spatial);
    }

    public boolean remove(Spatial spatial) {
        return this.spatials.remove(spatial);
    }

    public int size() {
        return this.spatials.size();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public float getZFactor() {
        return this.zFactor;
    }

    public void setZFactor(float f) {
        this.zFactor = f;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public void setZOffset(float f) {
        this.zOffset = f;
    }

    public void cleanUp() {
    }
}

