/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.pass;

import com.jme.renderer.Renderer;
import com.jme.renderer.pass.Pass;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.LightState;
import java.util.ArrayList;

public class LightMaskedRenderPass
extends Pass {
    private static final long serialVersionUID = 1L;
    protected ArrayList<LightState> lightStates = new ArrayList();
    protected int mask = 0;

    public void doRender(Renderer renderer) {
        int n = this.spatials.size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = (Spatial)this.spatials.get(i);
            this.maskLightStates(spatial);
            renderer.draw(spatial);
        }
        renderer.renderQueue();
        this.unmaskLightStates();
        this.lightStates.clear();
    }

    private void maskLightStates(Spatial spatial) {
        ArrayList<Spatial> arrayList;
        Spatial spatial2;
        if ((spatial.getType() & 2) != 0) {
            spatial2 = (Geometry)spatial;
            for (int i = 0; i < ((Geometry)spatial2).getBatchCount(); ++i) {
                LightState lightState = (LightState)((Geometry)spatial2).getBatch((int)i).states[3];
                if (lightState == null || this.lightStates.contains(lightState)) continue;
                this.lightStates.add(lightState);
                lightState.pushLightMask();
                lightState.setLightMask(this.mask);
            }
        }
        if ((spatial.getType() & 1) != 0 && (arrayList = ((Node)(spatial2 = (Node)spatial)).getChildren()) != null) {
            int n = arrayList.size();
            while (--n >= 0) {
                Spatial spatial3 = arrayList.get(n);
                this.maskLightStates(spatial3);
            }
        }
    }

    private void unmaskLightStates() {
        int n = this.lightStates.size();
        while (--n >= 0) {
            LightState lightState = this.lightStates.get(n);
            lightState.popLightMask();
        }
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int n) {
        this.mask = n;
    }
}

