/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer;

import com.jme.math.FastMath;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ColorRGBA
implements Externalizable,
Savable {
    private static final long serialVersionUID = 1L;
    public static final ColorRGBA black = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA white = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorRGBA darkGray = new ColorRGBA(0.2f, 0.2f, 0.2f, 1.0f);
    public static final ColorRGBA gray = new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f);
    public static final ColorRGBA lightGray = new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f);
    public static final ColorRGBA red = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA green = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    public static final ColorRGBA blue = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    public static final ColorRGBA yellow = new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f);
    public static final ColorRGBA magenta = new ColorRGBA(1.0f, 0.0f, 1.0f, 1.0f);
    public static final ColorRGBA cyan = new ColorRGBA(0.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorRGBA orange = new ColorRGBA(0.9843137f, 0.50980395f, 0.0f, 1.0f);
    public static final ColorRGBA brown = new ColorRGBA(0.25490198f, 0.15686275f, 0.09803922f, 1.0f);
    public static final ColorRGBA pink = new ColorRGBA(1.0f, 0.68f, 0.68f, 1.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public ColorRGBA() {
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
    }

    public ColorRGBA(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
        this.clamp();
    }

    public ColorRGBA(ColorRGBA colorRGBA) {
        this.a = colorRGBA.a;
        this.r = colorRGBA.r;
        this.g = colorRGBA.g;
        this.b = colorRGBA.b;
        this.clamp();
    }

    public void set(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
        this.clamp();
    }

    public ColorRGBA set(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.a = 0.0f;
        } else {
            this.r = colorRGBA.r;
            this.g = colorRGBA.g;
            this.b = colorRGBA.b;
            this.a = colorRGBA.a;
        }
        return this;
    }

    public void clamp() {
        if (this.r < 0.0f) {
            this.r = 0.0f;
        } else if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        } else if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        } else if (this.b > 1.0f) {
            this.b = 1.0f;
        }
        if (this.a < 0.0f) {
            this.a = 0.0f;
        } else if (this.a > 1.0f) {
            this.a = 1.0f;
        }
    }

    public float[] getColorArray() {
        float[] fArray = new float[]{this.r, this.g, this.b, this.a};
        return fArray;
    }

    public float[] getColorArray(float[] fArray) {
        fArray[0] = this.r;
        fArray[1] = this.g;
        fArray[2] = this.b;
        fArray[3] = this.a;
        return fArray;
    }

    public void interpolate(ColorRGBA colorRGBA, float f) {
        this.r = (1.0f - f) * this.r + f * colorRGBA.r;
        this.g = (1.0f - f) * this.g + f * colorRGBA.g;
        this.b = (1.0f - f) * this.b + f * colorRGBA.b;
        this.a = (1.0f - f) * this.a + f * colorRGBA.a;
    }

    public void interpolate(ColorRGBA colorRGBA, ColorRGBA colorRGBA2, float f) {
        this.r = (1.0f - f) * colorRGBA.r + f * colorRGBA2.r;
        this.g = (1.0f - f) * colorRGBA.g + f * colorRGBA2.g;
        this.b = (1.0f - f) * colorRGBA.b + f * colorRGBA2.b;
        this.a = (1.0f - f) * colorRGBA.a + f * colorRGBA2.a;
    }

    public static ColorRGBA randomColor() {
        ColorRGBA colorRGBA = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        colorRGBA.r = FastMath.nextRandomFloat();
        colorRGBA.g = FastMath.nextRandomFloat();
        colorRGBA.b = FastMath.nextRandomFloat();
        colorRGBA.clamp();
        return colorRGBA;
    }

    public ColorRGBA mult(ColorRGBA colorRGBA) {
        return new ColorRGBA(colorRGBA.r * this.r, colorRGBA.g * this.g, colorRGBA.b * this.b, colorRGBA.a * this.a);
    }

    public ColorRGBA multLocal(float f) {
        this.r *= f;
        this.g *= f;
        this.b *= f;
        this.a *= f;
        return this;
    }

    public ColorRGBA add(ColorRGBA colorRGBA) {
        return new ColorRGBA(colorRGBA.r + this.r, colorRGBA.g + this.g, colorRGBA.b + this.b, colorRGBA.a + this.a);
    }

    public ColorRGBA addLocal(ColorRGBA colorRGBA) {
        this.set(colorRGBA.r + this.r, colorRGBA.g + this.g, colorRGBA.b + this.b, colorRGBA.a + this.a);
        return this;
    }

    public String toString() {
        return "com.jme.renderer.ColorRGBA: [R=" + this.r + ", G=" + this.g + ", B=" + this.b + ", A=" + this.a + "]";
    }

    public ColorRGBA clone() {
        return new ColorRGBA(this.r, this.g, this.b, this.a);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorRGBA)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ColorRGBA colorRGBA = (ColorRGBA)object;
        if (Float.compare(this.r, colorRGBA.r) != 0) {
            return false;
        }
        if (Float.compare(this.g, colorRGBA.g) != 0) {
            return false;
        }
        if (Float.compare(this.b, colorRGBA.b) != 0) {
            return false;
        }
        return Float.compare(this.a, colorRGBA.a) == 0;
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Float.floatToIntBits(this.r);
        n += 37 * n + Float.floatToIntBits(this.g);
        n += 37 * n + Float.floatToIntBits(this.b);
        n += 37 * n + Float.floatToIntBits(this.a);
        return n;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.r = objectInput.readFloat();
        this.g = objectInput.readFloat();
        this.b = objectInput.readFloat();
        this.a = objectInput.readFloat();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.r);
        objectOutput.writeFloat(this.g);
        objectOutput.writeFloat(this.b);
        objectOutput.writeFloat(this.a);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.r, "r", 0.0f);
        outputCapsule.write(this.g, "g", 0.0f);
        outputCapsule.write(this.b, "b", 0.0f);
        outputCapsule.write(this.a, "a", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.r = inputCapsule.readFloat("r", 0.0f);
        this.g = inputCapsule.readFloat("g", 0.0f);
        this.b = inputCapsule.readFloat("b", 0.0f);
        this.a = inputCapsule.readFloat("a", 0.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public int asIntARGB() {
        int n = ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
        return n;
    }

    public int asIntRGBA() {
        int n = ((int)(this.r * 255.0f) & 0xFF) << 24 | ((int)(this.g * 255.0f) & 0xFF) << 16 | ((int)(this.b * 255.0f) & 0xFF) << 8 | (int)(this.a * 255.0f) & 0xFF;
        return n;
    }

    public void fromIntARGB(int n) {
        this.a = (float)((byte)(n >> 24) & 0xFF) / 255.0f;
        this.r = (float)((byte)(n >> 16) & 0xFF) / 255.0f;
        this.g = (float)((byte)(n >> 8) & 0xFF) / 255.0f;
        this.b = (float)((byte)n & 0xFF) / 255.0f;
    }

    public void fromIntRGBA(int n) {
        this.r = (float)((byte)(n >> 24) & 0xFF) / 255.0f;
        this.g = (float)((byte)(n >> 16) & 0xFF) / 255.0f;
        this.b = (float)((byte)(n >> 8) & 0xFF) / 255.0f;
        this.a = (float)((byte)n & 0xFF) / 255.0f;
    }
}

