/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class SpotLight
extends PointLight {
    private static final long serialVersionUID = 1L;
    private float angle;
    private float exponent;
    private Vector3f direction = new Vector3f();

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f vector3f) {
        this.direction = vector3f;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        if (f < 0.0f || f > 90.0f && f != 180.0f) {
            throw new JmeException("invalid angle.  Angle must be between 0 and 90, or 180");
        }
        this.angle = f;
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setExponent(float f) {
        this.exponent = f;
    }

    public int getType() {
        return 2;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.direction, "direction", Vector3f.ZERO);
        outputCapsule.write(this.angle, "angle", 0.0f);
        outputCapsule.write(this.exponent, "exponent", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.direction = (Vector3f)inputCapsule.readSavable("direction", Vector3f.ZERO.clone());
        this.angle = inputCapsule.readFloat("angle", 0.0f);
        this.exponent = inputCapsule.readFloat("exponent", 0.0f);
    }
}

