/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.thirdperson;

import com.jme.input.ChaseCamera;
import com.jme.input.InputHandler;
import com.jme.input.MouseInput;
import com.jme.input.RelativeMouse;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.MouseInputAction;
import com.jme.input.thirdperson.ThirdPersonJoystickPlugin;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import java.util.HashMap;

public class ThirdPersonMouseLook
extends MouseInputAction {
    public static final String PROP_MAXASCENT = "maxAscent";
    public static final String PROP_MINASCENT = "minAscent";
    public static final String PROP_MAXROLLOUT = "maxRollOut";
    public static final String PROP_MINROLLOUT = "minRollOut";
    public static final String PROP_MOUSEXMULT = "mouseXMult";
    public static final String PROP_MOUSEYMULT = "mouseYMult";
    public static final String PROP_MOUSEROLLMULT = "mouseRollMult";
    public static final String PROP_INVERTEDY = "invertedY";
    public static final String PROP_LOCKASCENT = "lockAscent";
    public static final String PROP_ROTATETARGET = "rotateTarget";
    public static final String PROP_ENABLED = "lookEnabled";
    public static final String PROP_TARGETTURNSPEED = "targetTurnSpeed";
    public static final String PROP_MOUSEBUTTON_FOR_LOOKING = "lookButton";
    public static final String PROP_INVERTROTATE = "invertRotate";
    public static final float DEFAULT_MOUSEXMULT = 2.0f;
    public static final float DEFAULT_MOUSEYMULT = 30.0f;
    public static final float DEFAULT_MOUSEROLLMULT = 50.0f;
    public static final float DEFAULT_MAXASCENT = 0.7853982f;
    public static final float DEFAULT_MINASCENT = -0.2617994f;
    public static final float DEFAULT_MAXROLLOUT = 240.0f;
    public static final float DEFAULT_MINROLLOUT = 20.0f;
    public static final float DEFAULT_TARGETTURNSPEED = (float)Math.PI * 2;
    public static final boolean DEFAULT_INVERTEDY = false;
    public static final boolean DEFAULT_LOCKASCENT = false;
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_ROTATETARGET = false;
    public static final boolean DEFAULT_INVERTROTATE = false;
    public static final int DEFAULT_MOUSEBUTTON_FOR_LOOKING = -1;
    protected float maxAscent = 0.7853982f;
    protected float minAscent = -0.2617994f;
    protected float maxRollOut = 240.0f;
    protected float minRollOut = 20.0f;
    protected float mouseXMultiplier = 2.0f;
    protected float mouseYMultiplier = 30.0f;
    protected float mouseRollMultiplier = 50.0f;
    protected float mouseXSpeed = 2.0f;
    protected float mouseYSpeed = 30.0f;
    protected float rollInSpeed = 50.0f;
    protected float targetTurnSpeed = (float)Math.PI * 2;
    protected ChaseCamera camera;
    protected Spatial target;
    protected boolean updated = false;
    protected boolean invertedY = false;
    protected boolean lockAscent = false;
    protected boolean enabled = true;
    protected boolean rotateTarget = false;
    protected boolean invertRotate = false;
    protected int lookMouse = -1;
    protected Vector3f difTemp = new Vector3f();
    protected Vector3f sphereTemp = new Vector3f();
    protected Vector3f rightTemp = new Vector3f();
    protected Quaternion rotTemp = new Quaternion();
    protected Vector3f worldUpVec = new Vector3f(ChaseCamera.DEFAULT_WORLDUPVECTOR);
    protected ThirdPersonJoystickPlugin plugin = null;

    public ThirdPersonMouseLook(RelativeMouse relativeMouse, ChaseCamera chaseCamera, Spatial spatial) {
        this.mouse = relativeMouse;
        this.camera = chaseCamera;
        this.target = spatial;
        this.setSpeed(1.0f);
    }

    public void updateProperties(HashMap hashMap) {
        this.maxAscent = InputHandler.getFloatProp(hashMap, PROP_MAXASCENT, 0.7853982f);
        this.minAscent = InputHandler.getFloatProp(hashMap, PROP_MINASCENT, -0.2617994f);
        this.maxRollOut = InputHandler.getFloatProp(hashMap, PROP_MAXROLLOUT, 240.0f);
        this.minRollOut = InputHandler.getFloatProp(hashMap, PROP_MINROLLOUT, 20.0f);
        this.targetTurnSpeed = InputHandler.getFloatProp(hashMap, PROP_TARGETTURNSPEED, (float)Math.PI * 2);
        this.setMouseXMultiplier(InputHandler.getFloatProp(hashMap, PROP_MOUSEXMULT, 2.0f));
        this.setMouseYMultiplier(InputHandler.getFloatProp(hashMap, PROP_MOUSEYMULT, 30.0f));
        this.setMouseRollMultiplier(InputHandler.getFloatProp(hashMap, PROP_MOUSEROLLMULT, 50.0f));
        this.invertedY = InputHandler.getBooleanProp(hashMap, PROP_INVERTEDY, false);
        this.lockAscent = InputHandler.getBooleanProp(hashMap, PROP_LOCKASCENT, false);
        this.rotateTarget = InputHandler.getBooleanProp(hashMap, PROP_ROTATETARGET, false);
        this.invertRotate = InputHandler.getBooleanProp(hashMap, PROP_INVERTROTATE, false);
        this.enabled = InputHandler.getBooleanProp(hashMap, PROP_ENABLED, true);
        this.lookMouse = InputHandler.getIntProp(hashMap, PROP_MOUSEBUTTON_FOR_LOOKING, -1);
        this.worldUpVec = (Vector3f)InputHandler.getObjectProp(hashMap, "worldUpVec", ChaseCamera.DEFAULT_WORLDUPVECTOR);
    }

    public void setSpeed(float f) {
        super.setSpeed(f);
        this.mouseXSpeed = this.mouseXMultiplier * f;
        this.mouseYSpeed = this.mouseYMultiplier * f;
        this.rollInSpeed = this.mouseRollMultiplier * f;
    }

    public void performAction(InputActionEvent inputActionEvent) {
        if (!this.enabled) {
            return;
        }
        float f = 0.01f;
        if (this.lookMouse == -1 || MouseInput.get().isButtonDown(this.lookMouse)) {
            float f2;
            this.camera.setLooking(true);
            if (this.mouse.getLocalTranslation().x != 0.0f) {
                f2 = this.invertRotate ? -f * this.mouse.getLocalTranslation().x : f * this.mouse.getLocalTranslation().x;
                this.rotateRight(f2, f);
                this.updated = true;
            } else if (this.rotateTarget) {
                this.rotateRight(0.0f, f);
            }
            if (!this.lockAscent && this.mouse.getLocalTranslation().y != 0.0f) {
                f2 = f * this.mouse.getLocalTranslation().y;
                this.rotateUp(f2);
                this.updated = true;
            }
        } else {
            this.camera.setLooking(false);
        }
        this.updateFromJoystick(f);
        int n = MouseInput.get().getWheelDelta();
        if (n != 0) {
            float f3 = f * (float)(-n);
            this.rollIn(f3);
            this.updated = true;
        }
        if (this.updated) {
            this.camera.getCamera().onFrameChange();
        }
    }

    protected void updateFromJoystick(float f) {
        if (this.plugin != null) {
            float f2 = this.plugin.getJoystick().getAxisValue(this.plugin.getRotateAxis());
            float f3 = this.plugin.getJoystick().getAxisValue(this.plugin.getAscentAxis());
            if (f2 != 0.0f) {
                this.rotateRight(f2 * 0.02f, f);
                this.updated = true;
            }
            if (!this.lockAscent && f3 != 0.0f) {
                this.rotateUp(-f3 * 0.02f);
                this.updated = true;
            }
        }
    }

    private void rotateRight(float f, float f2) {
        float f3;
        Vector3f vector3f = this.camera.getCamera().getLocation();
        Vector3f vector3f2 = this.target.getWorldTranslation();
        float f4 = f * this.mouseXSpeed;
        this.difTemp.set(vector3f).subtractLocal(vector3f2);
        if (this.worldUpVec.z == 1.0f) {
            f3 = this.difTemp.y;
            this.difTemp.y = this.difTemp.z;
            this.difTemp.z = f3;
        }
        FastMath.cartesianToSpherical(this.difTemp, this.sphereTemp);
        this.sphereTemp.y = FastMath.normalize(this.sphereTemp.y + f4, (float)Math.PI * -2, (float)Math.PI * 2);
        FastMath.sphericalToCartesian(this.sphereTemp, this.rightTemp);
        if (this.worldUpVec.z == 1.0f) {
            f3 = this.rightTemp.y;
            this.rightTemp.y = this.rightTemp.z;
            this.rightTemp.z = f3;
        }
        this.rightTemp.addLocal(vector3f2);
        vector3f.set(this.rightTemp);
        if (this.camera.isMaintainAzimuth()) {
            this.camera.setForceAzimuthUpdate(true);
        }
        if (this.rotateTarget) {
            this.target.getLocalRotation().getRotationColumn(0, this.rightTemp);
            this.rightTemp.normalizeLocal();
            this.difTemp.y = 0.0f;
            this.difTemp.negateLocal().normalizeLocal();
            f3 = this.rightTemp.angleBetween(this.difTemp);
            float f5 = this.targetTurnSpeed * f2;
            if (f3 < 0.0f && -f5 > f3) {
                f3 = -f5;
            } else if (f3 > 0.0f && f5 < f3) {
                f3 = f5;
            }
            Vector3f vector3f3 = this.rightTemp.crossLocal(this.difTemp).normalizeLocal();
            Quaternion quaternion = this.rotTemp;
            quaternion.fromAngleNormalAxis(f3, vector3f3);
            quaternion.mult(this.target.getLocalRotation(), this.target.getLocalRotation());
        }
    }

    private void rotateUp(float f) {
        if (this.invertedY) {
            f *= -1.0f;
        }
        Vector3f vector3f = this.camera.getCamera().getLocation();
        Vector3f vector3f2 = this.target.getWorldTranslation();
        float f2 = f * this.mouseYSpeed;
        this.difTemp.set(vector3f).subtractLocal(vector3f2).subtractLocal(this.camera.getTargetOffset());
        if (this.worldUpVec.z == 1.0f) {
            float f3 = this.difTemp.y;
            this.difTemp.y = this.difTemp.z;
            this.difTemp.z = f3;
        }
        FastMath.cartesianToSpherical(this.difTemp, this.sphereTemp);
        this.camera.getIdealSphereCoords().z = this.clampUpAngle(this.sphereTemp.z + f2);
    }

    private void rollIn(float f) {
        this.camera.getIdealSphereCoords().x = this.clampRollIn(this.camera.getIdealSphereCoords().x + f * this.rollInSpeed);
    }

    private float clampUpAngle(float f) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            return f;
        }
        if (f > this.maxAscent) {
            f = this.maxAscent;
        } else if (f < this.minAscent) {
            f = this.minAscent;
        }
        return f;
    }

    private float clampRollIn(float f) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            return 100.0f;
        }
        if (f > this.maxRollOut) {
            f = this.maxRollOut;
        } else if (f < this.minRollOut) {
            f = this.minRollOut;
        }
        return f;
    }

    public void setInvertedY(boolean bl) {
        this.invertedY = bl;
    }

    public boolean isInvertedY() {
        return this.invertedY;
    }

    public float getMaxAscent() {
        return this.maxAscent;
    }

    public void setMaxAscent(float f) {
        this.maxAscent = f;
        this.rotateUp(0.0f);
    }

    public float getMinAscent() {
        return this.minAscent;
    }

    public void setMinAscent(float f) {
        this.minAscent = f;
        this.rotateUp(0.0f);
    }

    public float getMaxRollOut() {
        return this.maxRollOut;
    }

    public void setMaxRollOut(float f) {
        this.maxRollOut = f;
        this.rollIn(0.0f);
    }

    public float getMinRollOut() {
        return this.minRollOut;
    }

    public void setMinRollOut(float f) {
        this.minRollOut = f;
        this.rollIn(0.0f);
    }

    public float getTargetTurnSpeed() {
        return this.targetTurnSpeed;
    }

    public void setTargetTurnSpeed(float f) {
        this.targetTurnSpeed = f;
    }

    public float getMouseXMultiplier() {
        return this.mouseXMultiplier;
    }

    public void setMouseXMultiplier(float f) {
        this.mouseXMultiplier = f;
        this.mouseXSpeed = this.speed * f;
    }

    public float getMouseYMultiplier() {
        return this.mouseYMultiplier;
    }

    public void setMouseYMultiplier(float f) {
        this.mouseYMultiplier = f;
        this.mouseYSpeed = this.speed * f;
    }

    public float getMouseRollMultiplier() {
        return this.mouseRollMultiplier;
    }

    public void setMouseRollMultiplier(float f) {
        this.mouseRollMultiplier = f;
        this.rollInSpeed = this.speed * f;
    }

    public void setLockAscent(boolean bl) {
        this.lockAscent = bl;
    }

    public boolean isLockAscent() {
        return this.lockAscent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isRotateTarget() {
        return this.rotateTarget;
    }

    public void setRotateTarget(boolean bl) {
        this.rotateTarget = bl;
    }

    public int getLookMouseButton() {
        return this.lookMouse;
    }

    public void setLookMouseButton(int n) {
        this.lookMouse = n;
    }

    public void setWorldUpVec(Vector3f vector3f) {
        this.worldUpVec.set(vector3f);
    }

    public ThirdPersonJoystickPlugin getJoystickPlugin() {
        return this.plugin;
    }

    public void setJoystickPlugin(ThirdPersonJoystickPlugin thirdPersonJoystickPlugin) {
        this.plugin = thirdPersonJoystickPlugin;
    }

    public ChaseCamera getChaseCamera() {
        return this.camera;
    }

    public void setChaseCamera(ChaseCamera chaseCamera) {
        this.camera = chaseCamera;
    }

    public Spatial getTarget() {
        return this.target;
    }

    public void setTarget(Spatial spatial) {
        this.target = spatial;
    }
}

