/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.KeyInputAction;
import com.jme.input.thirdperson.MovementPermitter;
import com.jme.input.thirdperson.ThirdPersonBackwardAction;
import com.jme.input.thirdperson.ThirdPersonForwardAction;
import com.jme.input.thirdperson.ThirdPersonJoystickPlugin;
import com.jme.input.thirdperson.ThirdPersonLeftAction;
import com.jme.input.thirdperson.ThirdPersonRightAction;
import com.jme.input.thirdperson.ThirdPersonStrafeLeftAction;
import com.jme.input.thirdperson.ThirdPersonStrafeRightAction;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Spatial;
import java.util.HashMap;

public class ThirdPersonHandler
extends InputHandler {
    public static final String PROP_TURNSPEED = "turnSpeed";
    public static final String PROP_DOGRADUAL = "doGradual";
    public static final String PROP_ROTATEONLY = "rotateOnly";
    public static final String PROP_PERMITTER = "permitter";
    public static final String PROP_UPVECTOR = "upVector";
    public static final String PROP_LOCKBACKWARDS = "lockBackwards";
    public static final String PROP_CAMERAALIGNEDMOVE = "cameraAlignedMovement";
    public static final String PROP_STRAFETARGETALIGN = "targetAlignStrafe";
    public static final String PROP_KEY_FORWARD = "fwdKey";
    public static final String PROP_KEY_BACKWARD = "backKey";
    public static final String PROP_KEY_LEFT = "leftKey";
    public static final String PROP_KEY_RIGHT = "rightKey";
    public static final String PROP_KEY_STRAFELEFT = "strfLeftKey";
    public static final String PROP_KEY_STRAFERIGHT = "strfRightKey";
    public static final float DEFAULT_TURNSPEED = 4.712389f;
    public static float angleEpsilon = 0.001f;
    protected float speed = 0.0f;
    protected Spatial targetSpatial;
    protected Vector3f prevLoc = new Vector3f();
    protected Quaternion prevRot = new Quaternion();
    protected Vector3f loc = new Vector3f();
    protected float faceAngle;
    protected float turnSpeed = 4.712389f;
    protected boolean doGradualRotation = true;
    protected MovementPermitter permitter;
    protected Vector3f upVector = new Vector3f(0.0f, 1.0f, 0.0f);
    protected Vector3f calcVector = new Vector3f();
    protected Camera camera;
    protected boolean lockBackwards;
    protected boolean strafeAlignTarget;
    protected boolean rotateOnly;
    protected boolean cameraAlignedMovement;
    protected boolean walkingBackwards;
    protected boolean walkingForward;
    protected boolean nowTurning;
    protected boolean nowStrafing;
    protected ThirdPersonJoystickPlugin plugin = null;
    protected KeyInputAction actionForward;
    protected KeyInputAction actionBack;
    protected KeyInputAction actionRight;
    protected KeyInputAction actionLeft;
    protected KeyInputAction actionStrafeRight;
    protected KeyInputAction actionStrafeLeft;

    public ThirdPersonHandler(Spatial spatial, Camera camera) {
        this(spatial, camera, null);
    }

    public ThirdPersonHandler(Spatial spatial, Camera camera, HashMap hashMap) {
        this.targetSpatial = spatial;
        this.camera = camera;
        this.updateProperties(hashMap);
        this.setActions();
    }

    public void updateProperties(HashMap hashMap) {
        this.turnSpeed = ThirdPersonHandler.getFloatProp(hashMap, PROP_TURNSPEED, 4.712389f);
        this.doGradualRotation = ThirdPersonHandler.getBooleanProp(hashMap, PROP_DOGRADUAL, true);
        this.lockBackwards = ThirdPersonHandler.getBooleanProp(hashMap, PROP_LOCKBACKWARDS, false);
        this.strafeAlignTarget = ThirdPersonHandler.getBooleanProp(hashMap, PROP_STRAFETARGETALIGN, false);
        this.cameraAlignedMovement = ThirdPersonHandler.getBooleanProp(hashMap, PROP_CAMERAALIGNEDMOVE, true);
        this.rotateOnly = ThirdPersonHandler.getBooleanProp(hashMap, PROP_ROTATEONLY, false);
        this.permitter = (MovementPermitter)ThirdPersonHandler.getObjectProp(hashMap, PROP_PERMITTER, null);
        this.upVector = (Vector3f)ThirdPersonHandler.getObjectProp(hashMap, PROP_UPVECTOR, Vector3f.UNIT_Y.clone());
        this.updateKeyBindings(hashMap);
    }

    public void updateKeyBindings(HashMap hashMap) {
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set(PROP_KEY_FORWARD, ThirdPersonHandler.getIntProp(hashMap, PROP_KEY_FORWARD, 17));
        keyBindingManager.set(PROP_KEY_BACKWARD, ThirdPersonHandler.getIntProp(hashMap, PROP_KEY_BACKWARD, 31));
        keyBindingManager.set(PROP_KEY_LEFT, ThirdPersonHandler.getIntProp(hashMap, PROP_KEY_LEFT, 30));
        keyBindingManager.set(PROP_KEY_RIGHT, ThirdPersonHandler.getIntProp(hashMap, PROP_KEY_RIGHT, 32));
        keyBindingManager.set(PROP_KEY_STRAFELEFT, ThirdPersonHandler.getIntProp(hashMap, PROP_KEY_STRAFELEFT, 16));
        keyBindingManager.set(PROP_KEY_STRAFERIGHT, ThirdPersonHandler.getIntProp(hashMap, PROP_KEY_STRAFERIGHT, 18));
    }

    protected void setActions() {
        this.actionForward = new ThirdPersonForwardAction(this, 100.0f);
        this.actionBack = new ThirdPersonBackwardAction(this, 100.0f);
        this.actionRight = new ThirdPersonRightAction(this, 100.0f);
        this.actionLeft = new ThirdPersonLeftAction(this, 100.0f);
        this.actionStrafeRight = new ThirdPersonStrafeRightAction(this, 100.0f);
        this.actionStrafeLeft = new ThirdPersonStrafeLeftAction(this, 100.0f);
        this.addAction((InputActionInterface)this.actionForward, PROP_KEY_FORWARD, true);
        this.addAction((InputActionInterface)this.actionBack, PROP_KEY_BACKWARD, true);
        this.addAction((InputActionInterface)this.actionRight, PROP_KEY_RIGHT, true);
        this.addAction((InputActionInterface)this.actionLeft, PROP_KEY_LEFT, true);
        this.addAction((InputActionInterface)this.actionStrafeRight, PROP_KEY_STRAFERIGHT, true);
        this.addAction((InputActionInterface)this.actionStrafeLeft, PROP_KEY_STRAFELEFT, true);
    }

    public void update(float f) {
        if (!this.isEnabled()) {
            return;
        }
        this.walkingForward = false;
        this.walkingBackwards = false;
        this.nowTurning = false;
        this.nowStrafing = false;
        this.prevLoc.set(this.targetSpatial.getLocalTranslation());
        this.loc.set(this.prevLoc);
        this.doInputUpdate(f);
        if (this.walkingBackwards && this.walkingForward && !this.nowStrafing && !this.nowTurning) {
            this.targetSpatial.getLocalTranslation().set(this.prevLoc);
            return;
        }
        this.targetSpatial.getLocalTranslation().subtract(this.loc, this.loc);
        if (!this.loc.equals(Vector3f.ZERO)) {
            float f2 = this.loc.length();
            if (f2 != 0.0f && f2 != 1.0f) {
                this.loc.divideLocal(f2);
            }
            float f3 = 0.0f;
            this.targetSpatial.getLocalRotation().getRotationColumn(2, this.calcVector);
            if (this.upVector.y == 1.0f) {
                f3 = FastMath.atan2(this.loc.z, this.loc.x);
                if (!this.nowTurning && !this.nowStrafing) {
                    this.faceAngle = FastMath.atan2(this.calcVector.z, this.calcVector.x);
                }
            } else if (this.upVector.x == 1.0f) {
                f3 = FastMath.atan2(this.loc.z, this.loc.y);
                if (!this.nowTurning && !this.nowStrafing) {
                    this.faceAngle = FastMath.atan2(this.calcVector.z, this.calcVector.y);
                }
            } else if (this.upVector.z == 1.0f) {
                f3 = FastMath.atan2(this.loc.x, this.loc.y) - 1.5707964f;
                if (!this.nowTurning && !this.nowStrafing) {
                    this.faceAngle = FastMath.atan2(this.calcVector.x, this.calcVector.y) - 1.5707964f;
                }
            }
            float f4 = this.faceAngle;
            this.calcFaceAngle(f3, f);
            if (this.nowStrafing) {
                this.faceAngle = f3;
                this.prevRot.set(this.targetSpatial.getLocalRotation());
            }
            this.targetSpatial.getLocalRotation().fromAngleNormalAxis(-(this.faceAngle - 1.5707964f), this.upVector);
            this.targetSpatial.getLocalRotation().getRotationColumn(2, this.calcVector).multLocal(f2);
            if (this.nowStrafing) {
                if (!this.strafeAlignTarget && this.cameraAlignedMovement) {
                    if (this.upVector.y == 1.0f) {
                        this.faceAngle = FastMath.atan2(this.camera.getDirection().z, this.camera.getDirection().x);
                    } else if (this.upVector.x == 1.0f) {
                        this.faceAngle = FastMath.atan2(this.camera.getDirection().z, this.camera.getDirection().y);
                    } else if (this.upVector.z == 1.0f) {
                        this.faceAngle = FastMath.atan2(this.camera.getDirection().x, this.camera.getDirection().y) - 1.5707964f;
                    }
                    this.targetSpatial.getLocalRotation().fromAngleNormalAxis(-this.faceAngle, this.upVector);
                } else {
                    this.targetSpatial.getLocalRotation().set(this.prevRot);
                    this.faceAngle = f4;
                }
            }
            this.targetSpatial.getLocalTranslation().set(this.prevLoc);
            if (this.lockBackwards && this.walkingBackwards && !this.nowStrafing) {
                this.targetSpatial.getLocalTranslation().subtractLocal(this.calcVector);
            } else if (!this.rotateOnly || !this.nowTurning || this.walkingBackwards || this.walkingForward) {
                this.targetSpatial.getLocalTranslation().addLocal(this.calcVector);
            }
        }
    }

    protected void doInputUpdate(float f) {
        super.update(f);
        this.updateFromJoystick(f);
    }

    protected void updateFromJoystick(float f) {
        if (this.plugin == null) {
            return;
        }
        float f2 = this.plugin.getJoystick().getAxisValue(this.plugin.getXAxis());
        float f3 = this.plugin.getJoystick().getAxisValue(this.plugin.getYAxis());
        InputActionEvent inputActionEvent = new InputActionEvent();
        if (f2 > 0.0f) {
            inputActionEvent.setTime(f * f2);
            this.actionRight.performAction(inputActionEvent);
        } else if (f2 < 0.0f) {
            inputActionEvent.setTime(f * -f2);
            this.actionLeft.performAction(inputActionEvent);
        }
        if (f3 > 0.0f) {
            inputActionEvent.setTime(f * f3);
            this.actionBack.performAction(inputActionEvent);
        } else if (f3 < 0.0f) {
            inputActionEvent.setTime(f * -f3);
            this.actionForward.performAction(inputActionEvent);
        }
    }

    protected void calcFaceAngle(float f, float f2) {
        if (this.doGradualRotation) {
            boolean bl;
            this.faceAngle = FastMath.normalize(this.faceAngle, (float)(-Math.PI), (float)Math.PI);
            float f3 = f;
            f -= this.faceAngle;
            if (FastMath.abs(f = FastMath.normalize(f, (float)(-Math.PI), (float)Math.PI)) <= angleEpsilon) {
                return;
            }
            boolean bl2 = bl = this.faceAngle > f3;
            if (this.lockBackwards && this.walkingBackwards) {
                if (f > angleEpsilon && f < (float)Math.PI) {
                    this.faceAngle -= f2 * this.turnSpeed;
                } else if (f < -angleEpsilon || f > (float)Math.PI) {
                    this.faceAngle += f2 * this.turnSpeed;
                }
            } else if (f > angleEpsilon && f < (float)Math.PI) {
                this.faceAngle += f2 * this.turnSpeed;
                if (!bl && this.faceAngle > f3) {
                    this.faceAngle = f3;
                }
            } else if (f < -angleEpsilon || f > (float)Math.PI) {
                this.faceAngle -= f2 * this.turnSpeed;
                if (bl && this.faceAngle < f3) {
                    this.faceAngle = f3;
                }
            }
        } else {
            this.faceAngle = this.lockBackwards && this.walkingBackwards ? (float)Math.PI + f : f;
        }
    }

    public float getTurnSpeed() {
        return this.turnSpeed;
    }

    public void setTurnSpeed(float f) {
        this.turnSpeed = f;
    }

    public Vector3f getUpVector() {
        return this.upVector;
    }

    public void setUpVector(Vector3f vector3f) {
        this.upVector.set(vector3f);
    }

    public float getFaceAngle() {
        return this.faceAngle;
    }

    public boolean isDoGradualRotation() {
        return this.doGradualRotation;
    }

    public void setDoGradualRotation(boolean bl) {
        this.doGradualRotation = bl;
    }

    public MovementPermitter getPermitter() {
        return this.permitter;
    }

    public Spatial getTarget() {
        return this.targetSpatial;
    }

    public void setTarget(Spatial spatial) {
        this.targetSpatial = spatial;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setStrafeAlignTarget(boolean bl) {
        this.strafeAlignTarget = bl;
    }

    public boolean isStrafeAlignTarget() {
        return this.strafeAlignTarget;
    }

    public void setLockBackwards(boolean bl) {
        this.lockBackwards = bl;
    }

    public boolean isLockBackwards() {
        return this.lockBackwards;
    }

    public void setRotateOnly(boolean bl) {
        this.rotateOnly = bl;
    }

    public boolean isRotateOnly() {
        return this.rotateOnly;
    }

    public void setCameraAlignedMovement(boolean bl) {
        this.cameraAlignedMovement = bl;
    }

    public boolean isCameraAlignedMovement() {
        return this.cameraAlignedMovement;
    }

    public void setGoingForward(boolean bl) {
        this.walkingForward = bl;
    }

    public void setGoingBackwards(boolean bl) {
        this.walkingBackwards = bl;
    }

    public void setTurning(boolean bl) {
        this.nowTurning = bl;
    }

    public void setStrafing(boolean bl) {
        this.nowStrafing = bl;
    }

    public boolean isNowTurning() {
        return this.nowTurning;
    }

    public boolean isWalkingBackwards() {
        return this.walkingBackwards;
    }

    public boolean isWalkingForward() {
        return this.walkingForward;
    }

    public boolean isStrafing() {
        return this.nowStrafing;
    }

    public void setActionSpeed(float f) {
        super.setActionSpeed(f);
        this.speed = f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public ThirdPersonJoystickPlugin getJoystickPlugin() {
        return this.plugin;
    }

    public void setJoystickPlugin(ThirdPersonJoystickPlugin thirdPersonJoystickPlugin) {
        this.plugin = thirdPersonJoystickPlugin;
    }
}

