/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.image.Image;
import com.jme.input.Input;
import com.jme.input.MouseInputListener;
import com.jme.input.lwjgl.LWJGLMouseInput;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MouseInput
extends Input {
    private static MouseInput instance;
    protected ArrayList<MouseInputListener> listeners;
    public static final String INPUT_LWJGL;
    public static final String INPUT_AWT = "com.jmex.awt.input.AWTMouseInput";
    private static Class provider;

    public static MouseInput get() {
        if (instance == null) {
            try {
                Constructor constructor = MouseInput.getProvider().getDeclaredConstructor(null);
                constructor.setAccessible(true);
                instance = (MouseInput)constructor.newInstance(null);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error creating input provider", exception);
            }
        }
        return instance;
    }

    public static Class getProvider() {
        return provider;
    }

    public static void setProvider(String string) {
        if (instance != null) {
            throw new IllegalStateException("Provider may only be changed before input is created!");
        }
        if ("LWJGL".equals(string)) {
            string = INPUT_LWJGL;
        } else if ("AWT".equals(string)) {
            string = INPUT_AWT;
        }
        try {
            MouseInput.setProvider(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unsupported provider: " + classNotFoundException.getMessage());
        }
    }

    public static void setProvider(Class clazz) {
        if (instance != null) {
            throw new IllegalStateException("Provider may only be changed before input is created!");
        }
        if (!MouseInput.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Specified class does not extend MouseInput");
        }
        provider = clazz;
    }

    protected abstract void destroy();

    public abstract int getButtonIndex(String var1);

    public abstract boolean isButtonDown(int var1);

    public abstract String getButtonName(int var1);

    public static boolean isInited() {
        return instance != null;
    }

    public abstract int getWheelDelta();

    public abstract int getXDelta();

    public abstract int getYDelta();

    public abstract int getXAbsolute();

    public abstract int getYAbsolute();

    @Override
    public abstract void update();

    public abstract void setCursorVisible(boolean var1);

    public abstract boolean isCursorVisible();

    public abstract void setHardwareCursor(URL var1);

    public abstract void setHardwareCursor(URL var1, int var2, int var3);

    public abstract void setHardwareCursor(URL var1, Image[] var2, int[] var3, int var4, int var5);

    public void addListener(MouseInputListener mouseInputListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(mouseInputListener);
    }

    public void removeListener(MouseInputListener mouseInputListener) {
        if (this.listeners != null) {
            this.listeners.remove(mouseInputListener);
        }
    }

    public void removeListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public boolean containsListener(MouseInputListener mouseInputListener) {
        return this.listeners != null && this.listeners.contains(mouseInputListener);
    }

    public ArrayList<MouseInputListener> getListeners() {
        return this.listeners;
    }

    public static void destroyIfInitalized() {
        if (instance != null) {
            instance.destroy();
            instance = null;
        }
    }

    public abstract int getWheelRotation();

    public abstract int getButtonCount();

    public abstract void setCursorPosition(int var1, int var2);

    static {
        INPUT_LWJGL = LWJGLMouseInput.class.getName();
        provider = LWJGLMouseInput.class;
    }
}

