/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.AbstractGame;
import com.jme.input.InputSystem;
import com.jme.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FixedFramerateGame
extends AbstractGame {
    private static final Logger logger = Logger.getLogger(FixedFramerateGame.class.getName());
    private Timer timer;
    private int frames = 0;
    private long startTime;
    private long preferredTicksPerFrame;
    private long frameStartTick;
    private long frameDurationTicks;

    public void setFrameRate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Frames per second cannot be less than one.");
        }
        logger.info("Attempting to run at " + n + " fps.");
        this.preferredTicksPerFrame = this.timer.getResolution() / (long)n;
    }

    public float getFramesPerSecond() {
        float f = (float)(this.timer.getTime() - this.startTime) / (float)this.timer.getResolution();
        float f2 = (float)this.frames / f;
        this.startTime = this.timer.getTime();
        this.frames = 0;
        return f2;
    }

    private void startFrame() {
        this.frameStartTick = this.timer.getTime();
    }

    private void endFrame() {
        ++this.frames;
        this.frameDurationTicks = this.timer.getTime() - this.frameStartTick;
        while (this.frameDurationTicks < this.preferredTicksPerFrame) {
            long l = (this.preferredTicksPerFrame - this.frameDurationTicks) * 1000L / this.timer.getResolution();
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                logger.warning("Error sleeping during main loop.");
            }
            this.frameDurationTicks = this.timer.getTime() - this.frameStartTick;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        logger.info("Application started.");
        try {
            this.getAttributes();
            this.initSystem();
            this.assertDisplayCreated();
            this.timer = Timer.getTimer();
            this.setFrameRate(60);
            this.initGame();
            while (!this.finished && !this.display.isClosing()) {
                this.startFrame();
                InputSystem.update();
                this.update(-1.0f);
                this.render(-1.0f);
                this.display.getRenderer().displayBackBuffer();
                this.endFrame();
                Thread.yield();
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "start()", "Exception in game loop", throwable);
        }
        finally {
            this.cleanup();
        }
        logger.info("Application ending.");
        this.display.reset();
        this.quit();
    }

    protected void quit() {
        if (this.display != null) {
            this.display.close();
        }
        System.exit(0);
    }

    protected abstract void update(float var1);

    protected abstract void render(float var1);

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

