/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.akjrcp.motiontools.PoseEditor;
import jp.sourceforge.akjrcp.swing.Messages;
import org.apache.commons.lang.SystemUtils;

public abstract class FileChoicer
extends JPanel {
    private JTextField text;
    private Frame frame;
    private FileFilter fileFilter;
    private String dir;

    public FileChoicer(String string) {
        this.setLayout(new FlowLayout());
        this.add(new JLabel(string));
        this.text = new JTextField();
        this.text.setEditable(false);
        this.text.setColumns(12);
        this.add(this.text);
        JButton jButton = new JButton(Messages.getString("Browse"));
        jButton.addActionListener(new PoseEditor.ErrorCatchingGLActionListener(){

            @Override
            public void doGLAction(ActionEvent actionEvent) {
                File file;
                int n;
                if (FileChoicer.this.frame == null) {
                    FileChoicer.this.frame = new Frame();
                }
                String string = "";
                if (FileChoicer.this.dir != null) {
                    string = FileChoicer.this.dir;
                }
                JFileChooser jFileChooser = new JFileChooser(string);
                if (FileChoicer.this.fileFilter != null && (double)SystemUtils.JAVA_VERSION_FLOAT > 1.6) {
                    jFileChooser.addChoosableFileFilter(FileChoicer.this.fileFilter);
                }
                if ((n = jFileChooser.showOpenDialog((Component)actionEvent.getSource())) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    FileChoicer.this.text.setText(file.getAbsolutePath());
                    FileChoicer.this.fileChanged(file.getAbsolutePath());
                }
            }
        });
        this.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("Reset"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileChoicer.this.text.setText("");
                FileChoicer.this.fileChanged("");
            }
        });
        this.add(jButton2);
    }

    protected abstract void fileChanged(String var1);

    public String getDir() {
        return this.dir;
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }
}

