/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.motiontools.utils;

import com.jme.math.Vector2f;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import md5reader.AbstractD3Reader;
import md5reader.MD5DefaultSkin;
import model.Mesh;
import model.Model;
import model.SkeletalKeyFrame;
import model.SkeletalModel;
import model.Skeleton;
import model.Skin;
import model.WeightedMesh;
import model.animation.AnimationUtils;
import model.file.ModelReader;

public class CustomMD5Reader
extends AbstractD3Reader
implements ModelReader {
    public static final String CLASSLOADER = "skin.classloader";
    public static final String DEFAULT_PREFIX = "skin.defaultprefix";
    public static final String DEFAULT_SUFFIX = "skin.defaultsuffix";
    public static final String DETAIL_PREFIX = "skin.detail.prefix";
    public static final String DETAIL_SUFFIX = "skin.detail.suffix";
    private SkeletalModel model;

    public void setProperty(String string, Object object) {
        if (this.model == null) {
            this.model = new SkeletalModel("MD5Model", 0, (Skin)new MD5DefaultSkin());
        }
        if (string.equals(CLASSLOADER)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setClassLoader((ClassLoader)object);
        } else if (string.equals(DEFAULT_PREFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setPrefix(0, (String)object);
        } else if (string.equals(DEFAULT_SUFFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setSuffix(0, (String)object);
        } else if (string.equals(DETAIL_PREFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setPrefix(1, (String)object);
        } else if (string.equals(DETAIL_SUFFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setSuffix(1, (String)object);
        }
    }

    public Model readModel(InputStream inputStream) throws IOException {
        String string;
        this.setInputStream(inputStream);
        if (this.model == null) {
            this.model = new SkeletalModel("MD5Model", 0, (Skin)new MD5DefaultSkin());
        }
        int n = 0;
        ArrayList<WeightedMesh> arrayList = new ArrayList<WeightedMesh>();
        while ((string = this.readStringStartOfLine()) != null) {
            if (string.equals("MD5Version")) {
                this.readPositiveInt();
                continue;
            }
            if (string.equals("commandline")) {
                this.skip(3);
                continue;
            }
            if (string.equals("numJoints")) {
                this.model.setSkeleton(new Skeleton(this.readPositiveInt()));
                continue;
            }
            if (string.equals("numMeshes")) {
                this.model.resetMeshCount(this.readPositiveInt());
                continue;
            }
            if (string.equals("joints")) {
                this.skip(6);
                this.loadJoints();
                continue;
            }
            if (string.equals("mesh")) {
                this.skip(6);
                WeightedMesh weightedMesh = this.loadMesh(n);
                if (weightedMesh == null) continue;
                arrayList.add(weightedMesh);
                continue;
            }
            throw new IOException("Unexpected text: " + string);
        }
        this.model.resetMeshCount(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            this.model.getMeshes()[i] = (Mesh)arrayList.get(i);
        }
        SkeletalModel skeletalModel = this.model;
        this.model = null;
        return skeletalModel;
    }

    private void loadJoints() throws IOException {
        String string;
        Skeleton skeleton = this.model.getSkeleton();
        int n = 0;
        SkeletalKeyFrame skeletalKeyFrame = skeleton.getBindFrame();
        while ((string = this.readStringStartOfLine()) != null) {
            skeleton.getJointNames()[n] = string;
            skeleton.getParents()[n] = this.readInt();
            skeletalKeyFrame.positions[n] = this.readVector3f();
            skeletalKeyFrame.rotations[n] = this.readQuaternion();
            ++n;
        }
        AnimationUtils.globalToLocal((Skeleton)skeleton);
        int[] nArray = skeleton.getParents();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0) continue;
            skeletalKeyFrame.rotations[n].set(BASE.mult(skeletalKeyFrame.rotations[n]));
        }
    }

    private WeightedMesh loadMesh(int n) throws IOException {
        String string;
        WeightedMesh weightedMesh = new WeightedMesh("Mesh");
        boolean bl = true;
        while ((string = this.readStringStartOfLine()) != null) {
            if (string.equals("shader")) {
                String string2 = this.readString();
                weightedMesh.setName(string2);
                if (string2.equals("")) {
                    System.out.println("empty shader not accepted of mesh in md5 file.modify it");
                    continue;
                }
                if (!string2.toLowerCase().endsWith(".tga")) continue;
                System.out.println("chop .tga in shader name of mesh in md5 file.modify it");
                continue;
            }
            if (string.equals("numverts")) {
                int n2 = this.readPositiveInt();
                if (n2 == 0) {
                    System.out.println("empty-mesh:");
                    bl = false;
                }
                weightedMesh.resetVertexCount(n2);
                continue;
            }
            if (string.equals("numtris")) {
                weightedMesh.resetTriangleCount(this.readPositiveInt());
                continue;
            }
            if (string.equals("numweights")) {
                weightedMesh.resetWeightCount(this.readPositiveInt());
                continue;
            }
            if (string.equals("vert")) {
                int n3 = this.readPositiveInt();
                weightedMesh.getVertexTextureCoords((int)0)[n3] = this.invert(this.readVector2f());
                weightedMesh.getVertexFirstWeight()[n3] = this.readPositiveInt();
                weightedMesh.getVertexWeightCount()[n3] = this.readPositiveInt();
                continue;
            }
            if (string.equals("tri")) {
                int n4 = this.readPositiveInt() * 3;
                weightedMesh.getTriangleCornerArray()[n4] = this.readPositiveInt();
                weightedMesh.getTriangleCornerArray()[n4 + 2] = this.readPositiveInt();
                weightedMesh.getTriangleCornerArray()[n4 + 1] = this.readPositiveInt();
                continue;
            }
            if (string.equals("weight")) {
                int n5 = this.readPositiveInt();
                weightedMesh.getWeightJoint()[n5] = this.readPositiveInt();
                weightedMesh.getWeightWeight()[n5] = this.readFloat();
                weightedMesh.getWeightOffset()[n5] = this.readVector3f();
                continue;
            }
            throw new IOException("Unexpected text: " + string);
        }
        if (bl) {
            weightedMesh.updateTriangleCorners();
            weightedMesh.updateTextureBuffer(0);
            return weightedMesh;
        }
        return null;
    }

    private Vector2f invert(Vector2f vector2f) {
        vector2f.y = 1.0f - vector2f.y;
        return vector2f;
    }
}

