/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.motiontools;

import com.jme.animation.Bone;
import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.FirstPersonHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.MouseInput;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.CameraNode;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.util.GameTaskQueueManager;
import com.jmex.awt.swingui.JMEDesktop;
import com.jmex.effects.glsl.BloomRenderPass;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import jp.sourceforge.akjrcp.motiontools.Messages;
import jp.sourceforge.akjrcp.motiontools.bone.BoneInfoDataHash;
import jp.sourceforge.akjrcp.motiontools.bone.BonePoseInfo;
import jp.sourceforge.akjrcp.motiontools.bone.BonePoseInfoData;
import jp.sourceforge.akjrcp.motiontools.bone.BonePoseInfoPanel;
import jp.sourceforge.akjrcp.motiontools.poseEditor.PoseBoneInfoDataHashContainer;
import jp.sourceforge.akjrcp.motiontools.poseEditor.PoseEditorSettingSwingWindow;
import jp.sourceforge.akjrcp.motiontools.poseEditor.PoseFileChangeListener;
import jp.sourceforge.akjrcp.motiontools.poseEditor.PoseSelectSwingWindow;
import jp.sourceforge.akjrcp.motiontools.utils.CustomMD5Reader;
import jp.sourceforge.akjrcp.motiontools.utils.MotionToolsUtils;
import model.KeyFrame;
import model.Model;
import model.SkeletalKeyFrame;
import model.SkeletalModel;
import model.SkeletalModelInstance;
import model.Skeleton;
import model.animation.Animation;
import model.animation.AnimationAnimator;
import model.animation.AnimationController;
import model.animation.SkeletalAnimation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;

public class PoseEditor
extends SimplePassGame
implements PoseBoneInfoDataHashContainer,
PoseFileChangeListener {
    private static final int MAX_RANDOMLEVEL = 50;
    private static final Logger logger = Logger.getLogger(PoseEditor.class.getName());
    private BonePoseInfoPanel boneInfoRootPanel;
    private JPanel boneInfoButtonList;
    private Node guiNode;
    private boolean boneOn;
    Node sceneRootNode;
    private JPanel infoCardLayoutPanel;
    private CardLayout infoCardLayout;
    private JCheckBox overwrite;
    private JTextField fileName;
    SkeletalModel skeltonModel;
    private AnimationController bodyAnimator;
    private SkeletalModelInstance bodyInstance;
    private Animation bodyAnimation;
    private AnimationAnimator animationAnimator;
    private SkeletalKeyFrame baseKeyFrame;
    private BonePoseInfoPanel boneInfoPanel;
    private JSlider randomLevel;
    private final int MAX_POSE_STEPS = 100;
    private JSlider poseStepsSlider;
    private int currentPoseSteps;
    private List lastOpenedData;
    private BloomRenderPass bloomRenderPass;
    private BoneInfoDataHash randomPoseDataHash;
    private BoneInfoDataHash animePoseDataHash;
    private Map<String, BonePoseInfo> boneInfoMap = new HashMap<String, BonePoseInfo>();
    private boolean enableShortcut = true;
    private Point lastClicked = new Point(0, 0);
    JFrame boneControlerFrame;
    JLabel lastSavedLabel;
    PoseEditorSettingSwingWindow settingFrame;
    PoseSelectSwingWindow poseSelectFrame;
    private boolean modelLoaded;
    private boolean doAnimation;
    float angle = 0.0f;
    float add = 1.0f;
    private BoneInfoDataHash poseInfoDataHash = new BoneInfoDataHash(new HashMap());
    private boolean doShot = false;
    private JMEDesktop desktop;
    private float blenderTurn = -90.0f;
    private float cameraNodeAngleY = 0.0f;
    private float cameraNodeAngleX = 0.0f;
    private float cameraNodeAngleZ = 0.0f;
    private float cameraNodeAngleAdd = 5.0f;
    private Quaternion blender90turn = new Quaternion(new float[]{0.0f, -1.5707964f, 0.0f});
    private Quaternion cameraAngle = new Quaternion();
    private boolean visibleControls = true;
    private CameraNode cameraNode;
    private Quad backgroundGuad;

    public static void main(String[] stringArray) {
        PoseEditor poseEditor = new PoseEditor();
        poseEditor.setDialogBehaviour(2);
        poseEditor.start();
    }

    @Override
    public void loadPose(InputStream inputStream) {
        try {
            List list = IOUtils.readLines((InputStream)inputStream);
            this.openData(list);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static BoneInfoDataHash loadDataHash(File file) {
        try {
            String string;
            List list = IOUtils.readLines((InputStream)new FileInputStream(file));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < list.size() && !(string = (String)list.get(i)).equals("#end_data"); ++i) {
                String[] stringArray;
                if (!string.startsWith("#") || string.indexOf("=") == -1 || (stringArray = string.substring(1).split("=")).length <= 1) continue;
                hashMap.put(stringArray[0], stringArray[1]);
                System.out.println("pud-data:" + stringArray[0] + "," + stringArray[1]);
            }
            return new BoneInfoDataHash(hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public void openData(List list) {
        this.lastOpenedData = list;
        try {
            int n;
            Object object;
            Object[] objectArray;
            String string;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (int i = 0; i < list.size() && !(string = (String)list.get(i)).equals("#end_data"); ++i) {
                if (!string.startsWith("#") || string.indexOf("=") == -1 || (objectArray = string.substring(1).split("=")).length <= 1) continue;
                hashMap.put(objectArray[0], objectArray[1]);
            }
            this.poseInfoDataHash = new BoneInfoDataHash(hashMap);
            String[] stringArray = this.getBoneKeyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray = this.findBonePoseInfo(stringArray[i]);
                if (objectArray != null) {
                    JButton jButton;
                    objectArray.setAngleX(this.poseInfoDataHash.getRotX(stringArray[i], (int)objectArray.getAngleX()));
                    objectArray.setAngleY(this.poseInfoDataHash.getRotY(stringArray[i], (int)objectArray.getAngleY()));
                    objectArray.setAngleZ(this.poseInfoDataHash.getRotZ(stringArray[i], (int)objectArray.getAngleZ()));
                    objectArray.setMinAngleX(this.poseInfoDataHash.getMinRotX(stringArray[i], (int)objectArray.getMinAngleX()));
                    objectArray.setMinAngleY(this.poseInfoDataHash.getMinRotY(stringArray[i], (int)objectArray.getMinAngleY()));
                    objectArray.setMinAngleZ(this.poseInfoDataHash.getMinRotZ(stringArray[i], (int)objectArray.getMinAngleZ()));
                    objectArray.setMaxAngleX(this.poseInfoDataHash.getMaxRotX(stringArray[i], (int)objectArray.getMaxAngleX()));
                    objectArray.setMaxAngleY(this.poseInfoDataHash.getMaxRotY(stringArray[i], (int)objectArray.getMaxAngleY()));
                    objectArray.setMaxAngleZ(this.poseInfoDataHash.getMaxRotZ(stringArray[i], (int)objectArray.getMaxAngleZ()));
                    objectArray.setLock(this.poseInfoDataHash.isLocked(stringArray[i]));
                    String string2 = this.poseInfoDataHash.getLabelName(stringArray[i]);
                    objectArray.setLabelName(string2);
                    if (string2 == null) {
                        string2 = stringArray[i];
                    }
                    if ((jButton = this.findBoneInfoButton(stringArray[i])) != null) {
                        jButton.setText(string2);
                    }
                    if (this.poseInfoDataHash.isDisabled(stringArray[i])) {
                        if (jButton != null) {
                            jButton.setEnabled(false);
                        }
                        if ((object = this.findBonePoseInfo(stringArray[i])) != null) {
                            object.setEnabled(false);
                        }
                    }
                    objectArray.setSyncTarget(this.findBonePoseInfo(this.poseInfoDataHash.getSyncTargetName(stringArray[i])));
                    objectArray.setSyncMirrorX(this.poseInfoDataHash.getSyncMirrorX(stringArray[i]));
                    objectArray.setSyncMirrorY(this.poseInfoDataHash.getSyncMirrorY(stringArray[i]));
                    objectArray.setSyncMirrorZ(this.poseInfoDataHash.getSyncMirrorZ(stringArray[i]));
                    continue;
                }
                logger.warning("no pose info:" + stringArray[i]);
            }
            HashMap<String, JButton> hashMap2 = new HashMap<String, JButton>();
            objectArray = this.boneInfoButtonList.getComponents();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof JButton)) continue;
                hashMap2.put(((JButton)objectArray[i]).getToolTipText(), (JButton)objectArray[i]);
                this.boneInfoButtonList.remove((Component)objectArray[i]);
            }
            String[] stringArray2 = this.poseInfoDataHash.getBoneList();
            for (n = 0; n < stringArray2.length; ++n) {
                object = (JButton)hashMap2.get(stringArray2[n]);
                if (object == null) continue;
                this.boneInfoButtonList.add((Component)object);
                hashMap2.remove(stringArray2[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                object = (JButton)hashMap2.get(stringArray[n]);
                if (object == null || !((Component)object).isEnabled()) continue;
                this.boneInfoButtonList.add((Component)object);
                hashMap2.remove(stringArray[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                object = (JButton)hashMap2.get(stringArray[n]);
                if (object == null) continue;
                this.boneInfoButtonList.add((Component)object);
                hashMap2.remove(stringArray[n]);
            }
            this.boneInfoButtonList.updateUI();
            this.boneInfoRootPanel.update();
            this.boneInfoPanel.update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.boneInfoPanel.update();
        this.poseStepsSlider.setValue(0);
    }

    private JButton findBoneInfoButton(String string) {
        Component[] componentArray = this.boneInfoButtonList.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton) || !((JButton)componentArray[i]).getToolTipText().equals(string)) continue;
            return (JButton)componentArray[i];
        }
        return null;
    }

    public void openModel(File file) {
        if (!file.exists()) {
            logger.warning("not found:" + file.getAbsolutePath());
            return;
        }
        try {
            SkeletalModel skeletalModel = (SkeletalModel)this.loadModel(file);
            logger.info("model loaded:" + skeletalModel);
            this.openModel(skeletalModel);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void openModel(URL uRL) {
        try {
            SkeletalModel skeletalModel = (SkeletalModel)this.loadModel(uRL);
            this.openModel(skeletalModel);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void openModel(SkeletalModel skeletalModel) {
        skeletalModel.getMeshes();
        this.skeltonModel = skeletalModel;
        try {
            Object object;
            BonePoseInfoData bonePoseInfoData;
            int n;
            this.baseKeyFrame = this.cloneSkeletalKeyFrame(this.skeltonModel.getBindSkeletal());
            this.bodyAnimation = this.createStillAnimation(this.skeltonModel.getSkeleton());
            BoneInfoDataHash boneInfoDataHash = this.toBoneInfoDataHash();
            String[] stringArray = this.getBoneKeyNames();
            this.boneInfoButtonList.removeAll();
            this.boneInfoMap.remove(this.boneInfoMap);
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                bonePoseInfoData = null;
                if (n == 0) {
                    bonePoseInfoData = new BonePoseInfoData(true);
                    bonePoseInfoData.setKeyName(stringArray[n]);
                    this.boneInfoRootPanel.setTargetInfo(bonePoseInfoData);
                    this.boneInfoMap.put(bonePoseInfoData.getKeyName(), bonePoseInfoData);
                    object = new JButton(stringArray[n]);
                    ((JComponent)object).setToolTipText(stringArray[n]);
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JButton jButton = (JButton)actionEvent.getSource();
                            BonePoseInfo bonePoseInfo = PoseEditor.this.findBonePoseInfo(jButton.getToolTipText());
                            if (bonePoseInfo != null) {
                                PoseEditor.this.infoCardLayout.first(PoseEditor.this.infoCardLayoutPanel);
                            } else {
                                logger.warning("no info:" + jButton.getToolTipText());
                            }
                        }
                    });
                    ((AbstractButton)object).setMargin(new Insets(3, 0, 3, 0));
                    this.boneInfoButtonList.add((Component)object);
                    continue;
                }
                object = new JButton(stringArray[n]);
                ((JComponent)object).setToolTipText(stringArray[n]);
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JButton jButton = (JButton)actionEvent.getSource();
                        BonePoseInfo bonePoseInfo = PoseEditor.this.findBonePoseInfo(jButton.getToolTipText());
                        if (bonePoseInfo != null) {
                            PoseEditor.this.boneInfoPanel.setTargetInfo(bonePoseInfo);
                            PoseEditor.this.infoCardLayout.last(PoseEditor.this.infoCardLayoutPanel);
                        } else {
                            logger.warning("no info:" + jButton.getToolTipText());
                        }
                    }
                });
                ((AbstractButton)object).setMargin(new Insets(3, 0, 3, 0));
                this.boneInfoButtonList.add((Component)object);
                bonePoseInfoData = new BonePoseInfoData(false);
                bonePoseInfoData.setKeyName(stringArray[n]);
                this.boneInfoMap.put(bonePoseInfoData.getKeyName(), bonePoseInfoData);
                if (bl) continue;
                this.boneInfoPanel.setTargetInfo(bonePoseInfoData);
                bl = true;
            }
            if (this.bodyInstance != null) {
                this.rootNode.detachChild((Spatial)this.bodyInstance);
                this.bodyInstance = null;
            }
            this.bodyInstance = new SkeletalModelInstance((Model)this.skeltonModel);
            this.bodyInstance.updateGeometricState(0.0f, true);
            this.bodyInstance.setModelBound((BoundingVolume)new BoundingBox());
            this.settingFrame.setBodyBrightTarget((Spatial)this.bodyInstance);
            MotionToolsUtils.setEmissiveState((Spatial)this.bodyInstance, (int)this.settingFrame.getBodyBright(), (int)this.settingFrame.getBodyBright(), (int)this.settingFrame.getBodyBright());
            this.bodyAnimator = this.bodyInstance.addAnimationController();
            this.animationAnimator = this.bodyAnimator.addAnimation(this.bodyAnimation);
            this.animationAnimator.setInterpolationThreshold(0.0f);
            this.bodyAnimator.update(0.0f);
            this.bodyInstance.updateModelBound();
            this.rootNode.attachChild((Spatial)this.bodyInstance);
            this.rootNode.updateRenderState();
            if (this.lastOpenedData != null) {
                this.openData(this.lastOpenedData);
                for (n = 0; n < stringArray.length; ++n) {
                    bonePoseInfoData = this.getSteppedAngles(stringArray[n], this.currentPoseSteps);
                    if (bonePoseInfoData == null || (object = this.findBonePoseInfo(stringArray[n])) == null) continue;
                    object.setAngleX(boneInfoDataHash.getRotX(stringArray[n], 0));
                    object.setAngleY(boneInfoDataHash.getRotY(stringArray[n], 0));
                    object.setAngleZ(boneInfoDataHash.getRotZ(stringArray[n], 0));
                }
                this.boneInfoPanel.update();
                this.boneInfoRootPanel.update();
                this.resetStepPoseSlider();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableKeyboardInput(boolean bl) {
        logger.info("set key input:" + bl);
        ((FirstPersonHandler)this.input).getKeyboardLookHandler().setEnabled(bl);
        this.enableShortcut = bl;
    }

    public void createDesktop() {
        this.guiNode = new Node("gui");
        this.guiNode.setRenderQueueMode(4);
        int n = 460;
        this.desktop = new JMEDesktop("desktop", 300, this.display.getHeight(), this.input);
        this.desktop.getJDesktop().setBackground(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        this.guiNode.attachChild((Spatial)this.desktop);
        this.desktop.getLocalTranslation().set((float)(this.desktop.getJDesktop().getSize().width / 2), (float)(n / 2), 0.0f);
        this.display.setTitle(Messages.getString("version"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PoseEditor.this.desktop.getJDesktop().setBackground(new Color(0.0f, 0.0f, 1.0f, 0.0f));
                JPanel jPanel = new JPanel();
                jPanel.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                jPanel.setLocation(0, 0);
                jPanel.setSize(300, 460);
                PoseEditor.this.desktop.getJDesktop().add(jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel.add(jPanel2);
                PoseEditor.this.randomLevel = new JSlider(){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(60, 10);
                    }
                };
                PoseEditor.this.randomLevel.setToolTipText(Messages.getString("random_level_tooltip"));
                PoseEditor.this.randomLevel.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JSlider jSlider = (JSlider)changeEvent.getSource();
                        jSlider.setToolTipText("" + jSlider.getValue());
                    }
                });
                PoseEditor.this.randomLevel.setMaximum(50);
                PoseEditor.this.randomLevel.setValue(25);
                jPanel2.add(PoseEditor.this.randomLevel);
                JButton jButton = new JButton(Messages.getString("rand"));
                jButton.setToolTipText(Messages.getString("rand_tooltip"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PoseEditor.this.randomAll();
                    }
                });
                jPanel2.add(jButton);
                JPanel jPanel3 = new JPanel();
                jPanel.add(jPanel3);
                jPanel3.setBorder(new TitledBorder(Messages.getString("show_windows")));
                JButton jButton2 = new JButton(Messages.getString("controler"));
                jButton2.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (((PoseEditor)PoseEditor.this).lastClicked.x != mouseEvent.getX() || ((PoseEditor)PoseEditor.this).lastClicked.y != mouseEvent.getY() || PoseEditor.this.boneControlerFrame == null) {
                            PoseEditor.this.showBoneControlerWindow();
                        }
                        PoseEditor.this.lastClicked = new Point(mouseEvent.getX(), mouseEvent.getY());
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
                jButton2.setToolTipText(Messages.getString("controler_tooltip"));
                jPanel3.add(jButton2);
                JButton jButton3 = new JButton(Messages.getString("load_model"));
                jButton3.setToolTipText(Messages.getString("load_model_tooltip"));
                jPanel.add(jButton3);
                jButton3.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (((PoseEditor)PoseEditor.this).lastClicked.x != mouseEvent.getX() || ((PoseEditor)PoseEditor.this).lastClicked.y != mouseEvent.getY() || PoseEditor.this.boneControlerFrame == null) {
                            PoseEditor.this.openModel();
                        }
                        PoseEditor.this.lastClicked = new Point(mouseEvent.getX(), mouseEvent.getY());
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
                jPanel3.setLayout(new FlowLayout());
                JButton jButton4 = new JButton(Messages.getString("settings"));
                jButton4.setToolTipText(Messages.getString("settings_tooltip"));
                jButton4.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (((PoseEditor)PoseEditor.this).lastClicked.x != mouseEvent.getX() || ((PoseEditor)PoseEditor.this).lastClicked.y != mouseEvent.getY() || PoseEditor.this.boneControlerFrame == null) {
                            PoseEditor.this.showSettingWindow();
                        }
                        PoseEditor.this.lastClicked = new Point(mouseEvent.getX(), mouseEvent.getY());
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
                jPanel3.add(jButton4);
                JButton jButton5 = new JButton(Messages.getString("poses"));
                jButton5.setToolTipText(Messages.getString("poses_tooltip"));
                jButton5.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (((PoseEditor)PoseEditor.this).lastClicked.x != mouseEvent.getX() || ((PoseEditor)PoseEditor.this).lastClicked.y != mouseEvent.getY() || PoseEditor.this.boneControlerFrame == null) {
                            PoseEditor.this.showPoseWindow();
                        }
                        PoseEditor.this.lastClicked = new Point(mouseEvent.getX(), mouseEvent.getY());
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
                jPanel3.add(jButton5);
                JPanel jPanel4 = new JPanel();
                jPanel.add(jPanel4);
                JButton jButton6 = new JButton(Messages.getString("last"));
                jButton6.setToolTipText(Messages.getString("last_tooltip"));
                jButton6.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PoseEditor.this.defaultAll();
                    }
                });
                jPanel4.add(jButton6);
                JButton jButton7 = new JButton(Messages.getString("zero"));
                jButton7.setToolTipText(Messages.getString("zero_tooltip"));
                jButton7.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PoseEditor.this.zeroAll();
                    }
                });
                jPanel4.add(jButton7);
                JPanel jPanel5 = new JPanel();
                jPanel5.setLayout(new GridLayout(0, 2));
                jPanel5.setBorder(new TitledBorder(Messages.getString("set_as")));
                jPanel.add(jPanel5);
                JButton jButton8 = new JButton(Messages.getString("as_random"));
                jButton8.setToolTipText(Messages.getString("as_random_tooltip"));
                jButton8.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PoseEditor.this.randomPoseDataHash = PoseEditor.this.toBoneInfoDataHash();
                    }
                });
                jPanel5.add(jButton8);
                JButton jButton9 = new JButton(Messages.getString("as_anime"));
                jButton9.setToolTipText(Messages.getString("as_anime_tooltip"));
                jButton9.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PoseEditor.this.animePoseDataHash = PoseEditor.this.toBoneInfoDataHash();
                        PoseEditor.this.poseStepsSlider.setValue(0);
                    }
                });
                jPanel5.add(jButton9);
                JButton jButton10 = new JButton(Messages.getString("as_current"));
                jButton10.setToolTipText(Messages.getString("as_current_tooltip"));
                jButton10.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String[] stringArray = PoseEditor.this.getBoneKeyNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            BonePoseInfo bonePoseInfo;
                            Vector3f vector3f = PoseEditor.this.getSteppedAngles(stringArray[i], PoseEditor.this.currentPoseSteps);
                            if (vector3f == null || (bonePoseInfo = PoseEditor.this.findBonePoseInfo(stringArray[i])) == null) continue;
                            bonePoseInfo.setAngleX(vector3f.x);
                            bonePoseInfo.setAngleY(vector3f.y);
                            bonePoseInfo.setAngleZ(vector3f.z);
                        }
                        PoseEditor.this.boneInfoPanel.update();
                        PoseEditor.this.boneInfoRootPanel.update();
                        PoseEditor.this.resetStepPoseSlider();
                    }
                });
                jPanel5.add(jButton10);
                JPanel jPanel6 = new JPanel();
                jPanel.add(jPanel6);
                PoseEditor.this.poseStepsSlider = new JSlider(){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(120, 10);
                    }
                };
                PoseEditor.this.poseStepsSlider.setToolTipText(Messages.getString("pose_step_tooltip"));
                PoseEditor.this.poseStepsSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JSlider jSlider = (JSlider)changeEvent.getSource();
                        jSlider.setToolTipText("" + jSlider.getValue());
                        PoseEditor.this.currentPoseSteps = jSlider.getValue();
                    }
                });
                PoseEditor.this.poseStepsSlider.setMaximum(100);
                PoseEditor.this.poseStepsSlider.setValue(0);
                jPanel6.add(PoseEditor.this.poseStepsSlider);
                JCheckBox jCheckBox = new JCheckBox(Messages.getString("anime"));
                jCheckBox.setToolTipText(Messages.getString("anime_tooltip"));
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PoseEditor.this.switchAnime(((JCheckBox)actionEvent.getSource()).isSelected());
                    }
                });
                jPanel6.add(jCheckBox);
                JPanel jPanel7 = new JPanel();
                jPanel.add(jPanel7);
                JButton jButton11 = new JButton(Messages.getString("image"));
                jButton11.setToolTipText(Messages.getString("image_tooltip"));
                jButton11.addActionListener(new ErrorCatchingGLActionListener(){

                    @Override
                    public void doGLAction(ActionEvent actionEvent) {
                        PoseEditor.this.screenShot();
                    }
                });
                jPanel7.add(jButton11);
                PoseEditor.this.createBoneContolerWindow();
                PoseEditor.this.createSettingWindow();
                PoseEditor.this.desktop.getJDesktop().updateUI();
                PoseEditor.this.finishCreateDesktop();
            }
        });
        this.guiNode.setCullMode(3);
        this.guiNode.setLightCombineMode(0);
        this.guiNode.updateRenderState();
        this.guiNode.updateGeometricState(0.0f, true);
        MouseInput.get().setCursorVisible(true);
    }

    private void resetStepPoseSlider() {
        this.poseStepsSlider.setValue(0);
    }

    private void unfocusButton() {
    }

    private void createBoneContolerWindow() {
        this.boneControlerFrame = new JFrame();
        this.boneControlerFrame.setLayout(null);
        this.boneControlerFrame.setLocation(16, 16);
        this.boneControlerFrame.setSize(460, 640);
        this.boneControlerFrame.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setSize(440, 50);
        jPanel.setLocation(0, 0);
        this.boneControlerFrame.add(jPanel);
        this.fileName = new JTextField();
        this.fileName.setText(Messages.getString("pose_data"));
        this.fileName.setColumns(12);
        jPanel.add(this.fileName);
        JButton jButton = new JButton(Messages.getString("save"));
        jButton.setToolTipText(Messages.getString("save_tooltip"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseEditor.this.save(PoseEditor.this.fileName.getText(), PoseEditor.this.overwrite.isSelected());
                PoseEditor.this.lastSavedLabel.setText(Messages.getString("last_saved") + ":" + PoseEditor.this.fileName.getText() + ".txt");
            }
        });
        this.overwrite = new JCheckBox(Messages.getString("ow"));
        this.overwrite.setToolTipText(Messages.getString("ow_tooltip"));
        jPanel.add(this.overwrite);
        JButton jButton2 = new JButton(Messages.getString("load"));
        jButton2.setToolTipText(Messages.getString("load_tooltip"));
        jPanel.add(jButton2);
        jButton2.addActionListener(new ErrorCatchingGLActionListener(){

            @Override
            public void doGLAction(ActionEvent actionEvent) {
                PoseEditor.this.openData();
                PoseEditor.this.unfocusButton();
                PoseEditor.this.lastSavedLabel.setText("");
            }
        });
        this.lastSavedLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(440, 16);
            }
        };
        jPanel.add(this.lastSavedLabel);
        this.boneInfoButtonList = new JPanel();
        this.boneInfoButtonList.setLayout(new GridLayout(0, 4));
        this.boneInfoButtonList.addMouseListener(new KeyInputControler());
        JScrollPane jScrollPane = new JScrollPane(this.boneInfoButtonList);
        jScrollPane.setLocation(0, 50);
        jScrollPane.setSize(440, 260);
        this.boneControlerFrame.add(jScrollPane);
        jScrollPane.setVisible(true);
        logger.info("desktop updated");
        logger.info("top-panel:" + this.boneControlerFrame.getSize());
        logger.info("desktop" + this.desktop.getJDesktop().getSize());
        this.infoCardLayoutPanel = new JPanel();
        this.infoCardLayoutPanel.setSize(440, 180);
        this.infoCardLayoutPanel.setLocation(0, 310);
        this.infoCardLayout = new CardLayout();
        this.infoCardLayoutPanel.setLayout(this.infoCardLayout);
        this.infoCardLayoutPanel.setVisible(true);
        this.boneInfoRootPanel = new BonePoseInfoPanel(true);
        this.infoCardLayoutPanel.add((Component)this.boneInfoRootPanel, "root");
        this.infoCardLayout.first(this.infoCardLayoutPanel);
        this.boneInfoPanel = new BonePoseInfoPanel(false);
        this.infoCardLayoutPanel.add((Component)this.boneInfoPanel, "children");
        this.boneControlerFrame.add(this.infoCardLayoutPanel);
    }

    private void showBoneControlerWindow() {
        if (this.boneControlerFrame != null) {
            this.boneControlerFrame.setVisible(true);
        } else {
            this.createBoneContolerWindow();
        }
    }

    public void loadSettings(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createSettingWindow() {
        this.settingFrame = new PoseEditorSettingSwingWindow();
        this.settingFrame.setBackgroundTarget((Spatial)this.backgroundGuad);
        this.settingFrame.setBloomRenderPass(this.bloomRenderPass);
        this.settingFrame.setPoseBoneInfoDataHashContainer(this);
    }

    private void showSettingWindow() {
        if (this.settingFrame != null) {
            this.settingFrame.setVisible(true);
        } else {
            this.createSettingWindow();
            this.settingFrame.setVisible(true);
        }
    }

    private void createPoseWindow() {
        this.poseSelectFrame = new PoseSelectSwingWindow(this);
        this.poseSelectFrame.setExportDir(this.settingFrame.getExportPath());
    }

    private void showPoseWindow() {
        if (this.poseSelectFrame != null) {
            this.poseSelectFrame.setVisible(true);
            if (!this.settingFrame.getExportPath().equals(this.poseSelectFrame.getExportDir())) {
                this.poseSelectFrame.setExportDir(this.settingFrame.getExportPath());
            }
        } else {
            this.createPoseWindow();
            this.poseSelectFrame.setVisible(true);
        }
    }

    private void finishCreateDesktop() {
        this.openModel(new File("datas/models/model001/model001.md5mesh"));
        this.loadPose(this.getClass().getResourceAsStream("/jp/sourceforge/akjrcp/motiontools/" + Messages.getString("default_pose_file")));
        this.modelLoaded = true;
    }

    public void openModel() {
        File file;
        int n;
        JFileChooser jFileChooser = new JFileChooser(".");
        if ((double)SystemUtils.JAVA_VERSION_FLOAT > 1.6) {
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Model Data(*.md5mesh)", "md5mesh");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        if ((n = jFileChooser.showOpenDialog(this.settingFrame)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.openModel(file);
        }
    }

    public void openData() {
        File file;
        int n;
        JFileChooser jFileChooser = new JFileChooser(this.settingFrame.getExportPath());
        if ((double)SystemUtils.JAVA_VERSION_FLOAT > 1.6) {
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Pose Data(*.txt)", "txt");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        if ((n = jFileChooser.showOpenDialog(this.settingFrame)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            try {
                this.loadPose(new FileInputStream(file));
                this.fileName.setText(FileNameUtils.getRemovedExtensionName((String)file.getName()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    private void switchAnime(boolean bl) {
        this.doAnimation = bl;
        if (this.doAnimation) {
            int n;
            SkeletalAnimation skeletalAnimation = new SkeletalAnimation();
            float f = 15.0f;
            int n2 = (int)(f * 3.0f);
            float f2 = 1.0f / f;
            skeletalAnimation.setBaseFrame((KeyFrame)this.cloneSkeletalKeyFrame(this.baseKeyFrame));
            String[] stringArray = this.skeltonModel.getSkeleton().getJointNames();
            logger.info("joint names=" + stringArray.length);
            skeletalAnimation.setSkeleton(this.skeltonModel.getSkeleton());
            for (n = 0; n < stringArray.length; ++n) {
                skeletalAnimation.getSuppliedPositions().set(n, true);
                skeletalAnimation.getSuppliedRotations().set(n, true);
            }
            if (!this.settingFrame.isStartAnimationFromAnimePose()) {
                Quaternion quaternion;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                BonePoseInfo bonePoseInfo;
                int n3;
                SkeletalKeyFrame skeletalKeyFrame;
                for (n = n2 - 1; n >= 0; --n) {
                    skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        bonePoseInfo = this.findBonePoseInfo(stringArray[n3]);
                        f8 = 0.0f;
                        f7 = 0.0f;
                        f6 = 0.0f;
                        if (this.animePoseDataHash != null) {
                            f8 = this.animePoseDataHash.getRotX(stringArray[n3], 0);
                            f7 = this.animePoseDataHash.getRotY(stringArray[n3], 0);
                            f6 = this.animePoseDataHash.getRotZ(stringArray[n3], 0);
                        }
                        f5 = bonePoseInfo.getAngleX() - f8;
                        f4 = bonePoseInfo.getAngleY() - f7;
                        f3 = bonePoseInfo.getAngleZ() - f6;
                        if (bonePoseInfo == null) continue;
                        quaternion = new Quaternion();
                        if (n != 0) {
                            quaternion.fromAngles(((float)n / (float)(n2 - 1) * f5 + f8) * ((float)Math.PI / 180), ((float)n / (float)(n2 - 1) * f4 + f7) * ((float)Math.PI / 180), ((float)n / (float)(n2 - 1) * f3 + f6) * ((float)Math.PI / 180));
                        } else {
                            quaternion.fromAngles(f8 * ((float)Math.PI / 180), f7 * ((float)Math.PI / 180), f6 * ((float)Math.PI / 180));
                        }
                        if (bonePoseInfo.isRoot()) {
                            quaternion.multLocal(this.cameraAngle);
                        }
                        skeletalKeyFrame.rotations[n3].set(quaternion.mult(this.baseKeyFrame.rotations[n3]));
                    }
                    skeletalKeyFrame.time = f2 * (float)(n2 - n);
                    skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                }
                if (this.settingFrame.isABAAnimation()) {
                    for (n = 0; n <= n2; ++n) {
                        skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            bonePoseInfo = this.findBonePoseInfo(stringArray[n3]);
                            f8 = 0.0f;
                            f7 = 0.0f;
                            f6 = 0.0f;
                            if (this.animePoseDataHash != null) {
                                f8 = this.animePoseDataHash.getRotX(stringArray[n3], 0);
                                f7 = this.animePoseDataHash.getRotY(stringArray[n3], 0);
                                f6 = this.animePoseDataHash.getRotZ(stringArray[n3], 0);
                            }
                            f5 = bonePoseInfo.getAngleX() - f8;
                            f4 = bonePoseInfo.getAngleY() - f7;
                            f3 = bonePoseInfo.getAngleZ() - f6;
                            if (bonePoseInfo == null) continue;
                            quaternion = new Quaternion();
                            if (n != 0) {
                                quaternion.fromAngles(((float)n / (float)n2 * f5 + f8) * ((float)Math.PI / 180), ((float)n / (float)n2 * f4 + f7) * ((float)Math.PI / 180), ((float)n / (float)n2 * f3 + f6) * ((float)Math.PI / 180));
                            } else {
                                quaternion.fromAngles(f8 * ((float)Math.PI / 180), f7 * ((float)Math.PI / 180), f6 * ((float)Math.PI / 180));
                            }
                            if (bonePoseInfo.isRoot()) {
                                quaternion.multLocal(this.cameraAngle);
                            }
                            skeletalKeyFrame.rotations[n3].set(quaternion.mult(this.baseKeyFrame.rotations[n3]));
                        }
                        skeletalKeyFrame.time = f2 * (float)n + f2 * (float)(n2 + 1);
                        skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                    }
                }
            } else {
                Quaternion quaternion;
                float f9;
                float f10;
                float f11;
                float f12;
                float f13;
                float f14;
                BonePoseInfo bonePoseInfo;
                int n4;
                SkeletalKeyFrame skeletalKeyFrame;
                for (n = 0; n <= n2; ++n) {
                    skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        bonePoseInfo = this.findBonePoseInfo(stringArray[n4]);
                        f14 = 0.0f;
                        f13 = 0.0f;
                        f12 = 0.0f;
                        if (this.animePoseDataHash != null) {
                            f14 = this.animePoseDataHash.getRotX(stringArray[n4], 0);
                            f13 = this.animePoseDataHash.getRotY(stringArray[n4], 0);
                            f12 = this.animePoseDataHash.getRotZ(stringArray[n4], 0);
                        }
                        f11 = bonePoseInfo.getAngleX() - f14;
                        f10 = bonePoseInfo.getAngleY() - f13;
                        f9 = bonePoseInfo.getAngleZ() - f12;
                        if (bonePoseInfo == null) continue;
                        quaternion = new Quaternion();
                        if (n != 0) {
                            quaternion.fromAngles(((float)n / (float)n2 * f11 + f14) * ((float)Math.PI / 180), ((float)n / (float)n2 * f10 + f13) * ((float)Math.PI / 180), ((float)n / (float)n2 * f9 + f12) * ((float)Math.PI / 180));
                        } else {
                            quaternion.fromAngles(f14 * ((float)Math.PI / 180), f13 * ((float)Math.PI / 180), f12 * ((float)Math.PI / 180));
                        }
                        if (bonePoseInfo.isRoot()) {
                            quaternion.multLocal(this.cameraAngle);
                        }
                        skeletalKeyFrame.rotations[n4].set(quaternion.mult(this.baseKeyFrame.rotations[n4]));
                    }
                    skeletalKeyFrame.time = f2 * (float)n;
                    skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                }
                if (this.settingFrame.isABAAnimation()) {
                    for (n = n2 - 1; n >= 0; --n) {
                        skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
                        for (n4 = 0; n4 < stringArray.length; ++n4) {
                            bonePoseInfo = this.findBonePoseInfo(stringArray[n4]);
                            f14 = 0.0f;
                            f13 = 0.0f;
                            f12 = 0.0f;
                            if (this.animePoseDataHash != null) {
                                f14 = this.animePoseDataHash.getRotX(stringArray[n4], 0);
                                f13 = this.animePoseDataHash.getRotY(stringArray[n4], 0);
                                f12 = this.animePoseDataHash.getRotZ(stringArray[n4], 0);
                            }
                            f11 = bonePoseInfo.getAngleX() - f14;
                            f10 = bonePoseInfo.getAngleY() - f13;
                            f9 = bonePoseInfo.getAngleZ() - f12;
                            if (bonePoseInfo == null) continue;
                            quaternion = new Quaternion();
                            if (n != 0) {
                                quaternion.fromAngles(((float)n / (float)n2 * f11 + f14) * ((float)Math.PI / 180), ((float)n / (float)n2 * f10 + f13) * ((float)Math.PI / 180), ((float)n / (float)n2 * f9 + f12) * ((float)Math.PI / 180));
                            } else {
                                quaternion.fromAngles(f14 * ((float)Math.PI / 180), f13 * ((float)Math.PI / 180), f12 * ((float)Math.PI / 180));
                            }
                            if (bonePoseInfo.isRoot()) {
                                quaternion.multLocal(this.cameraAngle);
                            }
                            skeletalKeyFrame.rotations[n4].set(quaternion.mult(this.baseKeyFrame.rotations[n4]));
                        }
                        skeletalKeyFrame.time = f2 * (float)(n2 - n) + f2 * (float)(n2 + 1);
                        skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
                    }
                }
            }
            this.bodyAnimator.removeAnimator(0);
            AnimationAnimator animationAnimator = this.bodyAnimator.addAnimation((Animation)skeletalAnimation);
            animationAnimator.fadeIn(0.01f);
            animationAnimator.setCycleType(1);
            this.animationAnimator = animationAnimator;
        }
    }

    private void defaultAll() {
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo != null) {
                bonePoseInfo.setAngleX(this.poseInfoDataHash.getRotX(stringArray[i], (int)bonePoseInfo.getAngleX()));
                bonePoseInfo.setAngleY(this.poseInfoDataHash.getRotY(stringArray[i], (int)bonePoseInfo.getAngleY()));
                bonePoseInfo.setAngleZ(this.poseInfoDataHash.getRotZ(stringArray[i], (int)bonePoseInfo.getAngleZ()));
                bonePoseInfo.setMinAngleX(this.poseInfoDataHash.getMinRotX(stringArray[i], (int)bonePoseInfo.getMinAngleX()));
                bonePoseInfo.setMinAngleY(this.poseInfoDataHash.getMinRotY(stringArray[i], (int)bonePoseInfo.getMinAngleY()));
                bonePoseInfo.setMinAngleZ(this.poseInfoDataHash.getMinRotZ(stringArray[i], (int)bonePoseInfo.getMinAngleZ()));
                bonePoseInfo.setMaxAngleX(this.poseInfoDataHash.getMaxRotX(stringArray[i], (int)bonePoseInfo.getMaxAngleX()));
                bonePoseInfo.setMaxAngleY(this.poseInfoDataHash.getMaxRotY(stringArray[i], (int)bonePoseInfo.getMaxAngleY()));
                bonePoseInfo.setMaxAngleZ(this.poseInfoDataHash.getMaxRotZ(stringArray[i], (int)bonePoseInfo.getMaxAngleZ()));
                continue;
            }
            logger.warning("no pose info:" + stringArray[i]);
        }
        this.resetStepPoseSlider();
        this.boneInfoPanel.update();
        this.boneInfoRootPanel.update();
    }

    private void zeroAll() {
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo != null) {
                bonePoseInfo.setAngleX(0.0f);
                bonePoseInfo.setAngleY(0.0f);
                bonePoseInfo.setAngleZ(0.0f);
                continue;
            }
            logger.warning("no pose info:" + stringArray[i]);
        }
        this.resetStepPoseSlider();
        this.boneInfoPanel.update();
        this.boneInfoRootPanel.update();
    }

    public void randomAll() {
        this.poseStepsSlider.setValue(0);
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            float f = 0.02f * (float)this.randomLevel.getValue();
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (this.randomPoseDataHash != null) {
                f2 = this.randomPoseDataHash.getRotX(stringArray[i], 0);
                f3 = this.randomPoseDataHash.getRotY(stringArray[i], 0);
                f4 = this.randomPoseDataHash.getRotZ(stringArray[i], 0);
            }
            if (bonePoseInfo.isLock()) continue;
            bonePoseInfo.random(f2, f3, f4, f);
        }
        this.boneInfoRootPanel.update();
        this.boneInfoPanel.update();
        if (this.doAnimation) {
            this.switchAnime(true);
        }
    }

    public void screenShot() {
        this.desktop.setCullMode(2);
        this.fpsNode.setCullMode(2);
        this.doShot = true;
    }

    public void save(String string, boolean bl) {
        String string2 = this.getExportData();
        File file = new File(this.settingFrame.getExportPath(), string + ".txt");
        if (!bl) {
            String string3 = FileNameUtils.getNotFoundFileName((File)file);
            logger.info("savedName:" + string3);
            file = new File(string3);
            this.fileName.setText(FileNameUtils.getRemovedExtensionName((String)file.getName()));
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void simpleInitGame() {
        Text text;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser = null;
        System.out.println(this.cam.getLeft() + "," + this.cam.getUp());
        KeyBindingManager.getKeyBindingManager().set("num1", 79);
        KeyBindingManager.getKeyBindingManager().set("num3", 81);
        KeyBindingManager.getKeyBindingManager().set("num7", 71);
        KeyBindingManager.getKeyBindingManager().set("num0", 82);
        KeyBindingManager.getKeyBindingManager().set("num8", 72);
        KeyBindingManager.getKeyBindingManager().set("num2", 80);
        KeyBindingManager.getKeyBindingManager().set("num4", 75);
        KeyBindingManager.getKeyBindingManager().set("num6", 77);
        KeyBindingManager.getKeyBindingManager().set("control_visible", 88);
        KeyBindingManager.getKeyBindingManager().set("screenshot", 210);
        KeyBindingManager.getKeyBindingManager().set("random", 19);
        KeyBindingManager.getKeyBindingManager().set("out", 17);
        KeyBindingManager.getKeyBindingManager().set("in", 31);
        KeyBindingManager.getKeyBindingManager().set("up", 200);
        KeyBindingManager.getKeyBindingManager().set("down", 208);
        KeyBindingManager.getKeyBindingManager().set("right", 205);
        KeyBindingManager.getKeyBindingManager().set("left", 203);
        ((FirstPersonHandler)this.input).getMouseLookHandler().setEnabled(false);
        this.sceneRootNode = new Node("sceneRootNode");
        this.rootNode.attachChild((Spatial)this.sceneRootNode);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.attach(MotionToolsUtils.createLight(new Vector3f(0.0f, 7.0f, -25.0f)));
        lightState.attach(MotionToolsUtils.createLight(new Vector3f(0.0f, 7.0f, 25.0f)));
        this.lightState.detachAll();
        this.rootNode.setRenderState((RenderState)lightState);
        logger.info("" + this.cam.getDirection());
        KeyBindingManager.getKeyBindingManager().remove("toggle_pause");
        KeyBindingManager.getKeyBindingManager().remove("step");
        KeyBindingManager.getKeyBindingManager().remove("toggle_wire");
        KeyBindingManager.getKeyBindingManager().remove("toggle_lights");
        KeyBindingManager.getKeyBindingManager().remove("toggle_bounds");
        KeyBindingManager.getKeyBindingManager().remove("toggle_depth");
        KeyBindingManager.getKeyBindingManager().remove("toggle_normals");
        KeyBindingManager.getKeyBindingManager().remove("camera_out");
        KeyBindingManager.getKeyBindingManager().remove("screen_shot");
        KeyBindingManager.getKeyBindingManager().remove("parallel_projection");
        KeyBindingManager.getKeyBindingManager().remove("screen_shot");
        KeyBindingManager.getKeyBindingManager().remove("mem_report");
        KeyBindingManager.getKeyBindingManager().remove("screen_shot");
        this.cameraNode = new CameraNode("cameraNode", this.cam);
        this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
        this.cameraNode.setLocalRotation(new Quaternion());
        this.cameraNodeAngleX = 0.0f;
        this.cameraNodeAngleY = 0.0f;
        this.cameraNodeAngleZ = 0.0f;
        this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
        this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
        this.rootNode.attachChild((Spatial)this.cameraNode);
        this.backgroundGuad = new Quad("bg", 4.0f, 3.0f);
        this.backgroundGuad.setLocalScale(134.0f);
        this.backgroundGuad.setLocalRotation(MotionToolsUtils.getRotateY(180.0f));
        this.backgroundGuad.setLocalTranslation(0.0f, 0.0f, 400.0f);
        this.backgroundGuad.setCullMode(2);
        this.backgroundGuad.setLightCombineMode(0);
        this.backgroundGuad.setModelBound((BoundingVolume)new BoundingBox());
        MotionToolsUtils.setDiffuseState((Spatial)this.backgroundGuad, 255, 255, 255);
        this.cameraNode.attachChild((Spatial)this.backgroundGuad);
        RenderPass renderPass = new RenderPass();
        renderPass.add((Spatial)this.rootNode);
        this.pManager.add((Pass)renderPass);
        this.bloomRenderPass = new BloomRenderPass(this.cam, 4);
        this.bloomRenderPass.setBlurSize(0.02f);
        this.bloomRenderPass.setExposurePow(10.0f);
        this.bloomRenderPass.setExposureCutoff(0.0f);
        this.bloomRenderPass.setBlurIntensityMultiplier(0.6f);
        this.bloomRenderPass.setThrottle(0.015f);
        if (!this.bloomRenderPass.isSupported()) {
            text = new Text("Text", "GLSL Not supported on this computer.");
            text.setRenderQueueMode(4);
            text.setLightCombineMode(0);
            text.setLocalTranslation(new Vector3f(0.0f, 20.0f, 0.0f));
            this.fpsNode.attachChild((Spatial)text);
        } else {
            this.bloomRenderPass.add((Spatial)this.rootNode);
            this.bloomRenderPass.setUseCurrentScene(true);
            this.pManager.add((Pass)this.bloomRenderPass);
        }
        text = new RenderPass();
        text.add((Spatial)this.fpsNode);
        text.add((Spatial)this.backgroundGuad);
        this.pManager.add((Pass)text);
        this.bloomRenderPass.setEnabled(false);
        ((FirstPersonHandler)this.input).getKeyboardLookHandler().setMoveSpeed(25.0f);
        this.createDesktop();
    }

    public String[] getBoneKeyNames() {
        return this.skeltonModel.getSkeleton().getJointNames();
    }

    public void printInfo(Spatial spatial) {
        block4: {
            block3: {
                if (!(spatial instanceof Node)) break block3;
                Node node = (Node)spatial;
                logger.info("node:" + node.getName());
                for (int i = 0; i < node.getQuantity(); ++i) {
                    this.printInfo(node.getChild(i));
                }
                break block4;
            }
            if (!(spatial instanceof TriMesh)) break block4;
            TriMesh triMesh = (TriMesh)spatial;
            int n = triMesh.getBatchCount();
            logger.info("triMesh:" + triMesh.getName());
            for (int i = 0; i < n; ++i) {
                System.out.println(triMesh.getVertexBuffer(i));
                if (triMesh.getVertexBuffer(i) != null) {
                    logger.info(i + "=" + triMesh.getVertexBuffer(i).capacity() / 3);
                    continue;
                }
                logger.warning("have empty batch make crash" + triMesh.getName());
            }
        }
    }

    public void printBone(Bone bone) {
        logger.info(bone.getName() + "," + bone.getLocalTranslation());
        for (int i = 0; i < bone.getQuantity(); ++i) {
            this.printBone((Bone)bone.getChild(i));
        }
    }

    protected void simpleUpdate() {
        if (this.enableShortcut) {
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("out", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, 0.0f, 1.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("in", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, 0.0f, -1.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("down", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, 1.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("up", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(0.0f, -1.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("right", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(-1.0f, 0.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("left", true)) {
                this.cameraNode.getLocalTranslation().addLocal(new Vector3f(1.0f, 0.0f, 0.0f));
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("bones", false)) {
                boolean bl = this.boneOn = !this.boneOn;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("num1_ctrl", false)) {
                System.out.println("num1_c");
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num0", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(5.0f, 0.0f, -19.0f));
                this.cameraNode.setLocalRotation(new Quaternion());
                this.cameraNodeAngleX = 0.0f;
                this.cameraNodeAngleY = 0.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num1", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
                this.cameraNodeAngleX = 0.0f;
                this.cameraNodeAngleY = 0.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num3", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
                this.cameraNode.setLocalRotation(new Quaternion());
                this.cameraNodeAngleX = 0.0f;
                this.cameraNodeAngleY = -90.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num7", false)) {
                this.cameraNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -19.0f));
                this.cameraNode.setLocalRotation(new Quaternion());
                this.cameraNodeAngleX = -90.0f;
                this.cameraNodeAngleY = 0.0f;
                this.cameraNodeAngleZ = 0.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
                Quaternion quaternion = new Quaternion();
                quaternion.fromAngles(this.cameraNodeAngleX * ((float)Math.PI / 180), 0.0f, 0.0f);
                quaternion.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num8", true)) {
                this.cameraNodeAngleX += this.cameraNodeAngleAdd;
                this.cameraNodeAngleX %= 360.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num2", true)) {
                this.cameraNodeAngleX -= this.cameraNodeAngleAdd;
                this.cameraNodeAngleX %= 360.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num4", true)) {
                this.cameraNodeAngleY -= this.cameraNodeAngleAdd;
                this.cameraNodeAngleY %= 360.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("num6", true)) {
                this.cameraNodeAngleY += this.cameraNodeAngleAdd;
                this.cameraNodeAngleY %= 360.0f;
                this.cameraAngle = MotionToolsUtils.getRotate(this.cameraNodeAngleX, this.cameraNodeAngleY, this.cameraNodeAngleZ);
                this.cameraAngle.multLocal(MotionToolsUtils.getRotateY(this.blenderTurn));
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("screenshot", false)) {
                this.screenShot();
            } else if (KeyBindingManager.getKeyBindingManager().isValidCommand("random", false)) {
                this.randomAll();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("1", false)) {
                this.bloomRenderPass.setEnabled(!this.bloomRenderPass.isEnabled());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("2", false)) {
                this.bloomRenderPass.setBlurSize(this.bloomRenderPass.getBlurSize() - 0.001f);
                System.out.println("blurSize:" + this.bloomRenderPass.getBlurSize());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("3", false)) {
                this.bloomRenderPass.setBlurSize(this.bloomRenderPass.getBlurSize() + 0.001f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("4", false)) {
                this.bloomRenderPass.setExposurePow(this.bloomRenderPass.getExposurePow() - 1.0f);
                System.out.println("ExposurePow:" + this.bloomRenderPass.getExposurePow());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("5", false)) {
                this.bloomRenderPass.setExposurePow(this.bloomRenderPass.getExposurePow() + 1.0f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("6", false)) {
                this.bloomRenderPass.setExposureCutoff(this.bloomRenderPass.getExposureCutoff() - 0.1f);
                System.out.println("ExposureCutoff:" + this.bloomRenderPass.getExposureCutoff());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("7", false)) {
                this.bloomRenderPass.setExposureCutoff(this.bloomRenderPass.getExposureCutoff() + 0.1f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("8", false)) {
                this.bloomRenderPass.setBlurIntensityMultiplier(this.bloomRenderPass.getBlurIntensityMultiplier() - 0.1f);
                System.out.println("BlurIntensityMultiplier:" + this.bloomRenderPass.getBlurIntensityMultiplier());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("9", false)) {
                this.bloomRenderPass.setBlurIntensityMultiplier(this.bloomRenderPass.getBlurIntensityMultiplier() + 0.1f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("0", false)) {
                this.bloomRenderPass.resetParameters();
                this.bloomRenderPass.setUseCurrentScene(true);
                this.bloomRenderPass.setThrottle(0.02f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("`", false)) {
                this.bloomRenderPass.setUseCurrentScene(!this.bloomRenderPass.useCurrentScene());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("-", false)) {
                float f = this.bloomRenderPass.getThrottle() - 0.005f;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                logger.info("throttle: " + f);
                this.bloomRenderPass.setThrottle(f);
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("+", false)) {
                float f = this.bloomRenderPass.getThrottle() + 0.005f;
                System.out.println("getThrottle:" + this.bloomRenderPass.getThrottle());
                this.bloomRenderPass.setThrottle(f);
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("control_visible", false)) {
            boolean bl = this.visibleControls = !this.visibleControls;
            if (this.visibleControls) {
                this.desktop.setCullMode(3);
                this.fpsNode.setCullMode(3);
            } else {
                this.enableKeyboardInput(true);
                this.desktop.setCullMode(2);
                this.fpsNode.setCullMode(2);
            }
        }
        if (!this.doAnimation) {
            this.updateStillAnimation();
        }
    }

    public SkeletalKeyFrame cloneSkeletalKeyFrame(SkeletalKeyFrame skeletalKeyFrame) {
        int n;
        SkeletalKeyFrame skeletalKeyFrame2 = new SkeletalKeyFrame();
        skeletalKeyFrame2.positions = new Vector3f[skeletalKeyFrame.positions.length];
        skeletalKeyFrame2.rotations = new Quaternion[skeletalKeyFrame.rotations.length];
        for (n = 0; n < skeletalKeyFrame2.positions.length; ++n) {
            skeletalKeyFrame2.positions[n] = skeletalKeyFrame.positions[n].clone();
        }
        for (n = 0; n < skeletalKeyFrame2.rotations.length; ++n) {
            skeletalKeyFrame2.rotations[n] = new Quaternion(skeletalKeyFrame.rotations[n]);
        }
        return skeletalKeyFrame2;
    }

    private Vector3f getSteppedAngles(String string, int n) {
        BonePoseInfo bonePoseInfo = this.findBonePoseInfo(string);
        if (bonePoseInfo == null) {
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (n == 0) {
            f = bonePoseInfo.getAngleX();
            f2 = bonePoseInfo.getAngleY();
            f3 = bonePoseInfo.getAngleZ();
        } else if (n == 100) {
            if (this.animePoseDataHash == null) {
                f = 0.0f;
                f2 = 0.0f;
                f3 = 0.0f;
            } else {
                f = this.animePoseDataHash.getRotX(string, 0);
                f2 = this.animePoseDataHash.getRotY(string, 0);
                f3 = this.animePoseDataHash.getRotZ(string, 0);
            }
        } else {
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (this.animePoseDataHash != null) {
                f4 = this.animePoseDataHash.getRotX(string, 0);
                f5 = this.animePoseDataHash.getRotY(string, 0);
                f6 = this.animePoseDataHash.getRotZ(string, 0);
            }
            float f7 = bonePoseInfo.getAngleX() - f4;
            float f8 = bonePoseInfo.getAngleY() - f5;
            float f9 = bonePoseInfo.getAngleZ() - f6;
            f = (float)(100 - n) / 100.0f * f7 + f4;
            f2 = (float)(100 - n) / 100.0f * f8 + f5;
            f3 = (float)(100 - n) / 100.0f * f9 + f6;
        }
        return new Vector3f(f, f2, f3);
    }

    private SkeletalKeyFrame syncBoneAngles() {
        SkeletalKeyFrame skeletalKeyFrame = this.cloneSkeletalKeyFrame(this.baseKeyFrame);
        String[] stringArray = this.skeltonModel.getSkeleton().getJointNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo == null) continue;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (this.currentPoseSteps == 0) {
                f = bonePoseInfo.getAngleX();
                f2 = bonePoseInfo.getAngleY();
                f3 = bonePoseInfo.getAngleZ();
            } else if (this.currentPoseSteps == 100) {
                if (this.animePoseDataHash == null) {
                    f = 0.0f;
                    f2 = 0.0f;
                    f3 = 0.0f;
                } else {
                    f = this.animePoseDataHash.getRotX(stringArray[i], 0);
                    f2 = this.animePoseDataHash.getRotY(stringArray[i], 0);
                    f3 = this.animePoseDataHash.getRotZ(stringArray[i], 0);
                }
            } else {
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = 0.0f;
                if (this.animePoseDataHash != null) {
                    f4 = this.animePoseDataHash.getRotX(stringArray[i], 0);
                    f5 = this.animePoseDataHash.getRotY(stringArray[i], 0);
                    f6 = this.animePoseDataHash.getRotZ(stringArray[i], 0);
                }
                float f7 = bonePoseInfo.getAngleX() - f4;
                float f8 = bonePoseInfo.getAngleY() - f5;
                float f9 = bonePoseInfo.getAngleZ() - f6;
                f = (float)(100 - this.currentPoseSteps) / 100.0f * f7 + f4;
                f2 = (float)(100 - this.currentPoseSteps) / 100.0f * f8 + f5;
                f3 = (float)(100 - this.currentPoseSteps) / 100.0f * f9 + f6;
            }
            Quaternion quaternion = new Quaternion();
            quaternion.fromAngles(f * ((float)Math.PI / 180), f2 * ((float)Math.PI / 180), f3 * ((float)Math.PI / 180));
            if (!bonePoseInfo.isRoot()) {
                skeletalKeyFrame.rotations[i].set(quaternion.mult(this.baseKeyFrame.rotations[i]));
                continue;
            }
            quaternion.multLocal(this.cameraAngle);
            skeletalKeyFrame.rotations[i].set(quaternion.mult(this.baseKeyFrame.rotations[i]));
        }
        return skeletalKeyFrame;
    }

    private BonePoseInfo findBonePoseInfo(String string) {
        if (string == null) {
            return null;
        }
        return this.boneInfoMap.get(string);
    }

    public void updateStillAnimation() {
        if (!this.modelLoaded) {
            return;
        }
        SkeletalKeyFrame skeletalKeyFrame = this.syncBoneAngles();
        SkeletalAnimation skeletalAnimation = new SkeletalAnimation();
        skeletalAnimation.setBaseFrame((KeyFrame)skeletalKeyFrame);
        skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame);
        skeletalAnimation.setSkeleton(this.skeltonModel.getSkeleton());
        skeletalAnimation.getSuppliedPositions().set(0, true);
        skeletalAnimation.getSuppliedRotations().set(0, true);
        this.bodyAnimator.removeAnimator(0);
        AnimationAnimator animationAnimator = this.bodyAnimator.addAnimation((Animation)skeletalAnimation);
        animationAnimator.fadeIn(0.01f);
        animationAnimator.setCycleType(0);
        this.animationAnimator = animationAnimator;
    }

    public Bone findBone(String string) {
        return null;
    }

    protected void simpleRender() {
        this.display.getRenderer().draw((Spatial)this.guiNode);
        if (this.boneOn) {
            this.bodyInstance.setSkeletonMode(1);
        }
        if (this.doShot) {
            this.display.getRenderer().takeScreenShot(FileNameUtils.getRemovedExtensionName((String)FileNameUtils.getNotFoundFileName((File)new File(this.settingFrame.getExportImagePath(), "pose.png"))));
            this.doShot = false;
            if (this.visibleControls) {
                this.desktop.setCullMode(3);
            }
            this.fpsNode.setCullMode(3);
        }
    }

    public BoneInfoDataHash toBoneInfoDataHash() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.getBoneKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
            if (bonePoseInfo != null && bonePoseInfo.isEnabled()) {
                Vector3f vector3f = this.getSteppedAngles(stringArray[i], this.currentPoseSteps);
                hashMap.put(BoneInfoDataHash.getRotKey(stringArray[i], "X"), "" + vector3f.x);
                hashMap.put(BoneInfoDataHash.getMinRotKey(stringArray[i], "X"), "" + bonePoseInfo.getMinAngleX());
                hashMap.put(BoneInfoDataHash.getMaxRotKey(stringArray[i], "X"), "" + bonePoseInfo.getMaxAngleX());
                hashMap.put(BoneInfoDataHash.getRotKey(stringArray[i], "Y"), "" + vector3f.y);
                hashMap.put(BoneInfoDataHash.getMinRotKey(stringArray[i], "Y"), "" + bonePoseInfo.getMinAngleY());
                hashMap.put(BoneInfoDataHash.getMaxRotKey(stringArray[i], "Y"), "" + bonePoseInfo.getMaxAngleY());
                hashMap.put(BoneInfoDataHash.getRotKey(stringArray[i], "Z"), "" + vector3f.z);
                hashMap.put(BoneInfoDataHash.getMinRotKey(stringArray[i], "Z"), "" + bonePoseInfo.getMinAngleZ());
                hashMap.put(BoneInfoDataHash.getMaxRotKey(stringArray[i], "Z"), "" + bonePoseInfo.getMaxAngleZ());
                String string = bonePoseInfo.getLabelName();
                if (string == null) {
                    string = bonePoseInfo.getKeyName();
                }
                hashMap.put(BoneInfoDataHash.getLabelKey(stringArray[i]), string);
                if (!bonePoseInfo.isLock()) continue;
                hashMap.put(BoneInfoDataHash.getLockKey(stringArray[i]), "1");
                continue;
            }
            hashMap.put(BoneInfoDataHash.getDisableKey(stringArray[i]), "1");
        }
        return new BoneInfoDataHash(hashMap);
    }

    public String getExportData() {
        System.out.println("exportdata");
        String string = "";
        try {
            String string2 = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/jp/sourceforge/akjrcp/motiontools/blender_export.txt"));
            String string3 = "#version=0.1\r\n#akJ motion tools - RandomPoseEditor\r\n";
            String string4 = "";
            String[] stringArray = this.getBoneKeyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                BonePoseInfo bonePoseInfo = this.findBonePoseInfo(stringArray[i]);
                if (bonePoseInfo.isEnabled()) {
                    String string5;
                    string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getAngleX() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getMinAngleX() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "X") + "=" + bonePoseInfo.getMaxAngleX() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getAngleY() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getMinAngleY() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "Y") + "=" + bonePoseInfo.getMaxAngleY() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getAngleZ() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMinRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getMinAngleZ() + "\r\n";
                    string3 = string3 + "#" + BoneInfoDataHash.getMaxRotKey(stringArray[i], "Z") + "=" + bonePoseInfo.getMaxAngleZ() + "\r\n";
                    if (bonePoseInfo.getSyncTarget() != null) {
                        string3 = string3 + "#" + BoneInfoDataHash.getSyncTargetKey(stringArray[i]) + "=" + bonePoseInfo.getSyncTarget().getKeyName() + "\r\n";
                        if (bonePoseInfo.getSyncMirrorX() != 1) {
                            string3 = string3 + "#" + BoneInfoDataHash.getSyncMirrorKey(stringArray[i], "X") + "=" + bonePoseInfo.getSyncMirrorX() + "\r\n";
                        }
                        if (bonePoseInfo.getSyncMirrorY() != 1) {
                            string3 = string3 + "#" + BoneInfoDataHash.getSyncMirrorKey(stringArray[i], "Y") + "=" + bonePoseInfo.getSyncMirrorY() + "\r\n";
                        }
                        if (bonePoseInfo.getSyncMirrorZ() != 1) {
                            string3 = string3 + "#" + BoneInfoDataHash.getSyncMirrorKey(stringArray[i], "Z") + "=" + bonePoseInfo.getSyncMirrorZ() + "\r\n";
                        }
                    }
                    if ((string5 = bonePoseInfo.getLabelName()) == null) {
                        string5 = bonePoseInfo.getKeyName();
                    }
                    string3 = string3 + "#" + BoneInfoDataHash.getLabelKey(stringArray[i]) + "=" + string5 + "\r\n";
                    if (bonePoseInfo.isLock()) {
                        string3 = string3 + "#" + BoneInfoDataHash.getLockKey(stringArray[i]) + "=" + "1" + "\r\n";
                    }
                    string4 = string4 + "bone=pose.bones['" + stringArray[i] + "']" + "\r\n";
                    Quaternion quaternion = bonePoseInfo.getRotation();
                    string4 = string4 + "bone.quat=Quaternion(" + quaternion.w + "," + quaternion.x + "," + quaternion.y + "," + quaternion.z + ")" + "\r\n";
                    string4 = string4 + "bone.insertKey(obj,newFrame,Pose.ROT)\r\n";
                    continue;
                }
                string3 = string3 + "#" + BoneInfoDataHash.getDisableKey(stringArray[i]) + "=1" + "\r\n";
            }
            string3 = string3 + "#end_data\r\n";
            string = string + string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private Model loadModel(File file) throws IOException {
        CustomMD5Reader customMD5Reader = new CustomMD5Reader();
        customMD5Reader.setProperty("skin.classloader", new CustomLoader(file));
        return customMD5Reader.readModel(new FileInputStream(file));
    }

    private Model loadModel(URL uRL) throws IOException {
        CustomMD5Reader customMD5Reader = new CustomMD5Reader();
        customMD5Reader.setProperty("skin.classloader", new CustomLoader(null));
        if (uRL == null) {
            logger.warning("url is null.check resouces");
        }
        return customMD5Reader.readModel(uRL.openStream());
    }

    private Animation createStillAnimation(Skeleton skeleton) {
        SkeletalAnimation skeletalAnimation = new SkeletalAnimation();
        SkeletalKeyFrame skeletalKeyFrame = skeleton.getBindFrame();
        SkeletalKeyFrame skeletalKeyFrame2 = new SkeletalKeyFrame();
        skeletalKeyFrame2.positions = (Vector3f[])skeletalKeyFrame.positions.clone();
        skeletalKeyFrame2.rotations = (Quaternion[])skeletalKeyFrame.rotations.clone();
        skeletalAnimation.setBaseFrame((KeyFrame)skeletalKeyFrame2);
        SkeletalKeyFrame skeletalKeyFrame3 = new SkeletalKeyFrame();
        skeletalKeyFrame3.positions = (Vector3f[])skeletalKeyFrame.positions.clone();
        skeletalKeyFrame3.rotations = (Quaternion[])skeletalKeyFrame.rotations.clone();
        skeletalAnimation.addKeyFrame((KeyFrame)skeletalKeyFrame3);
        skeletalAnimation.setSkeleton(skeleton);
        skeletalAnimation.getSuppliedPositions().set(0, true);
        skeletalAnimation.getSuppliedRotations().set(0, true);
        return skeletalAnimation;
    }

    @Override
    public void setAnimePose(BoneInfoDataHash boneInfoDataHash) {
        this.animePoseDataHash = boneInfoDataHash;
    }

    @Override
    public void setRandomPose(BoneInfoDataHash boneInfoDataHash) {
        this.randomPoseDataHash = boneInfoDataHash;
    }

    public class CustomLoader
    extends ClassLoader {
        private String defaultResouce = "/textures/white.tga";
        private File md5file;

        public CustomLoader(File file) {
            this.md5file = file;
        }

        @Override
        public URL getResource(String string) {
            Serializable serializable;
            File file;
            long l = System.currentTimeMillis();
            logger.info("resource:" + string);
            if (string.equals(".tga")) {
                logger.info("load default texture:" + this.defaultResouce);
                return this.getClass().getResource(this.defaultResouce);
            }
            if (string.endsWith(".tga.tga")) {
                string = string.substring(0, string.length() - 4);
            }
            if (string.endsWith(".png.png")) {
                string = string.substring(0, string.length() - 4);
            }
            if ((file = new File(string)).exists() && file.isFile()) {
                try {
                    logger.info("file:" + (System.currentTimeMillis() - l) / 1000L + " sec");
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            if (string.startsWith("//") && this.md5file != null) {
                serializable = new File(this.md5file.getParent(), string.substring(2));
                logger.info("try blender same directory:" + ((File)serializable).getAbsolutePath());
                if (((File)serializable).exists() && ((File)serializable).isFile()) {
                    try {
                        logger.info("file2:" + (System.currentTimeMillis() - l) / 1000L + " sec");
                        return ((File)serializable).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            }
            if ((serializable = this.getClass().getResource("/" + string)) != null) {
                logger.info("null:" + (System.currentTimeMillis() - l) / 1000L + " sec");
                return serializable;
            }
            if (string.endsWith(".png") && !string.endsWith("_d.tga")) {
                logger.info("load default texture:" + this.defaultResouce);
                logger.info("default:" + (System.currentTimeMillis() - l) / 1000L + " sec");
                return this.getClass().getResource(this.defaultResouce);
            }
            return null;
        }
    }

    public static abstract class ErrorCatchingGLActionListener
    implements ActionListener {
        @Override
        public final void actionPerformed(final ActionEvent actionEvent) {
            Callable callable = new Callable(){

                public Object call() {
                    try {
                        ErrorCatchingGLActionListener.this.doGLAction(actionEvent);
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Swing Action Error Caught!", exception);
                    }
                    return null;
                }
            };
            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
        }

        public abstract void doGLAction(ActionEvent var1);
    }

    public class KeyInputControler
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            PoseEditor.this.enableKeyboardInput(false);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            PoseEditor.this.enableKeyboardInput(true);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

