/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt;

import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.Timer;
import com.jmex.awt.JMECanvasImplementor;

public class SimpleCanvasImpl
extends JMECanvasImplementor {
    protected Node rootNode;
    protected Timer timer;
    protected float tpf;
    protected Camera cam;
    protected int width;
    protected int height;

    protected SimpleCanvasImpl(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void doSetup() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        displaySystem.initForCanvas(this.width, this.height);
        this.renderer = displaySystem.getRenderer();
        this.cam = this.renderer.createCamera(this.width, this.height);
        this.cam.setFrustumPerspective(45.0f, (float)this.width / (float)this.height, 1.0f, 1000.0f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.cam.update();
        this.renderer.setCamera(this.cam);
        this.renderer.setBackgroundColor(ColorRGBA.black.clone());
        this.timer = Timer.getTimer();
        this.rootNode = new Node("rootNode");
        ZBufferState zBufferState = this.renderer.createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.rootNode.setRenderState((RenderState)zBufferState);
        this.simpleSetup();
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
        this.setup = true;
    }

    public void doUpdate() {
        this.timer.update();
        this.tpf = this.timer.getTimePerFrame();
        this.simpleUpdate();
        this.rootNode.updateGeometricState(this.tpf, true);
    }

    public void doRender() {
        this.renderer.clearBuffers();
        this.renderer.draw((Spatial)this.rootNode);
        this.simpleRender();
        this.renderer.displayBackBuffer();
    }

    public void simpleSetup() {
    }

    public void simpleUpdate() {
    }

    public void simpleRender() {
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public float getTimePerFrame() {
        return this.tpf;
    }
}

