/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.game;

import com.jme.app.AbstractGame;
import com.jme.image.Image;
import com.jme.input.InputSystem;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.system.PreferencesGameSettings;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.NanoTimer;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jmex.audio.AudioSystem;
import com.jmex.game.DefaultUncaughtExceptionHandler;
import com.jmex.game.state.GameStateManager;
import java.awt.Canvas;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardGame
extends AbstractGame
implements Runnable {
    private static final Logger logger = Logger.getLogger(StandardGame.class.getName());
    public static final int DISPLAY_WINDOW = 1;
    public static final int DISPLAY_CANVAS = 2;
    public static boolean THREAD_FRIENDLY = true;
    public static int DISPLAY_MODE = 1;
    private Thread gameThread;
    private String gameName;
    private GameType type;
    private GameSettings settings;
    private boolean started;
    private Image[] icons;
    private Timer timer;
    private Camera camera;
    private ColorRGBA backgroundColor;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private Canvas canvas;
    private Lock updateLock;

    public StandardGame(String string) {
        this(string, GameType.GRAPHICAL, null);
    }

    public StandardGame(String string, GameType gameType) {
        this(string, gameType, null);
    }

    public StandardGame(String string, GameType gameType, GameSettings gameSettings) {
        this(string, gameType, gameSettings, null);
    }

    public StandardGame(String string, GameType gameType, GameSettings gameSettings, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.gameName = string;
        this.type = gameType;
        this.settings = gameSettings;
        this.exceptionHandler = uncaughtExceptionHandler;
        this.backgroundColor = ColorRGBA.black.clone();
        if (this.settings == null) {
            this.settings = new PreferencesGameSettings(Preferences.userRoot().node(string));
        }
        this.updateLock = new ReentrantLock(true);
    }

    public GameType getGameType() {
        return this.type;
    }

    public void start() {
        this.gameThread = new Thread(this);
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new DefaultUncaughtExceptionHandler(this);
        }
        this.gameThread.setUncaughtExceptionHandler(this.exceptionHandler);
        this.gameThread.setName("OpenGL");
        this.gameThread.start();
        try {
            while (!this.isStarted()) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "start()", "Exception", interruptedException);
        }
    }

    @Override
    public void run() {
        this.lock();
        this.initSystem();
        if (this.type != GameType.HEADLESS) {
            this.assertDisplayCreated();
            MouseInput.get().setCursorVisible(false);
        }
        this.initGame();
        if (this.type == GameType.GRAPHICAL) {
            this.timer = Timer.getTimer();
        } else if (this.type == GameType.HEADLESS) {
            this.timer = new NanoTimer();
        }
        int n = this.settings.getFramerate();
        long l = -1L;
        long l2 = -1L;
        long l3 = 0L;
        long l4 = -1L;
        if (n >= 0) {
            l = Math.round((float)this.timer.getResolution() / (float)n);
        }
        this.started = true;
        while (!this.finished && !this.display.isClosing()) {
            if (l >= 0L) {
                l2 = this.timer.getTime();
            }
            this.timer.update();
            float f = this.timer.getTimePerFrame();
            if (this.type == GameType.GRAPHICAL) {
                InputSystem.update();
            }
            this.update(f);
            this.render(f);
            this.display.getRenderer().displayBackBuffer();
            if (l >= 0L) {
                ++l3;
                l4 = this.timer.getTime() - l2;
                while (l4 < l) {
                    long l5 = (l - l4) * 1000L / this.timer.getResolution();
                    try {
                        Thread.sleep(l5);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.log(Level.SEVERE, "Interrupted while sleeping in fixed-framerate", interruptedException);
                    }
                    l4 = this.timer.getTime() - l2;
                }
                if (l3 == Long.MAX_VALUE) {
                    l3 = 0L;
                }
            }
            if (!THREAD_FRIENDLY) continue;
            Thread.yield();
        }
        this.started = false;
        this.cleanup();
        this.quit();
    }

    protected void initSystem() {
        if (this.type == GameType.GRAPHICAL) {
            if (JoystickInput.getProvider() == null) {
                JoystickInput.setProvider((String)"LWJGL");
            }
            this.display = DisplaySystem.getDisplaySystem((String)this.settings.getRenderer());
            this.displayMins();
            this.display.setTitle(this.gameName);
            if (this.icons != null) {
                this.display.setIcon(this.icons);
            }
            if (DISPLAY_MODE == 1) {
                this.display.createWindow(this.settings.getWidth(), this.settings.getHeight(), this.settings.getDepth(), this.settings.getFrequency(), this.settings.isFullscreen());
            } else if (DISPLAY_MODE == 2) {
                this.canvas = this.display.createCanvas(this.settings.getWidth(), this.settings.getHeight());
            }
            this.camera = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
            this.display.getRenderer().setBackgroundColor(this.backgroundColor);
            this.display.setVSyncEnabled(this.settings.isVerticalSync());
            this.cameraPerspective();
            this.cameraFrame();
            this.camera.update();
            this.display.getRenderer().setCamera(this.camera);
            if (this.settings.isMusic() || this.settings.isSFX()) {
                this.initSound();
            }
        } else {
            this.display = new DummyDisplaySystem();
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    protected void initSound() {
        AudioSystem.getSystem().getEar().trackOrientation(this.camera);
        AudioSystem.getSystem().getEar().trackPosition(this.camera);
    }

    private void displayMins() {
        this.display.setMinDepthBits(this.settings.getDepthBits());
        this.display.setMinStencilBits(this.settings.getStencilBits());
        this.display.setMinAlphaBits(this.settings.getAlphaBits());
        this.display.setMinSamples(this.settings.getSamples());
    }

    private void cameraPerspective() {
        this.camera.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
        this.camera.setParallelProjection(false);
        this.camera.update();
    }

    private void cameraFrame() {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.camera.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
    }

    public void resetCamera() {
        this.cameraFrame();
    }

    protected void initGame() {
        GameStateManager.create();
    }

    protected void update(float f) {
        this.unlock();
        this.lock();
        GameTaskQueueManager.getManager().getQueue("update").execute();
        GameStateManager.getInstance().update(f);
        if (this.type == GameType.GRAPHICAL && (this.settings.isMusic() || this.settings.isSFX())) {
            AudioSystem.getSystem().update();
        }
    }

    protected void render(float f) {
        this.display.getRenderer().clearStatistics();
        this.display.getRenderer().clearBuffers();
        GameTaskQueueManager.getManager().getQueue("render").execute();
        GameStateManager.getInstance().render(f);
    }

    public void reinit() {
        this.reinitAudio();
        this.reinitVideo();
    }

    public void reinitAudio() {
        if (AudioSystem.isCreated()) {
            AudioSystem.getSystem().cleanup();
        }
    }

    public void reinitVideo() {
        this.displayMins();
        this.display.recreateWindow(this.settings.getWidth(), this.settings.getHeight(), this.settings.getDepth(), this.settings.getFrequency(), this.settings.isFullscreen());
        this.camera = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
        this.display.getRenderer().setBackgroundColor(this.backgroundColor);
        if (this.settings.isMusic() || this.settings.isSFX()) {
            this.initSound();
        }
    }

    public void recreateGraphicalContext() {
        GameTaskQueueManager.getManager().update((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                StandardGame.this.reinit();
                return null;
            }
        });
    }

    protected void cleanup() {
        GameStateManager.getInstance().cleanup();
        DisplaySystem.getDisplaySystem().getRenderer().cleanup();
        TextureManager.doTextureCleanup();
        TextureManager.clearCache();
        JoystickInput.destroyIfInitalized();
        if (AudioSystem.isCreated()) {
            AudioSystem.getSystem().cleanup();
        }
    }

    protected void quit() {
        if (this.display != null) {
            this.display.reset();
            this.display.close();
        }
    }

    public DisplaySystem getDisplay() {
        return this.display;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public GameSettings getSettings() {
        return this.settings;
    }

    public void setBackgroundColor(ColorRGBA colorRGBA) {
        this.backgroundColor = colorRGBA;
    }

    public void shutdown() {
        this.finish();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.exceptionHandler = uncaughtExceptionHandler;
        this.gameThread.setUncaughtExceptionHandler(this.exceptionHandler);
    }

    public void delayForUpdate() throws InterruptedException, ExecutionException {
        Future future = GameTaskQueueManager.getManager().update((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        });
        future.get();
    }

    public boolean inGLThread() {
        return Thread.currentThread() == this.gameThread;
    }

    public <T> T executeInGL(Callable<T> callable) throws Exception {
        if (this.inGLThread()) {
            return callable.call();
        }
        Future future = GameTaskQueueManager.getManager().update(callable);
        return (T)future.get();
    }

    public void lock() {
        this.updateLock.lock();
    }

    public void unlock() {
        this.updateLock.unlock();
    }

    public void setIcons(Image[] imageArray) {
        this.icons = imageArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameType {
        GRAPHICAL,
        HEADLESS;

    }
}

