/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.controls;

import com.jme.input.KeyInput;
import com.jme.input.KeyInputListener;
import com.jme.input.MouseInput;
import com.jme.input.MouseInputListener;
import com.jme.input.controls.Binding;
import com.jme.input.controls.binding.JoystickAxisBinding;
import com.jme.input.controls.binding.JoystickButtonBinding;
import com.jme.input.controls.binding.KeyboardBinding;
import com.jme.input.controls.binding.MouseAxisBinding;
import com.jme.input.controls.binding.MouseButtonBinding;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.input.joystick.JoystickInputListener;
import com.jmex.editors.swing.controls.ControlField;
import com.jmex.editors.swing.controls.GameControlEditor;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ControlFieldListener
implements JoystickInputListener,
MouseInputListener,
KeyInputListener {
    private static final long DELAY = 500L;
    private GameControlEditor editor;
    private long lastHit = 0L;
    private ControlField field;
    private boolean hasBeenSet;
    private boolean disabled;

    public ControlFieldListener(GameControlEditor gameControlEditor) {
        this.editor = gameControlEditor;
    }

    public void prompt(ControlField controlField) {
        if (!this.disabled && System.currentTimeMillis() > this.lastHit + 500L) {
            this.field = controlField;
            controlField.setText("Press a key");
            MouseInput.get().setCursorVisible(false);
            KeyInput.get().addListener((KeyInputListener)this);
            MouseInput.get().addListener((MouseInputListener)this);
            JoystickInput.get().addListener((JoystickInputListener)this);
            this.hasBeenSet = false;
        }
    }

    public void onKey(char c, int n, boolean bl) {
        if (bl) {
            if (n == 1) {
                this.setBinding(null, false);
            } else if (n == 211) {
                this.setBinding(null, true);
            } else {
                this.setBinding((Binding)new KeyboardBinding(n), true);
            }
        }
    }

    public void onButton(int n, boolean bl, int n2, int n3) {
        if (bl) {
            this.setBinding((Binding)new MouseButtonBinding(n), true);
        }
    }

    public void onMove(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0) {
            return;
        }
        if (Math.abs(n) < GameControlEditor.MOUSE_THRESHOLD && Math.abs(n2) < GameControlEditor.MOUSE_THRESHOLD) {
            return;
        }
        if (Math.abs(n) > Math.abs(n2)) {
            if (n > 0) {
                this.setBinding((Binding)new MouseAxisBinding(1, false), true);
            } else {
                this.setBinding((Binding)new MouseAxisBinding(1, true), true);
            }
        } else if (n2 > 0) {
            this.setBinding((Binding)new MouseAxisBinding(2, false), true);
        } else {
            this.setBinding((Binding)new MouseAxisBinding(2, true), true);
        }
    }

    public void onWheel(int n, int n2, int n3) {
        if (n > 0) {
            this.setBinding((Binding)new MouseAxisBinding(3, false), true);
        } else if (n < 0) {
            this.setBinding((Binding)new MouseAxisBinding(3, true), true);
        }
    }

    public void onAxis(Joystick joystick, int n, float f) {
        if (f != 0.0f) {
            if (Math.abs(f) < GameControlEditor.JOYSTICK_THRESHOLD) {
                return;
            }
            boolean bl = f < 0.0f;
            this.setBinding((Binding)new JoystickAxisBinding(joystick, n, bl), true);
        }
    }

    public void onButton(Joystick joystick, int n, boolean bl) {
        if (bl) {
            this.setBinding((Binding)new JoystickButtonBinding(joystick, n), true);
        }
    }

    private synchronized void setBinding(final Binding binding, final boolean bl) {
        if (this.hasBeenSet) {
            return;
        }
        this.hasBeenSet = true;
        this.disabled = true;
        KeyInput.get().removeListener((KeyInputListener)this);
        MouseInput.get().removeListener((MouseInputListener)this);
        JoystickInput.get().removeListener((JoystickInputListener)this);
        MouseInput.get().setCursorVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl) {
                    ControlField controlField = null;
                    for (ControlField[] controlFieldArray : ((ControlFieldListener)ControlFieldListener.this).editor.controls.values()) {
                        for (ControlField controlField2 : controlFieldArray) {
                            if (controlField2.getBinding() == null || !controlField2.getBinding().toString().equals(binding.toString())) continue;
                            controlField = controlField2;
                        }
                    }
                    boolean bl2 = true;
                    if (controlField != null && controlField.getControl() != ControlFieldListener.this.field.getControl() && JOptionPane.showInternalConfirmDialog(ControlFieldListener.this.field, binding.toString() + " is already bound to " + controlField.getControl().getName() + ".\n\nDo you wish to replace it?", "Binding Already Exists", 0) != 0) {
                        bl2 = false;
                    }
                    if (bl2) {
                        if (controlField != null) {
                            controlField.setBinding(null);
                        }
                        ControlFieldListener.this.field.setBinding(binding);
                    } else {
                        ControlFieldListener.this.field.updateText();
                    }
                }
                ControlFieldListener.this.lastHit = System.currentTimeMillis();
                ControlFieldListener.this.disabled = false;
            }
        });
    }
}

