/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.NondirectBufferWrapper;
import org.lwjgl.openal.Util;

public final class AL10 {
    public static final int AL_INVALID = -1;
    public static final int AL_NONE = 0;
    public static final int AL_FALSE = 0;
    public static final int AL_TRUE = 1;
    public static final int AL_SOURCE_TYPE = 4135;
    public static final int AL_SOURCE_ABSOLUTE = 513;
    public static final int AL_SOURCE_RELATIVE = 514;
    public static final int AL_CONE_INNER_ANGLE = 4097;
    public static final int AL_CONE_OUTER_ANGLE = 4098;
    public static final int AL_PITCH = 4099;
    public static final int AL_POSITION = 4100;
    public static final int AL_DIRECTION = 4101;
    public static final int AL_VELOCITY = 4102;
    public static final int AL_LOOPING = 4103;
    public static final int AL_BUFFER = 4105;
    public static final int AL_GAIN = 4106;
    public static final int AL_MIN_GAIN = 4109;
    public static final int AL_MAX_GAIN = 4110;
    public static final int AL_ORIENTATION = 4111;
    public static final int AL_REFERENCE_DISTANCE = 4128;
    public static final int AL_ROLLOFF_FACTOR = 4129;
    public static final int AL_CONE_OUTER_GAIN = 4130;
    public static final int AL_MAX_DISTANCE = 4131;
    public static final int AL_CHANNEL_MASK = 12288;
    public static final int AL_SOURCE_STATE = 4112;
    public static final int AL_INITIAL = 4113;
    public static final int AL_PLAYING = 4114;
    public static final int AL_PAUSED = 4115;
    public static final int AL_STOPPED = 4116;
    public static final int AL_BUFFERS_QUEUED = 4117;
    public static final int AL_BUFFERS_PROCESSED = 4118;
    public static final int AL_FORMAT_MONO8 = 4352;
    public static final int AL_FORMAT_MONO16 = 4353;
    public static final int AL_FORMAT_STEREO8 = 4354;
    public static final int AL_FORMAT_STEREO16 = 4355;
    public static final int AL_FORMAT_VORBIS_EXT = 65539;
    public static final int AL_FREQUENCY = 8193;
    public static final int AL_BITS = 8194;
    public static final int AL_CHANNELS = 8195;
    public static final int AL_SIZE = 8196;
    public static final int AL_DATA = 8197;
    public static final int AL_UNUSED = 8208;
    public static final int AL_PENDING = 8209;
    public static final int AL_PROCESSED = 8210;
    public static final int AL_NO_ERROR = 0;
    public static final int AL_INVALID_NAME = 40961;
    public static final int AL_INVALID_ENUM = 40962;
    public static final int AL_INVALID_VALUE = 40963;
    public static final int AL_INVALID_OPERATION = 40964;
    public static final int AL_OUT_OF_MEMORY = 40965;
    public static final int AL_VENDOR = 45057;
    public static final int AL_VERSION = 45058;
    public static final int AL_RENDERER = 45059;
    public static final int AL_EXTENSIONS = 45060;
    public static final int AL_DOPPLER_FACTOR = 49152;
    public static final int AL_DOPPLER_VELOCITY = 49153;
    public static final int AL_DISTANCE_MODEL = 53248;
    public static final int AL_INVERSE_DISTANCE = 53249;
    public static final int AL_INVERSE_DISTANCE_CLAMPED = 53250;

    private AL10() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void alEnable(int capability) {
        AL10.nalEnable(capability);
        Util.checkALError();
    }

    private static native void nalEnable(int var0);

    public static void alDisable(int capability) {
        AL10.nalDisable(capability);
        Util.checkALError();
    }

    private static native void nalDisable(int var0);

    public static boolean alIsEnabled(int capability) {
        boolean __result = AL10.nalIsEnabled(capability);
        Util.checkALError();
        return __result;
    }

    private static native boolean nalIsEnabled(int var0);

    public static boolean alGetBoolean(int pname) {
        boolean __result = AL10.nalGetBoolean(pname);
        Util.checkALError();
        return __result;
    }

    private static native boolean nalGetBoolean(int var0);

    public static int alGetInteger(int pname) {
        int __result = AL10.nalGetInteger(pname);
        Util.checkALError();
        return __result;
    }

    private static native int nalGetInteger(int var0);

    public static float alGetFloat(int pname) {
        float __result = AL10.nalGetFloat(pname);
        Util.checkALError();
        return __result;
    }

    private static native float nalGetFloat(int var0);

    public static double alGetDouble(int pname) {
        double __result = AL10.nalGetDouble(pname);
        Util.checkALError();
        return __result;
    }

    private static native double nalGetDouble(int var0);

    public static void alGetInteger(int pname, IntBuffer data) {
        IntBuffer data_saved = data;
        data = NondirectBufferWrapper.wrapNoCopyBuffer(data, 1);
        AL10.nalGetIntegerv(pname, data, data.position());
        Util.checkALError();
        NondirectBufferWrapper.copy(data, data_saved);
    }

    private static native void nalGetIntegerv(int var0, IntBuffer var1, int var2);

    public static void alGetFloat(int pname, FloatBuffer data) {
        FloatBuffer data_saved = data;
        data = NondirectBufferWrapper.wrapNoCopyBuffer(data, 1);
        AL10.nalGetFloatv(pname, data, data.position());
        Util.checkALError();
        NondirectBufferWrapper.copy(data, data_saved);
    }

    private static native void nalGetFloatv(int var0, FloatBuffer var1, int var2);

    public static void alGetDouble(int pname, DoubleBuffer data) {
        DoubleBuffer data_saved = data;
        data = NondirectBufferWrapper.wrapNoCopyBuffer(data, 1);
        AL10.nalGetDoublev(pname, data, data.position());
        Util.checkALError();
        NondirectBufferWrapper.copy(data, data_saved);
    }

    private static native void nalGetDoublev(int var0, DoubleBuffer var1, int var2);

    public static native String alGetString(int var0);

    public static native int alGetError();

    public static boolean alIsExtensionPresent(String fname) {
        BufferChecks.checkNotNull(fname);
        boolean __result = AL10.nalIsExtensionPresent(fname);
        Util.checkALError();
        return __result;
    }

    private static native boolean nalIsExtensionPresent(String var0);

    public static int alGetEnumValue(String ename) {
        BufferChecks.checkNotNull(ename);
        int __result = AL10.nalGetEnumValue(ename);
        Util.checkALError();
        return __result;
    }

    private static native int nalGetEnumValue(String var0);

    public static void alListeneri(int pname, int value) {
        AL10.nalListeneri(pname, value);
        Util.checkALError();
    }

    private static native void nalListeneri(int var0, int var1);

    public static void alListenerf(int pname, float value) {
        AL10.nalListenerf(pname, value);
        Util.checkALError();
    }

    private static native void nalListenerf(int var0, float var1);

    public static void alListener(int pname, FloatBuffer value) {
        value = NondirectBufferWrapper.wrapBuffer(value, 1);
        AL10.nalListenerfv(pname, value, value.position());
        Util.checkALError();
    }

    private static native void nalListenerfv(int var0, FloatBuffer var1, int var2);

    public static void alListener3f(int pname, float v1, float v2, float v3) {
        AL10.nalListener3f(pname, v1, v2, v3);
        Util.checkALError();
    }

    private static native void nalListener3f(int var0, float var1, float var2, float var3);

    public static int alGetListeneri(int pname) {
        int __result = AL10.nalGetListeneri(pname);
        Util.checkALError();
        return __result;
    }

    private static native int nalGetListeneri(int var0);

    public static float alGetListenerf(int pname) {
        float __result = AL10.nalGetListenerf(pname);
        Util.checkALError();
        return __result;
    }

    private static native float nalGetListenerf(int var0);

    public static void alGetListener(int pname, FloatBuffer floatdata) {
        FloatBuffer floatdata_saved = floatdata;
        floatdata = NondirectBufferWrapper.wrapNoCopyBuffer(floatdata, 1);
        AL10.nalGetListenerfv(pname, floatdata, floatdata.position());
        Util.checkALError();
        NondirectBufferWrapper.copy(floatdata, floatdata_saved);
    }

    private static native void nalGetListenerfv(int var0, FloatBuffer var1, int var2);

    public static void alGenSources(IntBuffer sources) {
        IntBuffer sources_saved = sources;
        sources = NondirectBufferWrapper.wrapNoCopyDirect(sources);
        AL10.nalGenSources(sources.remaining(), sources, sources.position());
        Util.checkALError();
        NondirectBufferWrapper.copy(sources, sources_saved);
    }

    private static native void nalGenSources(int var0, IntBuffer var1, int var2);

    public static void alDeleteSources(IntBuffer sources) {
        sources = NondirectBufferWrapper.wrapDirect(sources);
        AL10.nalDeleteSources(sources.remaining(), sources, sources.position());
        Util.checkALError();
    }

    private static native void nalDeleteSources(int var0, IntBuffer var1, int var2);

    public static boolean alIsSource(int id) {
        boolean __result = AL10.nalIsSource(id);
        Util.checkALError();
        return __result;
    }

    private static native boolean nalIsSource(int var0);

    public static void alSourcei(int source, int pname, int value) {
        AL10.nalSourcei(source, pname, value);
        Util.checkALError();
    }

    private static native void nalSourcei(int var0, int var1, int var2);

    public static void alSourcef(int source, int pname, float value) {
        AL10.nalSourcef(source, pname, value);
        Util.checkALError();
    }

    private static native void nalSourcef(int var0, int var1, float var2);

    public static void alSource(int source, int pname, FloatBuffer value) {
        value = NondirectBufferWrapper.wrapBuffer(value, 1);
        AL10.nalSourcefv(source, pname, value, value.position());
        Util.checkALError();
    }

    private static native void nalSourcefv(int var0, int var1, FloatBuffer var2, int var3);

    public static void alSource3f(int source, int pname, float v1, float v2, float v3) {
        AL10.nalSource3f(source, pname, v1, v2, v3);
        Util.checkALError();
    }

    private static native void nalSource3f(int var0, int var1, float var2, float var3, float var4);

    public static int alGetSourcei(int source, int pname) {
        int __result = AL10.nalGetSourcei(source, pname);
        Util.checkALError();
        return __result;
    }

    private static native int nalGetSourcei(int var0, int var1);

    public static float alGetSourcef(int source, int pname) {
        float __result = AL10.nalGetSourcef(source, pname);
        Util.checkALError();
        return __result;
    }

    private static native float nalGetSourcef(int var0, int var1);

    public static void alGetSource(int source, int pname, FloatBuffer floatdata) {
        FloatBuffer floatdata_saved = floatdata;
        floatdata = NondirectBufferWrapper.wrapNoCopyBuffer(floatdata, 1);
        AL10.nalGetSourcefv(source, pname, floatdata, floatdata.position());
        Util.checkALError();
        NondirectBufferWrapper.copy(floatdata, floatdata_saved);
    }

    private static native void nalGetSourcefv(int var0, int var1, FloatBuffer var2, int var3);

    public static void alSourcePlay(IntBuffer sources) {
        sources = NondirectBufferWrapper.wrapDirect(sources);
        AL10.nalSourcePlayv(sources.remaining(), sources, sources.position());
        Util.checkALError();
    }

    private static native void nalSourcePlayv(int var0, IntBuffer var1, int var2);

    public static void alSourcePause(IntBuffer sources) {
        sources = NondirectBufferWrapper.wrapDirect(sources);
        AL10.nalSourcePausev(sources.remaining(), sources, sources.position());
        Util.checkALError();
    }

    private static native void nalSourcePausev(int var0, IntBuffer var1, int var2);

    public static void alSourceStop(IntBuffer sources) {
        sources = NondirectBufferWrapper.wrapDirect(sources);
        AL10.nalSourceStopv(sources.remaining(), sources, sources.position());
        Util.checkALError();
    }

    private static native void nalSourceStopv(int var0, IntBuffer var1, int var2);

    public static void alSourceRewind(IntBuffer sources) {
        sources = NondirectBufferWrapper.wrapDirect(sources);
        AL10.nalSourceRewindv(sources.remaining(), sources, sources.position());
        Util.checkALError();
    }

    private static native void nalSourceRewindv(int var0, IntBuffer var1, int var2);

    public static void alSourcePlay(int source) {
        AL10.nalSourcePlay(source);
        Util.checkALError();
    }

    private static native void nalSourcePlay(int var0);

    public static void alSourcePause(int source) {
        AL10.nalSourcePause(source);
        Util.checkALError();
    }

    private static native void nalSourcePause(int var0);

    public static void alSourceStop(int source) {
        AL10.nalSourceStop(source);
        Util.checkALError();
    }

    private static native void nalSourceStop(int var0);

    public static void alSourceRewind(int source) {
        AL10.nalSourceRewind(source);
        Util.checkALError();
    }

    private static native void nalSourceRewind(int var0);

    public static void alGenBuffers(IntBuffer buffers) {
        IntBuffer buffers_saved = buffers;
        buffers = NondirectBufferWrapper.wrapNoCopyDirect(buffers);
        AL10.nalGenBuffers(buffers.remaining(), buffers, buffers.position());
        Util.checkALError();
        NondirectBufferWrapper.copy(buffers, buffers_saved);
    }

    private static native void nalGenBuffers(int var0, IntBuffer var1, int var2);

    public static void alDeleteBuffers(IntBuffer buffers) {
        buffers = NondirectBufferWrapper.wrapDirect(buffers);
        AL10.nalDeleteBuffers(buffers.remaining(), buffers, buffers.position());
        Util.checkALError();
    }

    private static native void nalDeleteBuffers(int var0, IntBuffer var1, int var2);

    public static boolean alIsBuffer(int buffer) {
        boolean __result = AL10.nalIsBuffer(buffer);
        Util.checkALError();
        return __result;
    }

    private static native boolean nalIsBuffer(int var0);

    public static void alBufferData(int buffer, int format, ByteBuffer data, int freq) {
        data = NondirectBufferWrapper.wrapDirect(data);
        AL10.nalBufferData(buffer, format, data, data.position(), data.remaining(), freq);
        Util.checkALError();
    }

    public static void alBufferData(int buffer, int format, IntBuffer data, int freq) {
        data = NondirectBufferWrapper.wrapDirect(data);
        AL10.nalBufferData(buffer, format, data, data.position() << 2, data.remaining() << 2, freq);
        Util.checkALError();
    }

    public static void alBufferData(int buffer, int format, ShortBuffer data, int freq) {
        data = NondirectBufferWrapper.wrapDirect(data);
        AL10.nalBufferData(buffer, format, data, data.position() << 1, data.remaining() << 1, freq);
        Util.checkALError();
    }

    private static native void nalBufferData(int var0, int var1, Buffer var2, int var3, int var4, int var5);

    public static int alGetBufferi(int buffer, int pname) {
        int __result = AL10.nalGetBufferi(buffer, pname);
        Util.checkALError();
        return __result;
    }

    private static native int nalGetBufferi(int var0, int var1);

    public static float alGetBufferf(int buffer, int pname) {
        float __result = AL10.nalGetBufferf(buffer, pname);
        Util.checkALError();
        return __result;
    }

    private static native float nalGetBufferf(int var0, int var1);

    public static void alSourceQueueBuffers(int source, IntBuffer buffers) {
        buffers = NondirectBufferWrapper.wrapDirect(buffers);
        AL10.nalSourceQueueBuffers(source, buffers.remaining(), buffers, buffers.position());
        Util.checkALError();
    }

    private static native void nalSourceQueueBuffers(int var0, int var1, IntBuffer var2, int var3);

    public static void alSourceUnqueueBuffers(int source, IntBuffer buffers) {
        buffers = NondirectBufferWrapper.wrapDirect(buffers);
        AL10.nalSourceUnqueueBuffers(source, buffers.remaining(), buffers, buffers.position());
        Util.checkALError();
    }

    private static native void nalSourceUnqueueBuffers(int var0, int var1, IntBuffer var2, int var3);

    public static void alDistanceModel(int value) {
        AL10.nalDistanceModel(value);
        Util.checkALError();
    }

    private static native void nalDistanceModel(int var0);

    public static void alDopplerFactor(float value) {
        AL10.nalDopplerFactor(value);
        Util.checkALError();
    }

    private static native void nalDopplerFactor(float var0);

    public static void alDopplerVelocity(float value) {
        AL10.nalDopplerVelocity(value);
        Util.checkALError();
    }

    private static native void nalDopplerVelocity(float var0);
}

