/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.xml;

import com.jmex.xml.xml.Node;
import com.jmex.xml.xml.XmlException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Document
implements Serializable {
    protected static DocumentBuilderFactory factory = null;
    protected static DocumentBuilder builder = null;
    protected static boolean validation = false;
    protected org.w3c.dom.Document domDocument;
    protected String encoding = "UTF-8";
    protected String schemaLocation = null;
    protected String dtdLocation = null;
    public boolean prettyPrint = true;

    public static void enableValidation(boolean bl) {
        validation = bl;
    }

    protected static synchronized DocumentBuilder getDomBuilder() {
        try {
            if (builder == null) {
                if (factory == null) {
                    factory = DocumentBuilderFactory.newInstance();
                    factory.setIgnoringElementContentWhitespace(true);
                    factory.setNamespaceAware(true);
                    if (validation) {
                        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                        factory.setValidating(true);
                    }
                }
                builder = factory.newDocumentBuilder();
                builder.setErrorHandler(new ErrorHandler(){

                    public void warning(SAXParseException sAXParseException) {
                    }

                    public void error(SAXParseException sAXParseException) throws XmlException {
                        throw new XmlException(sAXParseException);
                    }

                    public void fatalError(SAXParseException sAXParseException) throws XmlException {
                        throw new XmlException(sAXParseException);
                    }
                });
            }
            return builder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XmlException(parserConfigurationException);
        }
    }

    public synchronized org.w3c.dom.Document getDomDocument() {
        if (this.domDocument == null) {
            this.domDocument = Document.getDomBuilder().newDocument();
        }
        return this.domDocument;
    }

    public Element createRootElement(String string, String string2) {
        Element element = null;
        if (this.dtdLocation != null && this.dtdLocation.length() != 0) {
            DocumentType documentType = Document.getDomBuilder().getDOMImplementation().createDocumentType(string2, null, this.dtdLocation);
            this.domDocument = Document.getDomBuilder().getDOMImplementation().createDocument(string, string2, documentType);
            element = this.domDocument.getDocumentElement();
        } else {
            element = this.getDomDocument().createElementNS(string, string2);
            this.domDocument.appendChild(element);
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (this.schemaLocation != null && this.schemaLocation.length() != 0) {
                if (string == null || string.equals("")) {
                    element.setAttribute("xsi:noNamespaceSchemaLocation", this.schemaLocation);
                } else {
                    element.setAttribute("xsi:schemaLocation", string + " " + this.schemaLocation);
                }
            }
        }
        return element;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public void setDTDLocation(String string) {
        this.dtdLocation = string;
    }

    public org.w3c.dom.Node load(String string) {
        try {
            return Document.getDomBuilder().parse(new File(string)).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public org.w3c.dom.Node load(InputStream inputStream) {
        try {
            return Document.getDomBuilder().parse(inputStream).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public org.w3c.dom.Node loadFromString(String string) {
        try {
            return Document.getDomBuilder().parse(new ByteArrayInputStream(string.getBytes())).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public void save(String string, Node node) {
        Node.internalAdjustPrefix(node.domNode, true);
        node.adjustPrefix();
        if (this.prettyPrint) {
            this.indentNode(node.domNode, 0);
        }
        Document.internalSave(new StreamResult(new File(string)), node.domNode.getOwnerDocument(), this.encoding);
        System.gc();
    }

    public void save(OutputStream outputStream, Node node) {
        Node.internalAdjustPrefix(node.domNode, true);
        node.adjustPrefix();
        if (this.prettyPrint) {
            this.indentNode(node.domNode, 0);
        }
        Document.internalSave(new StreamResult(outputStream), node.domNode.getOwnerDocument(), this.encoding);
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
    }

    public String saveToString(Node node) {
        Node.internalAdjustPrefix(node.domNode, true);
        node.adjustPrefix();
        if (this.prettyPrint) {
            this.indentNode(node.domNode, 0);
        }
        StringWriter stringWriter = new StringWriter();
        Document.internalSave(new StreamResult(stringWriter), node.domNode.getOwnerDocument(), this.encoding);
        return stringWriter.toString();
    }

    protected static void internalSave(Result result, org.w3c.dom.Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (string != null) {
                transformer.setOutputProperty("encoding", string);
            }
            if (document.getDoctype() != null) {
                if (document.getDoctype().getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", document.getDoctype().getPublicId());
                }
                if (document.getDoctype().getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
                }
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XmlException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XmlException(transformerException);
        }
    }

    public org.w3c.dom.Node transform(Node node, String string) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(string));
            DOMResult dOMResult = new DOMResult();
            transformer.transform(new DOMSource(node.domNode), dOMResult);
            return dOMResult.getNode();
        }
        catch (TransformerException transformerException) {
            throw new XmlException(transformerException);
        }
    }

    public abstract void declareNamespaces(Node var1);

    protected void declareNamespace(Node node, String string, String string2) {
        node.declareNamespace(string, string2);
    }

    private void indentNode(org.w3c.dom.Node node, int n) {
        Object object;
        if (node == null) {
            return;
        }
        if (n > 0 && (node.getNodeType() == 1 || node.getNodeType() == 8) && (node.getPreviousSibling() == null || node.getPreviousSibling().getNodeType() != 4 && node.getPreviousSibling().getNodeType() != 3)) {
            object = "\n";
            for (int i = 0; i < n; ++i) {
                object = (String)object + "\t";
            }
            node.getParentNode().insertBefore(node.getOwnerDocument().createTextNode((String)object), node);
            if (node.getNextSibling() == null) {
                object = ((String)object).substring(0, n);
                node.getParentNode().appendChild(node.getOwnerDocument().createTextNode((String)object));
            }
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            this.indentNode((org.w3c.dom.Node)object, n + 1);
        }
    }
}

