/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaDecimal;
import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.SchemaTypeException;
import com.jmex.xml.types.SchemaTypeNumber;
import com.jmex.xml.types.StringParseException;
import com.jmex.xml.types.TypesIncompatibleException;
import com.jmex.xml.types.ValuesNotConvertableException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaInteger
implements SchemaTypeNumber {
    protected BigInteger value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaInteger() {
        this.setEmpty();
    }

    public SchemaInteger(SchemaInteger schemaInteger) {
        this.value = schemaInteger.value;
        this.isempty = schemaInteger.isempty;
        this.isnull = schemaInteger.isnull;
    }

    public SchemaInteger(BigInteger bigInteger) {
        this.setValue(bigInteger);
    }

    public SchemaInteger(long l) {
        this.setValue(l);
    }

    public SchemaInteger(String string) {
        this.parse(string);
    }

    public SchemaInteger(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaInteger(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.isempty = true;
            this.isnull = true;
            this.value = BigInteger.valueOf(0L);
            return;
        }
        this.value = bigInteger;
        this.isempty = false;
        this.isnull = false;
    }

    public void setValue(long l) {
        this.value = BigInteger.valueOf(l);
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.value = new BigInteger(string2);
                this.isempty = false;
                this.isnull = false;
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException(numberFormatException);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = ((SchemaTypeNumber)schemaType).bigIntegerValue();
            this.isempty = false;
            this.isnull = false;
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = BigInteger.valueOf(0L);
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = BigInteger.valueOf(0L);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaInteger)) {
            return false;
        }
        return this.value.equals(((SchemaInteger)object).value);
    }

    public Object clone() {
        return new SchemaInteger(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return this.value.toString();
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value.compareTo(BigInteger.valueOf(0L)) != 0;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaInteger)object);
    }

    public int compareTo(SchemaInteger schemaInteger) {
        return this.value.compareTo(schemaInteger.value);
    }

    public int numericType() {
        return 3;
    }

    public int intValue() {
        if (this.value.compareTo(new BigInteger("2147483647")) > 0 || this.value.compareTo(new BigInteger("-2147483648")) < 0) {
            throw new SchemaTypeException("Overflow: value " + this.value + " cannot be converted to int");
        }
        return this.value.intValue();
    }

    public long longValue() {
        if (this.value.compareTo(new BigInteger("9223372036854775807")) > 0 || this.value.compareTo(new BigInteger("-9223372036854775808")) < 0) {
            throw new SchemaTypeException("Overflow: value " + this.value + " cannot be converted to long");
        }
        return this.value.longValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public float floatValue() {
        float f = this.value.floatValue();
        if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
            throw new SchemaTypeException("Overflow: value " + this.value + " cannot be converted to float");
        }
        return f;
    }

    public double doubleValue() {
        double d = this.value.doubleValue();
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            throw new SchemaTypeException("Overflow: value " + this.value + " cannot be converted to double");
        }
        return d;
    }

    public BigDecimal bigDecimalValue() {
        try {
            return new BigDecimal(this.value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaDecimal(0.0));
        }
    }
}

