/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaString;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.StringParseException;
import com.jmex.xml.types.TypesIncompatibleException;
import java.net.URI;

public class SchemaAnyURI
implements SchemaType {
    protected URI value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaAnyURI() {
        this.setEmpty();
    }

    public SchemaAnyURI(SchemaAnyURI schemaAnyURI) {
        this.value = schemaAnyURI.value;
        this.isempty = schemaAnyURI.isempty;
        this.isnull = schemaAnyURI.isnull;
    }

    public SchemaAnyURI(URI uRI) {
        this.setValue(uRI);
    }

    public SchemaAnyURI(String string) {
        this.parse(string);
    }

    public SchemaAnyURI(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public URI getValue() {
        return this.value;
    }

    public void setValue(URI uRI) {
        if (uRI == null) {
            this.isempty = true;
            this.isnull = true;
        } else {
            this.isnull = false;
            this.isempty = false;
            this.value = uRI;
        }
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            this.setNull();
            try {
                this.value = URI.create(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new StringParseException(illegalArgumentException);
            }
            this.isnull = false;
            this.isempty = false;
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaString) {
            this.parse(((Object)schemaType).toString());
        } else if (schemaType instanceof SchemaAnyURI) {
            this.setValue(((SchemaAnyURI)schemaType).value);
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = null;
    }

    public void setEmpty() {
        this.parse("http://www.altova.com/language_select.html");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaAnyURI)) {
            return false;
        }
        return this.value.equals(((SchemaAnyURI)object).value);
    }

    public Object clone() {
        return new SchemaAnyURI(this);
    }

    public String toString() {
        if (this.isempty || this.isnull || this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public int length() {
        return this.value.toString().length();
    }

    public boolean booleanValue() {
        return this.value != null && this.value.toString().length() != 0;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaAnyURI)object);
    }

    public int compareTo(SchemaAnyURI schemaAnyURI) {
        return this.toString().compareTo(schemaAnyURI.toString());
    }
}

