/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.FileUtils;

public class ExcludesClassNameCache {
    private static final Logger log = Logger.getLogger(ExcludesClassNameCache.class);
    private static final File file = new File(Pleiades.getConfigurationPath(), "excludes-class.list");
    private static final ExcludesClassNameCache singleton = new ExcludesClassNameCache();
    private Set<String> excludeSet = new HashSet<String>();
    private int loadedSize;

    public static ExcludesClassNameCache getInstance() {
        return singleton;
    }

    private ExcludesClassNameCache() {
        if (Pleiades.getPleiadesOption().isClean()) {
            log.info("-clean \u306b\u3088\u308a\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u306f\u30ed\u30fc\u30c9\u3055\u308c\u307e\u305b\u3093\u3002");
        } else if (!file.exists()) {
            log.info("\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        } else {
            try {
                this.excludeSet.addAll(FileUtils.readLines((File)file, null));
                log.info("\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.excludeSet.size());
            }
            catch (IOException e) {
                String msg = "\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
                IllegalStateException ise = new IllegalStateException(msg, e);
                Pleiades.abort(ise);
            }
        }
        this.loadedSize = this.excludeSet.size();
    }

    public void store() {
        if (this.excludeSet.size() > this.loadedSize) {
            try {
                FileUtils.writeLines((File)file, null, this.excludeSet);
                log.info("\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u4fdd\u7ba1\u3057\u307e\u3057\u305f\u3002" + this.loadedSize + " -> " + this.excludeSet.size());
            }
            catch (IOException e) {
                log.error("\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u4fdd\u7ba1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
        }
    }

    public void add(String className) {
        this.excludeSet.add(className);
    }

    public boolean contains(String className) {
        return this.excludeSet.contains(className);
    }
}

