/*
 * Decompiled with CFR 0.152.
 */
package webstart;

import com.jme.app.SimpleGame;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import md5reader.defs.DefStore;
import md5reader.defs.ModelDef;
import md5reader.defs.PakLoader;
import model.Model;
import model.ModelInstance;
import model.animation.Animation;
import model.animation.AnimationController;
import model.animation.AnimationUtils;

public class MD5WebStart
extends SimpleGame {
    DefStore store;
    ModelDef def;
    ModelInstance instance;
    AnimationController animator;
    volatile ModelDef newModel;

    public static void main(String[] args) throws IOException {
        File f;
        Preferences prefs = Preferences.userNodeForPackage(MD5WebStart.class);
        String filename = prefs.get("pk4path", null);
        JFileChooser c = new JFileChooser();
        c.setMultiSelectionEnabled(true);
        if (filename != null && (f = new File(filename)).isDirectory()) {
            c.setCurrentDirectory(f);
        }
        if (c.showOpenDialog(null) != 0) {
            return;
        }
        prefs.put("pk4path", c.getCurrentDirectory().getAbsolutePath());
        DefStore store = PakLoader.loadPak(c.getSelectedFiles());
        MD5WebStart app = new MD5WebStart(store);
        app.setDialogBehaviour(2);
        app.start();
    }

    private List modelNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.store.getModelDefNames()) {
            ModelDef def = this.store.getModelDef(name);
            String modelName = def.getModelName();
            if (modelName == null || !modelName.endsWith(".md5mesh")) continue;
            names.add(name);
        }
        return names;
    }

    public MD5WebStart(DefStore aStore) {
        this.store = aStore;
        JFrame frame = new JFrame("Select model");
        frame.getContentPane().setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane(1);
        frame.getContentPane().add((Component)split, "Center");
        DefaultListModel msModel = new DefaultListModel();
        this.addAll(msModel, this.modelNames());
        final DefaultListModel aModel = new DefaultListModel();
        JPanel ms = new JPanel(new BorderLayout());
        final JList msList = new JList(msModel);
        JButton msButton = new JButton("Choose model");
        msButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (msList.getSelectedValue() != null) {
                    ModelDef def;
                    MD5WebStart.this.newModel = def = MD5WebStart.this.store.getModelDef(msList.getSelectedValue().toString());
                    aModel.removeAllElements();
                    MD5WebStart.this.addAll(aModel, def.getAnimationNames());
                }
            }
        });
        ms.add((Component)new JScrollPane(msList), "Center");
        ms.add((Component)msButton, "South");
        JPanel a = new JPanel(new BorderLayout());
        final JList aList = new JList(aModel);
        JButton aButton = new JButton("Choose animation");
        aButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (aList.getSelectedValue() != null) {
                    MD5WebStart.this.selectAnimation(aList.getSelectedValue().toString());
                }
            }
        });
        a.add((Component)new JScrollPane(aList), "Center");
        a.add((Component)aButton, "South");
        split.setLeftComponent(ms);
        split.setRightComponent(a);
        frame.pack();
        frame.setVisible(true);
    }

    void selectModel(ModelDef def) {
        try {
            Model model = def.getModel();
            this.def = def;
            this.instance = model.createInstance();
            this.animator = this.instance.addAnimationController();
            this.instance.setLocalScale(0.25f);
            this.animator.addAnimator(this.animator.createBindAnimator());
            this.rootNode.detachAllChildren();
            this.rootNode.attachChild((Spatial)this.instance);
            this.rootNode.updateRenderState();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    void selectAnimation(String name) {
        try {
            Animation animation;
            if (this.def != null && this.animator != null && (animation = this.def.getAnimation(name)) != null) {
                this.animator.fadeToAnimator(AnimationUtils.createAnimator(animation), 0.33f);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    protected void simpleInitGame() {
        this.lightState.get(0).setAmbient(new ColorRGBA(2.5f, 2.5f, 2.5f, 1.0f));
    }

    protected void simpleUpdate() {
        if (this.newModel != null) {
            this.selectModel(this.newModel);
            this.newModel = null;
        }
    }

    void addAll(DefaultListModel model, Collection items) {
        ArrayList list = new ArrayList(items);
        Collections.sort(list);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
    }
}

