/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import model.KeyFrame;
import model.Model;
import model.ModelInstance;
import model.SkeletalKeyFrame;
import model.SkeletalModelInstance;
import model.Skeleton;
import model.Skin;
import util.file.FileUtils;

public class SkeletalModel
extends Model {
    private Skeleton skeleton;

    public SkeletalModel(String name, int meshCount, Skin defaultSkin) {
        super(name, meshCount, defaultSkin);
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public SkeletalKeyFrame getBindSkeletal() {
        SkeletalKeyFrame bind = (SkeletalKeyFrame)super.getBind();
        if (bind == null) {
            bind = this.skeleton.getBindFrame();
        }
        return bind;
    }

    @Override
    public KeyFrame getBind() {
        return this.getBindSkeletal();
    }

    @Override
    public ModelInstance createInstance() {
        return new SkeletalModelInstance(this);
    }

    @Override
    public boolean isSkeletal() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        FileUtils.checkVersionByte(in, 1, 1);
        this.skeleton = (Skeleton)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        out.writeObject(this.skeleton);
    }
}

