/*
 * Decompiled with CFR 0.152.
 */
package md5reader.defs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import md5reader.defs.EntityDef;
import md5reader.defs.MaterialDef;
import md5reader.defs.ModelDef;
import md5reader.defs.SkinDef;

public class DefStore {
    private Map entityDefs = new HashMap();
    private Map modelDefs = new HashMap();
    private Map materialDefs = new HashMap();
    private Map skinDefs = new HashMap();
    private List zipFiles = new ArrayList();

    public void addZipFile(ZipFile file) {
        this.zipFiles.add(file);
    }

    public EntityDef getEntityDef(String name) {
        return (EntityDef)this.entityDefs.get(name);
    }

    public ModelDef getModelDef(String name) {
        return (ModelDef)this.modelDefs.get(name);
    }

    public MaterialDef getMaterialDef(String name) {
        return (MaterialDef)this.materialDefs.get(name);
    }

    public SkinDef getSkinDef(String name) {
        return (SkinDef)this.skinDefs.get(name);
    }

    public EntityDef createEntityDef(String name, Map entityMap) {
        EntityDef def = new EntityDef(this, name, entityMap);
        this.entityDefs.put(name, def);
        return def;
    }

    public ModelDef createModelDef(String name, String parent, String model, Map animations) {
        ModelDef def = new ModelDef(this, name, parent, model, animations);
        this.modelDefs.put(name, def);
        return def;
    }

    public MaterialDef createMaterialDef(String name, String diffuse) {
        MaterialDef def = new MaterialDef(this, name, diffuse);
        this.materialDefs.put(name, def);
        return def;
    }

    public SkinDef createSkinDef(String name, Map nameMap) {
        SkinDef def = new SkinDef(this, name, nameMap);
        this.skinDefs.put(name, def);
        return def;
    }

    public Set getMaterialDefNames() {
        return this.materialDefs.keySet();
    }

    public Set getModelDefNames() {
        return this.modelDefs.keySet();
    }

    public Set getEntityDefNames() {
        return this.entityDefs.keySet();
    }

    public Set getSkinDefNames() {
        return this.skinDefs.keySet();
    }

    public InputStream getInputStream(String name) throws IOException {
        for (int i = 0; i < this.zipFiles.size(); ++i) {
            ZipFile file = (ZipFile)this.zipFiles.get(i);
            ZipEntry entry = file.getEntry(name);
            if (entry == null) continue;
            return file.getInputStream(file.getEntry(name));
        }
        return null;
    }

    public ClassLoader makeClassLoader() throws IOException {
        URL[] urls = new URL[this.zipFiles.size()];
        for (int i = 0; i < this.zipFiles.size(); ++i) {
            urls[i] = new File(((ZipFile)this.zipFiles.get(i)).getName()).toURL();
        }
        return new URLClassLoader(urls);
    }
}

