/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import com.jme.scene.Spatial;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TestShader {
    public static final TestShader INSTANCE = new TestShader();
    private List nodes = new ArrayList();
    private GLSLShaderObjectsState program;

    private TestShader() {
        this.recreateShaders();
    }

    public GLSLShaderObjectsState getProgram() {
        return this.program;
    }

    public void addNode(Spatial node) {
        this.nodes.add(node);
        this.apply(node);
    }

    public void removeNode(Spatial node) {
        this.nodes.remove(node);
        node.clearRenderState(14);
    }

    public void recreateShaders() {
        this.loadShaders();
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            this.apply((Spatial)i.next());
        }
    }

    private void apply(Spatial node) {
        if (this.program != null) {
            node.setRenderState((RenderState)this.program);
        } else {
            node.clearRenderState(14);
        }
        node.updateRenderState();
    }

    private void loadShaders() {
        try {
            GLSLShaderObjectsState state = DisplaySystem.getDisplaySystem().getRenderer().createGLSLShaderObjectsState();
            state.load(this.getClass().getResource("shader.vp"), this.getClass().getResource("shader.fp"));
            this.program = state;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

