/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import md5reader.TestShader;
import model.ModelTriMesh;
import model.Shader;

public class MD5BumpShader
extends Shader {
    private TextureState state = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
    private MaterialState material;
    static Vector3f[] tangent = new Vector3f[0];

    public MD5BumpShader(Texture detail, Texture normalMap) {
        this.state.setTexture(detail, 0);
        this.state.setTexture(normalMap, 1);
        this.material = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        this.material.setSpecular(ColorRGBA.gray);
        this.material.setShininess(10.0f);
    }

    @Override
    public void setup(ModelTriMesh mesh) {
        mesh.setRenderState((RenderState)this.state);
        mesh.setRenderState((RenderState)this.material);
        TestShader.INSTANCE.addNode((Spatial)mesh);
        Vector3f[] textures = new Vector3f[mesh.getVertexBuffer(0).capacity()];
        for (int i = 0; i < textures.length; ++i) {
            textures[i] = new Vector3f();
        }
        GLSLShaderObjectsState program = TestShader.INSTANCE.getProgram();
        if (program == null) {
            return;
        }
        program.setUniform("colourMap", this.state.getTexture(0).getTextureId());
        program.setUniform("normalMap", this.state.getTexture(1).getTextureId());
    }

    @Override
    public void updateMesh(ModelTriMesh mesh) {
        this.updateLightVectors(mesh);
    }

    public void preRender(ModelTriMesh mesh) {
    }

    @Override
    public boolean requiresNormals() {
        return true;
    }

    private Vector3f[] tangent(int size) {
        for (int i = 0; i < tangent.length; ++i) {
            tangent[i].set(0.0f, 0.0f, 0.0f);
        }
        if (tangent.length < size) {
            Vector3f[] tan = new Vector3f[size];
            System.arraycopy(tangent, 0, tan, 0, tangent.length);
            for (int i = tangent.length; i < size; ++i) {
                tan[i] = new Vector3f();
            }
            tangent = tan;
        }
        return tangent;
    }

    private void updateLightVectors(ModelTriMesh mesh) {
        Vector3f sdir = new Vector3f();
        int[] indices = BufferUtils.getIntArray((IntBuffer)mesh.getIndexBuffer(1));
        Vector3f[] vertex = BufferUtils.getVector3Array((FloatBuffer)mesh.getVertexBuffer(1));
        Vector2f[] texcoord = BufferUtils.getVector2Array((FloatBuffer)mesh.getTextureBuffer(0, 1));
        Object tangentArray = null;
        Vector3f[] normal = BufferUtils.getVector3Array((FloatBuffer)mesh.getNormalBuffer(1));
        int triangleCount = mesh.getTriangleCount();
        int vertexCount = mesh.getVertexCount();
        Vector3f[] tangent = this.tangent(vertexCount);
        for (int a = 0; a < triangleCount; ++a) {
            int i1 = indices[a * 3];
            int i2 = indices[a * 3 + 1];
            int i3 = indices[a * 3 + 2];
            Vector3f v1 = vertex[i1];
            Vector3f v2 = vertex[i2];
            Vector3f v3 = vertex[i3];
            Vector2f w1 = texcoord[i1];
            Vector2f w2 = texcoord[i2];
            Vector2f w3 = texcoord[i3];
            float x12 = v2.x - v1.x;
            float x13 = v3.x - v1.x;
            float y12 = v2.y - v1.y;
            float y13 = v3.y - v1.y;
            float z12 = v2.z - v1.z;
            float z13 = v3.z - v1.z;
            float t12 = w2.y - w1.y;
            float t13 = w3.y - w1.y;
            sdir.set(t13 * x12 - t12 * x13, t13 * y12 - t12 * y13, t13 * z12 - t12 * z13).normalizeLocal();
            tangent[i1].addLocal(sdir);
            tangent[i2].addLocal(sdir);
            tangent[i3].addLocal(sdir);
        }
        Vector3f n = new Vector3f();
        Vector3f t = new Vector3f();
        for (int a = 0; a < vertexCount; ++a) {
            n.set(normal[a]);
            t.set(tangent[a]);
            tangentArray[a].set(n.multLocal(n).multLocal(t).subtractLocal(t).negateLocal());
            tangentArray[a].normalizeLocal();
        }
    }
}

