/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import md5reader.AbstractD3Reader;
import model.SkeletalKeyFrame;
import model.Skeleton;
import model.animation.Animation;
import model.animation.SkeletalAnimation;
import model.file.AnimationReader;

public class MD5AnimReader
extends AbstractD3Reader
implements AnimationReader {
    private static final int TRANS_X = 1;
    private static final int TRANS_Y = 2;
    private static final int TRANS_Z = 4;
    private static final int ROT_X = 8;
    private static final int ROT_Y = 16;
    private static final int ROT_Z = 32;
    private static final int ANY_TRANS = 7;
    private static final int ANY_ROT = 56;
    private SkeletalAnimation animation;

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public Animation readAnimation(InputStream in) throws IOException {
        String text;
        this.setInputStream(in);
        this.animation = new SkeletalAnimation();
        int framesPerSec = 0;
        int numAnimatedComponents = 0;
        BitSet flags = null;
        while ((text = this.readStringStartOfLine()) != null) {
            if (text.equals("MD5Version")) {
                this.readPositiveInt();
                continue;
            }
            if (text.equals("commandline")) {
                this.skip(3);
                continue;
            }
            if (text.equals("numJoints")) {
                int joints = this.readPositiveInt();
                Skeleton skeleton = new Skeleton(joints);
                this.animation.setSkeleton(skeleton);
                this.animation.setBaseFrame(skeleton.getBindFrame());
                continue;
            }
            if (text.equals("numFrames")) {
                this.readPositiveInt();
                continue;
            }
            if (text.equals("frameRate")) {
                framesPerSec = this.readPositiveInt();
                continue;
            }
            if (text.equals("numAnimatedComponents")) {
                numAnimatedComponents = this.readPositiveInt();
                continue;
            }
            if (text.equals("hierarchy")) {
                this.skip(6);
                flags = this.loadJoints();
                continue;
            }
            if (text.equals("bounds")) {
                this.skip(6);
                this.skipRestOfSection();
                continue;
            }
            if (text.equals("baseframe")) {
                this.skip(6);
                this.loadBaseFrame();
                continue;
            }
            if (text.equals("frame")) {
                int frameNum = this.readPositiveInt();
                this.skip(6);
                this.loadFrame(frameNum - 1, framesPerSec, flags);
                continue;
            }
            throw new IOException("Unexpected text: " + text);
        }
        return this.animation;
    }

    private BitSet loadJoints() throws IOException {
        String text;
        BitSet flagSet = new BitSet();
        int i = 0;
        while ((text = this.readStringStartOfLine()) != null) {
            this.animation.getSkeleton().getJointNames()[i] = text;
            this.animation.getSkeleton().getParents()[i] = this.readInt();
            int flags = this.readPositiveInt();
            for (int f = 0; f < 6; ++f) {
                flagSet.set(i * 6 + f, (flags & 1 << f) != 0);
            }
            this.animation.getSuppliedPositions().set(i, (flags & 7) != 0);
            this.animation.getSuppliedRotations().set(i, (flags & 0x38) != 0);
            this.skip(2);
            ++i;
        }
        return flagSet;
    }

    private void loadBaseFrame() throws IOException {
        Vector3f pos;
        SkeletalKeyFrame base = this.animation.getBaseFrameSkeletal();
        int[] parents = this.animation.getSkeleton().getParents();
        int i = 0;
        while ((pos = this.readVector3fStartOfLine()) != null) {
            base.positions[i] = pos;
            base.rotations[i] = this.readQuaternion();
            if (parents[i] < 0) {
                base.rotations[i].set(BASE.mult(base.rotations[i]));
            }
            ++i;
        }
    }

    private void loadFrame(int frameNum, int framesPerSec, BitSet flags) throws IOException {
        int[] parents = this.animation.getSkeleton().getParents();
        SkeletalKeyFrame frame = new SkeletalKeyFrame(this.animation.getSuppliedPositions().cardinality(), this.animation.getSuppliedRotations().cardinality());
        frame.time = (float)frameNum / (float)framesPerSec;
        Vector3f[] baseTrans = this.animation.getBaseFrameSkeletal().positions;
        Quaternion[] baseRot = this.animation.getBaseFrameSkeletal().rotations;
        int it = 0;
        int ir = 0;
        for (int i = 0; i < parents.length; ++i) {
            float rz;
            float tx = flags.get(i * 6) ? this.readFloatStartOfLine() : baseTrans[i].x;
            float ty = flags.get(i * 6 + 1) ? this.readFloatStartOfLine() : baseTrans[i].y;
            float tz = flags.get(i * 6 + 2) ? this.readFloatStartOfLine() : baseTrans[i].z;
            float rx = flags.get(i * 6 + 3) ? this.readFloatStartOfLine() : baseRot[i].x;
            float ry = flags.get(i * 6 + 4) ? this.readFloatStartOfLine() : baseRot[i].y;
            float f = rz = flags.get(i * 6 + 5) ? this.readFloatStartOfLine() : baseRot[i].z;
            if (this.animation.getSuppliedPositions().get(i)) {
                frame.positions[it] = parents[i] < 0 ? new Vector3f(tz, ty, tx) : new Vector3f(tx, ty, tz);
                ++it;
            }
            if (!this.animation.getSuppliedRotations().get(i)) continue;
            frame.rotations[ir] = parents[i] < 0 ? this.makeQuaternion(rz, ry, rx) : this.makeQuaternion(rx, ry, rz);
            ++ir;
        }
        this.skip(7);
        this.animation.addKeyFrame(frame);
    }
}

