/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.util;

import com.jmex.audio.AudioSystem;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.event.TrackLoadListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoundLoadingQueue {
    private static final Logger logger = Logger.getLogger(SoundLoadingQueue.class.getName());
    private static HashMap<URI, Vector<TrackLoadListener>> queue = new HashMap();
    private static QueueProcessorThread processThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadSound(URI uRI, TrackLoadListener trackLoadListener) {
        HashMap<URI, Vector<TrackLoadListener>> hashMap = queue;
        synchronized (hashMap) {
            Vector<TrackLoadListener> vector = queue.get(uRI);
            if (vector == null) {
                vector = new Vector();
                queue.put(uRI, vector);
            }
            vector.add(trackLoadListener);
        }
        SoundLoadingQueue.loadQueue();
    }

    private static void loadQueue() {
        if (processThread == null || !processThread.isAlive()) {
            processThread = new QueueProcessorThread();
            processThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadNextSound(URI uRI) {
        Vector<TrackLoadListener> vector = null;
        Object object = queue;
        synchronized (object) {
            vector = queue.remove(uRI);
        }
        try {
            object = AudioSystem.getSystem().createAudioTrack(uRI.toURL(), false);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.WARNING, "Error creating AutioTrack", malformedURLException);
            return;
        }
        if (vector != null) {
            for (TrackLoadListener trackLoadListener : vector) {
                trackLoadListener.trackLoaded((AudioTrack)object);
            }
        }
    }

    static class QueueProcessorThread
    extends Thread {
        private static final long PROCESSOR_SLEEP = 250L;

        QueueProcessorThread() {
            this.setDaemon(true);
        }

        public void run() {
            int n = Runtime.getRuntime().availableProcessors();
            while (queue.size() > 0) {
                Set set;
                try {
                    QueueProcessorThread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    logger.logp(Level.SEVERE, this.getClass().toString(), "run()", "Exception", interruptedException);
                }
                if ((set = queue.keySet()) == null) continue;
                Object[] objectArray = set.toArray();
                for (int i = 0; i < n && i < set.size(); ++i) {
                    URI uRI = (URI)objectArray[i];
                    SoundLoadingQueue.loadNextSound(uRI);
                }
            }
        }
    }
}

