/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.filter;

import com.jmex.audio.filter.Filter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class BandpassFilter
extends Filter {
    private float qParam = 1.6f;
    private double[] alpha;
    private double[] beta;
    private double[] gamma;

    public BandpassFilter(int[] nArray) {
        super(nArray);
    }

    public void init(int n) {
        super.initalize(n);
        this.alpha = new double[this.frequencies.length];
        this.beta = new double[this.frequencies.length];
        this.gamma = new double[this.frequencies.length];
        this.resetABC(this.qParam);
    }

    public void resetABC(double d) {
        for (int i = 0; i < this.theta.length; ++i) {
            double d2 = Math.tan(this.theta[i] / (2.0 * d));
            this.beta[i] = 0.5 * ((1.0 - d2) / (1.0 + d2));
            this.alpha[i] = (0.5 - this.beta[i]) / 2.0;
            this.gamma[i] = (0.5 + this.beta[i]) * Math.cos(this.theta[i]);
        }
    }

    public byte[] filter(byte[] byArray) {
        int n;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        ShortBuffer shortBuffer = ByteBuffer.wrap(byArray).order(byteOrder).asShortBuffer();
        short[] sArray = new short[byArray.length / 2];
        for (n = 0; n < sArray.length; ++n) {
            sArray[n] = shortBuffer.get(n);
        }
        if (this.output == null) {
            this.output = new double[sArray.length];
        }
        for (n = 0; n < this.output.length; ++n) {
            this.output[n] = (double)sArray[n] * this.gainFactor;
        }
        for (n = 0; n < this.frequencies.length; ++n) {
            this.passBand(n, sArray);
        }
        for (n = 0; n < this.output.length; ++n) {
            sArray[n] = (short)Math.min(32767.0, Math.max(this.output[n], -32768.0));
        }
        return this.toByte(sArray, true);
    }

    private void passBand(int n, short[] sArray) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < sArray.length) {
            dArray[n2] = sArray[n5];
            n3 = n2 - 2;
            if (n3 < 0) {
                n3 += 3;
            }
            if ((n4 = n2 - 1) < 0) {
                n4 += 3;
            }
            dArray2[n2] = 2.0 * (this.alpha[n] * (dArray[n2] - dArray[n3]) + this.gamma[n] * dArray2[n4] - this.beta[n] * dArray2[n3]);
            int n6 = n5++;
            this.output[n6] = this.output[n6] + this.adjust[n] * dArray2[n2];
            n2 = (n2 + 1) % 3;
        }
    }

    public byte[] toByte(short[] sArray, boolean bl) {
        byte[] byArray = new byte[sArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < sArray.length) {
            byte[] byArray2 = BandpassFilter.toByte(sArray[n], bl);
            byArray[n2] = byArray2[0];
            byArray[n2 + 1] = byArray2[1];
            ++n;
            n2 += 2;
        }
        return byArray;
    }

    public static final byte[] toByte(short s, boolean bl) {
        byte[] byArray = new byte[2];
        for (int n = 0; n <= 1; n = (int)((byte)(n + 1))) {
            byArray[n] = (byte)(s >>> (1 - n) * 8);
        }
        if (bl) {
            byArray = BandpassFilter.reverse_order(byArray, 2);
        }
        return byArray;
    }

    public static final byte[] toByte(short s) {
        return BandpassFilter.toByte(s, false);
    }

    private static final byte[] reverse_order(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        for (int n2 = 0; n2 <= n - 1; n2 = (int)((byte)(n2 + 1))) {
            byArray2[n2] = byArray[n - 1 - n2];
        }
        return byArray2;
    }
}

