/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters.maxutils;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.resource.ResourceLocatorTool;
import com.jmex.model.converters.FormatConverter;
import com.jmex.model.converters.maxutils.ChunkHeader;
import com.jmex.model.converters.maxutils.ChunkerClass;
import com.jmex.model.converters.maxutils.ColorChunk;
import com.jmex.model.converters.maxutils.PercentChunk;
import com.jmex.model.converters.maxutils.TextureChunk;
import java.io.DataInput;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

class MaterialBlock
extends ChunkerClass {
    private static final Logger logger = Logger.getLogger(MaterialBlock.class.getName());
    String name;
    MaterialState myMatState;
    TextureState myTexState;
    WireframeState myWireState;

    public MaterialBlock(DataInput dataInput, ChunkHeader chunkHeader, FormatConverter formatConverter) throws IOException {
        super(dataInput);
        this.setHeader(chunkHeader);
        this.initializeVariables();
        this.chunk();
    }

    protected void initializeVariables() {
        this.myMatState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        this.myMatState.setEnabled(false);
        this.myWireState = DisplaySystem.getDisplaySystem().getRenderer().createWireframeState();
        this.myWireState.setEnabled(false);
        this.myTexState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        this.myTexState.setEnabled(false);
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 40960: {
                this.readMatName();
                return true;
            }
            case 40976: {
                this.myMatState.setAmbient(new ColorChunk(this.myIn, chunkHeader).getBestColor());
                this.myMatState.setEnabled(true);
                if (DEBUG || DEBUG_LIGHT) {
                    logger.info("Ambient color:" + this.myMatState.getAmbient());
                }
                return true;
            }
            case 40992: {
                this.myMatState.setDiffuse(new ColorChunk(this.myIn, chunkHeader).getBestColor());
                this.myMatState.setEnabled(true);
                if (DEBUG || DEBUG_LIGHT) {
                    logger.info("Diffuse color:" + this.myMatState.getDiffuse());
                }
                return true;
            }
            case 41008: {
                this.myMatState.setSpecular(new ColorChunk(this.myIn, chunkHeader).getBestColor());
                this.myMatState.setEnabled(true);
                if (DEBUG || DEBUG_LIGHT) {
                    logger.info("Diffuse color:" + this.myMatState.getSpecular());
                }
                return true;
            }
            case 41024: {
                this.myMatState.setShininess(128.0f * new PercentChunk((DataInput)this.myIn, (ChunkHeader)chunkHeader).percent);
                this.myMatState.setEnabled(true);
                if (DEBUG || DEBUG_LIGHT) {
                    logger.info("Shinniness:" + this.myMatState.getShininess());
                }
                return true;
            }
            case 41025: {
                new PercentChunk(this.myIn, chunkHeader);
                return true;
            }
            case 41040: {
                float f;
                this.myMatState.getDiffuse().a = f = 1.0f - new PercentChunk((DataInput)this.myIn, (ChunkHeader)chunkHeader).percent;
                this.myMatState.getEmissive().a = f;
                this.myMatState.getAmbient().a = f;
                this.myMatState.setEnabled(true);
                if (DEBUG || DEBUG_LIGHT) {
                    logger.info("Alpha:" + f);
                }
                return true;
            }
            case 41042: {
                new PercentChunk(this.myIn, chunkHeader);
                return true;
            }
            case 41043: {
                new PercentChunk(this.myIn, chunkHeader);
                return true;
            }
            case 41216: {
                this.myIn.readShort();
                return true;
            }
            case 41092: {
                new PercentChunk(this.myIn, chunkHeader);
                return true;
            }
            case 41095: {
                this.myWireState.setLineWidth(this.myIn.readFloat());
                if (DEBUG || DEBUG_LIGHT) {
                    logger.info("Wireframe size:" + this.myWireState.getLineWidth());
                }
                return true;
            }
            case 41098: {
                return true;
            }
            case 41472: {
                this.readTextureMapOne(chunkHeader);
                return true;
            }
            case 41520: {
                this.readTextureBumpMap(chunkHeader);
                return true;
            }
            case 41100: {
                return true;
            }
            case 41760: {
                this.myIn.readFully(new byte[chunkHeader.length]);
                return true;
            }
            case 41552: {
                if (DEBUG) {
                    logger.info("Material blur present");
                }
                return true;
            }
            case 41102: {
                if (DEBUG) {
                    logger.info("Using absolute wire in units");
                }
                return true;
            }
            case 41504: {
                this.readReflectMap(chunkHeader);
                return true;
            }
            case 41764: {
                this.myIn.readFully(new byte[chunkHeader.length]);
                return true;
            }
            case 41089: {
                this.myMatState.setMaterialFace(2);
                return true;
            }
            case 41536: {
                if (DEBUG) {
                    logger.info("Using material falloff");
                }
                return true;
            }
            case 41093: {
                if (DEBUG) {
                    logger.info("Material wireframe is active");
                }
                this.myWireState.setEnabled(true);
                return true;
            }
            case 41786: {
                this.readTextureMapTwo(chunkHeader);
                return true;
            }
        }
        return false;
    }

    private void readTextureMapOne(ChunkHeader chunkHeader) throws IOException {
        TextureChunk textureChunk = new TextureChunk(this.myIn, chunkHeader);
        Texture texture = this.createTexture(textureChunk);
        this.myTexState.setTexture(texture, 0);
    }

    private void readTextureMapTwo(ChunkHeader chunkHeader) throws IOException {
        TextureChunk textureChunk = new TextureChunk(this.myIn, chunkHeader);
        Texture texture = this.createTexture(textureChunk);
        this.myTexState.setTexture(texture, 1);
    }

    private void readReflectMap(ChunkHeader chunkHeader) throws IOException {
        TextureChunk textureChunk = new TextureChunk(this.myIn, chunkHeader);
        Texture texture = this.createTexture(textureChunk);
        this.myTexState.setTexture(texture, 2);
    }

    private void readTextureBumpMap(ChunkHeader chunkHeader) throws IOException {
        TextureChunk textureChunk = new TextureChunk(this.myIn, chunkHeader);
        Texture texture = this.createTexture(textureChunk);
        this.myTexState.setTexture(texture, 3);
    }

    private Texture createTexture(TextureChunk textureChunk) {
        Texture texture = new Texture();
        URL uRL = ResourceLocatorTool.locateResource((String)"texture", (String)textureChunk.texName);
        if (uRL != null) {
            texture.setImageLocation(uRL.toString());
        }
        texture.setTextureKey(new TextureKey(uRL, true, TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2));
        texture.setAnisoLevel(0.0f);
        texture.setMipmapState(2);
        texture.setFilter(1);
        texture.setWrap(3);
        float f = textureChunk.vScale;
        float f2 = textureChunk.uScale;
        if (f2 == 0.0f) {
            f2 = 1.0f;
        }
        if (f == 0.0f) {
            f = 1.0f;
        }
        texture.setScale(new Vector3f(f2, f, 1.0f));
        this.myTexState.setEnabled(true);
        return texture;
    }

    private void readMatName() throws IOException {
        this.name = this.readcStr();
        if (DEBUG || DEBUG_LIGHT) {
            logger.info("read material name:" + this.name);
        }
    }
}

