/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.animation;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.util.BitSet;

public class PointInTime
implements Savable {
    public float time;
    public Vector3f[] jointTranslation;
    public Quaternion[] jointRotation;
    public BitSet usedTrans;
    public BitSet usedRot;

    public PointInTime() {
    }

    public PointInTime(int n) {
        this.jointTranslation = new Vector3f[n];
        this.usedRot = new BitSet(n);
        this.usedTrans = new BitSet(n);
        this.jointRotation = new Quaternion[n];
    }

    public PointInTime(int n, int n2) {
        this(n);
        this.time = n2;
    }

    void setRotation(int n, float f, float f2, float f3) {
        if (this.jointRotation[n] == null) {
            this.jointRotation[n] = new Quaternion();
        }
        this.jointRotation[n].fromAngles(new float[]{f, f2, f3});
        this.usedRot.set(n);
    }

    void setTranslation(int n, float f, float f2, float f3) {
        if (this.jointTranslation[n] == null) {
            this.jointTranslation[n] = new Vector3f();
        }
        this.jointTranslation[n].set(f, f2, f3);
        this.usedTrans.set(n);
    }

    void setTranslation(int n, Vector3f vector3f) {
        if (this.jointTranslation[n] == null) {
            this.jointTranslation[n] = new Vector3f();
        }
        this.jointTranslation[n].set(vector3f);
        this.usedTrans.set(n);
    }

    public void setRotation(int n, Quaternion quaternion) {
        if (this.jointRotation[n] == null) {
            this.jointRotation[n] = new Quaternion();
        }
        this.jointRotation[n].set(quaternion);
        this.usedRot.set(n);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write(this.time, "time", 0.0f);
        outputCapsule.write((Savable[])this.jointTranslation, "jointTranslation", (Savable[])new Vector3f[0]);
        outputCapsule.write((Savable[])this.jointRotation, "jointRotation", (Savable[])new Quaternion[0]);
        outputCapsule.write(this.usedTrans, "usedTrans", new BitSet(0));
        outputCapsule.write(this.usedRot, "usedRot", new BitSet(0));
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        int n;
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.time = inputCapsule.readFloat("time", 0.0f);
        Savable[] savableArray = inputCapsule.readSavableArray("jointTranslation", (Savable[])new Vector3f[0]);
        if (savableArray == null) {
            this.jointTranslation = null;
        } else {
            this.jointTranslation = new Vector3f[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.jointTranslation[n] = (Vector3f)savableArray[n];
            }
        }
        savableArray = inputCapsule.readSavableArray("jointRotation", (Savable[])new Quaternion[0]);
        if (savableArray == null) {
            this.jointRotation = null;
        } else {
            this.jointRotation = new Quaternion[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.jointRotation[n] = (Quaternion)savableArray[n];
            }
        }
        this.usedTrans = inputCapsule.readBitSet("usedTrans", new BitSet(0));
        this.usedRot = inputCapsule.readBitSet("usedRot", new BitSet(0));
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

