/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d.effects;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.util.geom.BufferUtils;
import com.jmex.font3d.Font3D;
import com.jmex.font3d.Glyph3D;
import com.jmex.font3d.Glyph3DBatch;
import com.jmex.font3d.effects.Font3DEffect;
import java.nio.FloatBuffer;

public class Font3DGradient
implements Font3DEffect {
    private Vector3f direction = new Vector3f();
    ColorRGBA start_color = new ColorRGBA();
    ColorRGBA end_color = new ColorRGBA();

    public Font3DGradient() {
        this(Vector3f.UNIT_Y.clone(), ColorRGBA.white.clone(), ColorRGBA.red.clone());
    }

    public Font3DGradient(Vector3f vector3f, ColorRGBA colorRGBA, ColorRGBA colorRGBA2) {
        this.direction.set(vector3f);
        this.start_color.set(colorRGBA);
        this.end_color.set(colorRGBA2);
    }

    public void applyEffect(Font3D font3D) {
        boolean bl = font3D.isMeshLocked();
        if (bl) {
            font3D.unlockMesh();
        }
        font3D.enableDiffuseMaterial();
        if (this.start_color.a != 1.0f || this.end_color.a != 1.0f) {
            font3D.enableAlphaState();
        }
        for (Glyph3D glyph3D : font3D.getGlyphs()) {
            if (glyph3D == null || glyph3D.getBatch() == null) continue;
            this.applyEffect(glyph3D.getBatch());
        }
        if (bl) {
            font3D.lockMesh();
        }
    }

    private void applyEffect(Glyph3DBatch glyph3DBatch) {
        Vector3f[] vector3fArray;
        Vector3f vector3f = null;
        Vector3f vector3f2 = null;
        for (Vector3f vector3f3 : vector3fArray = BufferUtils.getVector3Array((FloatBuffer)glyph3DBatch.getVertexBuffer())) {
            if (vector3f == null || this.direction.dot(vector3f3) > this.direction.dot(vector3f)) {
                vector3f = vector3f3;
            }
            if (vector3f2 != null && !(this.direction.dot(vector3f3) < this.direction.dot(vector3f2))) continue;
            vector3f2 = vector3f3;
        }
        float f = this.direction.dot(vector3f);
        float f2 = this.direction.dot(vector3f2);
        float f3 = f - f2;
        int n = 0;
        ColorRGBA[] colorRGBAArray = new ColorRGBA[vector3fArray.length];
        for (Vector3f vector3f4 : vector3fArray) {
            float f4 = this.direction.dot(vector3f4);
            ColorRGBA colorRGBA = colorRGBAArray[n] = new ColorRGBA(this.start_color);
            colorRGBA.interpolate(this.end_color, (f4 - f2) / f3);
            ++n;
        }
        glyph3DBatch.setColorBuffer(BufferUtils.createFloatBuffer((ColorRGBA[])colorRGBAArray));
    }
}

