/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.sonspf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import jp.sourceforge.akjrcp.subtitle.sonspf.SONList;
import jp.sourceforge.akjrcp.subtitle.sonspf.SONObject;

public class SONParser {
    public SONList parse(Reader reader) throws IOException {
        String line;
        SONList list = new SONList();
        BufferedReader breader = new BufferedReader(reader);
        while ((line = breader.readLine()) != null) {
            String[] datas;
            if (line.equals("Subtitle")) {
                list.setName(line);
            }
            if (line.length() <= 4 || !SONParser.isDigitOnly(line.substring(0, 4)) || (datas = line.split("\t")).length != 4) continue;
            int ind = Integer.parseInt(datas[0]);
            long s = SONParser.toMillisecond(datas[1]);
            long e = SONParser.toMillisecond(datas[2]);
            SONObject son = new SONObject(ind, s, e, datas[3]);
            list.add(son);
        }
        breader.close();
        return list;
    }

    public static boolean isDigitOnly(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static long toMillisecond(String text) {
        String[] values = text.split(":");
        if (values.length != 4) {
            return 0L;
        }
        int[] times = new int[4];
        int i = 0;
        while (i < times.length) {
            times[i] = Integer.parseInt(values[i]);
            ++i;
        }
        long ret = 0L;
        ret += (long)(times[0] * 60 * 60 * 1000);
        ret += (long)(times[1] * 60 * 1000);
        ret += (long)(times[2] * 1000);
        return ret += (long)(times[3] * 10);
    }
}

