/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.mozilla.universalchardet.UniversalDetector;

public class DetectUtils {
    public static final String ENCODING_MS932 = "MS932";
    public static final String defaultEncoding = "MS932";
    public static String lastEncoding;

    public static String getEncoding(File file) {
        try {
            return DetectUtils.getEncoding(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readFileToString(File file) throws IOException {
        String text;
        String encode = DetectUtils.getEncoding(file);
        if (encode == null) {
            encode = "MS932";
        }
        if ((text = FileUtils.readFileToString((File)file, (String)encode)).charAt(0) == '\ufeff') {
            text = text.substring(1);
        }
        return text;
    }

    public static String getEncoding(InputStream input) {
        try {
            int nread;
            byte[] buf = new byte[4096];
            UniversalDetector detector = new UniversalDetector(null);
            while ((nread = input.read(buf)) > 0 && !detector.isDone()) {
                detector.handleData(buf, 0, nread);
            }
            detector.dataEnd();
            return detector.getDetectedCharset();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

