/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.swt.ui.param;

import com.akjava.lib.commons.time.TimeUtils;
import com.akjava.lib.swt.ui.param.AbstractParamCompositeItem;
import com.akjava.lib.swt.ui.param.Messages;
import com.akjava.lib.swt.util.ClipboardUtil;
import jp.sourceforge.akjrcp.commons.ui.widget.WidgetBuilder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ParamTime
extends AbstractParamCompositeItem {
    private String key;
    private String label;
    private Label labelItem;
    private Label hourLabel;
    private Label minuteLabel;
    private Label secondLabel;
    private Label millisecondLabel;
    private String value = "";
    private Spinner hourSpinner;
    private Spinner minuteSpinner;
    private Spinner secondSpinner;
    private Spinner millisecondSpinner;

    @Override
    public String getKey() {
        return this.key;
    }

    public void setToolTipText(String text) {
        if (this.hourLabel != null) {
            this.hourLabel.setToolTipText(text);
        }
        if (this.minuteLabel != null) {
            this.minuteLabel.setToolTipText(text);
        }
        if (this.secondLabel != null) {
            this.secondLabel.setToolTipText(text);
        }
        if (this.millisecondLabel != null) {
            this.millisecondLabel.setToolTipText(text);
        }
        if (this.hourSpinner != null) {
            this.hourSpinner.setToolTipText(text);
        }
        if (this.minuteSpinner != null) {
            this.minuteSpinner.setToolTipText(text);
        }
        if (this.secondSpinner != null) {
            this.secondSpinner.setToolTipText(text);
        }
        if (this.millisecondSpinner != null) {
            this.millisecondSpinner.setToolTipText(text);
        }
    }

    public long getTime() {
        long value = 0L;
        if (this.hourSpinner != null) {
            value += (long)(this.hourSpinner.getSelection() * 60 * 60 * 1000);
        }
        if (this.minuteSpinner != null) {
            value += (long)(this.minuteSpinner.getSelection() * 60 * 1000);
        }
        if (this.secondSpinner != null) {
            value += (long)(this.secondSpinner.getSelection() * 1000);
        }
        if (this.millisecondSpinner != null) {
            value += (long)this.millisecondSpinner.getSelection();
        }
        return value;
    }

    @Override
    public String getValue() {
        return TimeUtils.toTimeText((long)this.getTime());
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.hourSpinner != null) {
            this.hourSpinner.addModifyListener(listener);
        }
        if (this.minuteSpinner != null) {
            this.minuteSpinner.addModifyListener(listener);
        }
        if (this.secondSpinner != null) {
            this.secondSpinner.addModifyListener(listener);
        }
        if (this.millisecondSpinner != null) {
            this.millisecondSpinner.addModifyListener(listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.hourSpinner != null) {
            this.hourSpinner.addSelectionListener(listener);
        }
        if (this.minuteSpinner != null) {
            this.minuteSpinner.addSelectionListener(listener);
        }
        if (this.secondSpinner != null) {
            this.secondSpinner.addSelectionListener(listener);
        }
        if (this.millisecondSpinner != null) {
            this.millisecondSpinner.addSelectionListener(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.hourSpinner != null) {
            this.hourSpinner.removeSelectionListener(listener);
        }
        if (this.minuteSpinner != null) {
            this.minuteSpinner.removeSelectionListener(listener);
        }
        if (this.secondSpinner != null) {
            this.secondSpinner.removeSelectionListener(listener);
        }
        if (this.millisecondSpinner != null) {
            this.millisecondSpinner.removeSelectionListener(listener);
        }
    }

    public void setMillisecond(long value) {
        this.setValue(TimeUtils.toTimeText((long)value));
    }

    public void setSecond(double value) {
        this.setValue(TimeUtils.toTimeText((long)((long)(value * 1000.0))));
    }

    @Override
    public void setValue(String value) {
        int[] vs;
        if (value.length() > 0 && (vs = TimeUtils.toHourMinSecMilliSecond((String)value)) != null) {
            if (this.hourSpinner != null) {
                this.hourSpinner.setSelection(vs[0]);
            }
            if (this.minuteSpinner != null) {
                this.minuteSpinner.setSelection(vs[1]);
            }
            if (this.secondSpinner != null) {
                this.secondSpinner.setSelection(vs[2]);
            }
            if (this.millisecondSpinner != null) {
                this.millisecondSpinner.setSelection(vs[3]);
            }
        }
        this.value = value;
    }

    public ParamTime(Composite parent, int style, String key, String label) {
        this(parent, style, key, label, true, true, true, true);
    }

    public ParamTime(Composite parent, int style, String key, String label, boolean showHour, boolean showMinute, boolean showSecond, boolean showMilliSecond) {
        super(parent, style);
        this.key = key;
        this.label = label;
        Menu menu = WidgetBuilder.createPopupMenu((Control)this, (Shell)this.getShell());
        MenuItem copy = WidgetBuilder.createPushMenu((Menu)menu, (String)Messages.getString("CopyTime"));
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = TimeUtils.toTimeText((long)ParamTime.this.getTime());
                ClipboardUtil.setClipboard(ParamTime.this.getDisplay(), text);
            }
        });
        MenuItem paste = WidgetBuilder.createPushMenu((Menu)menu, (String)Messages.getString("PasteTime"));
        paste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] times;
                String text = ClipboardUtil.getCurrentText(ParamTime.this.getDisplay());
                if (text != null && (times = TimeUtils.toHourMinSecMilliSecond((String)text)) != null) {
                    long ms = TimeUtils.toMillisecond((int[])times);
                    ParamTime.this.setValue(TimeUtils.toTimeText((long)ms));
                }
            }
        });
        this.setMenu(menu);
        this.setLayout((Layout)new GridLayout(2, false));
        this.labelItem = new Label((Composite)this, 0);
        this.labelItem.setText(label);
        this.labelItem.setMenu(menu);
        int count = 0;
        if (showHour) {
            count += 2;
        }
        if (showMinute) {
            count += 2;
        }
        if (showSecond) {
            count += 2;
        }
        if (showMilliSecond) {
            count += 2;
        }
        Composite spinnergroup = new Composite((Composite)this, 0);
        spinnergroup.setLayout((Layout)new GridLayout(count, false));
        if (showHour) {
            this.hourSpinner = new Spinner(spinnergroup, style & 8);
            this.hourSpinner.setMaximum(999);
            this.hourSpinner.addSelectionListener((SelectionListener)new AbstractParamCompositeItem.SelectionCheck());
            this.hourLabel = new Label(spinnergroup, 0);
            this.hourLabel.setText(":");
            this.hourLabel.setMenu(menu);
            new SpinnerLoopSupport(this.hourSpinner);
        }
        if (showMinute) {
            this.minuteSpinner = new Spinner(spinnergroup, style & 8);
            this.minuteSpinner.setMaximum(59);
            this.minuteSpinner.addSelectionListener((SelectionListener)new AbstractParamCompositeItem.SelectionCheck());
            this.minuteLabel = new Label(spinnergroup, 0);
            this.minuteLabel.setText(":");
            this.minuteLabel.setMenu(menu);
            new SpinnerLoopSupport(this.minuteSpinner);
        }
        if (showSecond) {
            this.secondSpinner = new Spinner(spinnergroup, style & 8);
            this.secondSpinner.setMaximum(59);
            this.secondSpinner.addSelectionListener((SelectionListener)new AbstractParamCompositeItem.SelectionCheck());
            this.secondLabel = new Label(spinnergroup, 0);
            this.secondLabel.setMenu(menu);
            if (showMilliSecond) {
                this.secondLabel.setText(".");
            } else {
                this.secondLabel.setText("");
            }
            new SpinnerLoopSupport(this.secondSpinner);
        }
        if (showMilliSecond) {
            this.millisecondSpinner = new Spinner(spinnergroup, style & 8);
            this.millisecondSpinner.setMaximum(999);
            this.millisecondLabel = new Label(spinnergroup, 0);
            this.millisecondLabel.setText("");
            this.millisecondLabel.setMenu(menu);
            this.millisecondSpinner.addSelectionListener((SelectionListener)new AbstractParamCompositeItem.SelectionCheck());
            new SpinnerLoopSupport(this.millisecondSpinner);
        }
    }

    @Override
    public boolean isModified() {
        String oldValue = this.getValue();
        return !oldValue.equals(this.value);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static class SpinnerLoopSupport
    implements MouseListener,
    SelectionListener,
    ModifyListener {
        private Spinner spinner;
        private long last;
        private int areaX = 7;

        public SpinnerLoopSupport(Spinner spinner) {
            this.spinner = spinner;
            spinner.addMouseListener((MouseListener)this);
            spinner.addSelectionListener((SelectionListener)this);
            spinner.addModifyListener((ModifyListener)this);
            if (spinner.getMaximum() > 9) {
                this.areaX = 13;
            }
            if (spinner.getMaximum() > 99) {
                this.areaX = 20;
            }
            if (spinner.getMaximum() > 999) {
                this.areaX = 27;
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (System.currentTimeMillis() - this.last < 750L) {
                return;
            }
            if (e.x > this.areaX) {
                if (e.y < 8) {
                    if (this.spinner.getSelection() == this.spinner.getMaximum()) {
                        this.spinner.setSelection(this.spinner.getMinimum());
                    }
                } else if (e.y > 8 && this.spinner.getSelection() == this.spinner.getMinimum()) {
                    this.spinner.setSelection(this.spinner.getMaximum());
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.last = System.currentTimeMillis();
        }

        public void modifyText(ModifyEvent e) {
            this.last = System.currentTimeMillis();
        }
    }
}

