/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.swt.images;

import com.akjava.lib.swt.images.SwingLikeDrawer;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SWTImageUtils {
    public static Image createThumbnail(Image img, int width, int height) {
        Image retImage = new Image(null, width, height);
        GC gc = new GC((Drawable)retImage);
        gc.setBackground(new Color(null, 255, 255, 255));
        gc.fillRectangle(0, 0, retImage.getBounds().width, retImage.getBounds().height);
        if (img.getBounds().width > retImage.getBounds().width || img.getBounds().height > retImage.getBounds().height) {
            int overw = img.getBounds().width - retImage.getBounds().width;
            int overh = img.getBounds().height - retImage.getBounds().height;
            double ratio = 0.0;
            ratio = overw > overh ? (double)retImage.getBounds().width / (double)img.getBounds().width : (double)retImage.getBounds().height / (double)img.getBounds().height;
            int dw = (int)((double)img.getBounds().width * ratio);
            int dh = (int)((double)img.getBounds().height * ratio);
            int cx = (retImage.getBounds().width - dw) / 2;
            int cy = (retImage.getBounds().height - dh) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, dw, dh);
        } else {
            int cx = (retImage.getBounds().width - img.getBounds().width) / 2;
            int cy = (retImage.getBounds().height - img.getBounds().height) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, img.getBounds().width, img.getBounds().height);
        }
        gc.dispose();
        return retImage;
    }

    public static Image loadImage(byte[] bytes) {
        ByteArrayInputStream binput = new ByteArrayInputStream(bytes);
        return new Image(null, (InputStream)binput);
    }

    public static Image loadImage(Class cl, String resource) {
        Image ret = new Image((Device)Display.getCurrent(), cl.getClassLoader().getResourceAsStream(resource));
        return ret;
    }

    public static ImageData awtToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    public static BufferedImage swtImageToAwtImage(Image image) {
        return SWTImageUtils.swtImageToAwtImage(image, 0, 0, image.getBounds().width, image.getBounds().height);
    }

    public static BufferedImage swtImageToAwtImage(Image image, int dx, int dy, int width, int height) {
        int[] defaultColor = new int[]{255, 255, 255, 255};
        ImageData data = image.getImageData();
        BufferedImage bimage = new BufferedImage(width, height, 2);
        WritableRaster raster = bimage.getRaster();
        int i = dx;
        while (i < dx + width && dx < image.getBounds().width) {
            int j = dy;
            while (j < dy + height) {
                int x = i - dx;
                int y = j - dy;
                int[] int_rgb = null;
                if (i >= 0 && j >= 0 && i < image.getBounds().width && j < image.getBounds().height) {
                    int color = data.getPixel(i, j);
                    int_rgb = data.depth == 32 ? new int[]{0xFF & color >> 8, 0xFF & color >> 16, 0xFF & color >> 24, 255} : new int[]{0xFF & color, 0xFF & color >> 8, 0xFF & color >> 16, 255};
                } else {
                    int_rgb = defaultColor;
                }
                raster.setPixel(x, y, int_rgb);
                ++j;
            }
            ++i;
        }
        return bimage;
    }

    public static Image fitImage(Image baseImage, int width, int height) {
        Image image = new Image(null, width, height);
        int dw = width;
        int dh = height;
        if (dw != 0 && dh != 0) {
            double waspect = (double)dw / (double)baseImage.getBounds().width;
            double haspect = (double)dh / (double)baseImage.getBounds().height;
            if (waspect > haspect) {
                dw = (int)((double)baseImage.getBounds().width * haspect);
            } else {
                dh = (int)((double)baseImage.getBounds().height * waspect);
            }
        }
        GC g2 = new GC((Drawable)image);
        int dx = (width - dw) / 2;
        int dy = (height - dh) / 2;
        SwingLikeDrawer swingLike = new SwingLikeDrawer(g2);
        swingLike.drawImage(baseImage, dx, dy, dw + dx, dh + dy, 0, 0, baseImage.getBounds().width, baseImage.getBounds().height, null);
        g2.dispose();
        return image;
    }

    public static Image fitWidthImage(Image baseImage, int width) {
        double waspect = (double)width / (double)baseImage.getBounds().width;
        int height = (int)((double)baseImage.getBounds().height * waspect);
        Image image = new Image(null, width, height);
        GC g2 = new GC((Drawable)image);
        g2.drawImage(baseImage, 0, 0, baseImage.getBounds().width, baseImage.getBounds().height, 0, 0, width, height);
        g2.dispose();
        return image;
    }

    public static Image loadMaxWidthImage(String path, int maxWidth) {
        Image tmp = new Image(null, path);
        if (tmp.getBounds().width > maxWidth) {
            Image tmpImage = SWTImageUtils.fitWidthImage(tmp, maxWidth);
            tmp.dispose();
            return tmpImage;
        }
        return tmp;
    }

    public static Image clipImage(Image baseImage, int x, int y, int width, int height) {
        Image image = new Image(null, width, height);
        GC gc = new GC((Drawable)image);
        gc.drawImage(baseImage, -x, -y);
        gc.dispose();
        return image;
    }

    public static void writePngImage(String path, Image baseImage) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{baseImage.getImageData()};
        loader.save(path, 5);
    }
}

