/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.standards.ffmpeg.executer.classic;

import com.akjava.lib.standards.ffmpeg.executer.FFMpegInput;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMpegPreference {
    public static Log log = LogFactory.getLog(FFMpegPreference.class);
    private List<String> mapList = new ArrayList<String>();
    private String ffmpegPath;
    private String audioCodec;
    private int audioBitrate;
    private int audioRate;
    private int audioChannel;
    private String videoCodec;
    private double videoRate;
    private int videoBitrate;
    private int videoMinBitrate;
    private int videoMaxBitrate;
    private String videoSize;
    private String videoAspect;
    private String target;
    private String format;
    private boolean enableVideo = true;
    private boolean enableAudio = true;
    private boolean samequality;
    private int level;
    private int coder;
    private String vtag;
    private String extension;
    private boolean forceOverwrite = true;
    private boolean twoPassEncode = false;
    private int guessSize = 1024;
    private boolean highQuality;
    private int qmin;
    private int qmax;
    private String[] flags;
    private int mbd;
    private int maxRate;
    private int bufSize;
    private int bt;
    private boolean loop;
    private boolean shortest;
    private int threads;
    private boolean deinterlace;
    public static final int GENERATION2 = 2;
    public static final int GENERATION1 = 1;

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public boolean isShortest() {
        return this.shortest;
    }

    public void setShortest(boolean shortest) {
        this.shortest = shortest;
    }

    public int getMbd() {
        return this.mbd;
    }

    public void setMbd(int mbd) {
        this.mbd = mbd;
    }

    public String[] getFlags() {
        return this.flags;
    }

    public void setFlags(String[] flags) {
        this.flags = flags;
    }

    public int getGuessSize() {
        return this.guessSize;
    }

    public void setGuessSize(int guessSize) {
        this.guessSize = guessSize;
    }

    public boolean isTwoPassEncode() {
        return this.twoPassEncode;
    }

    public void setTwoPassEncode(boolean twoPassEncode) {
        this.twoPassEncode = twoPassEncode;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public static boolean isTwopassNeedAudio(String format) {
        if (format == null) {
            return false;
        }
        String[] needs = new String[]{"psp"};
        int i = 0;
        while (i < needs.length) {
            if (format.equals(needs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] toCommandPass1(FFMpegInput[] inputs, String passlog, String output) {
        String[] tmp = this.toCommand(inputs, output);
        ArrayList<String> commandList = new ArrayList<String>();
        int i = 0;
        while (i < tmp.length - 1) {
            commandList.add(tmp[i]);
            ++i;
        }
        if (!FFMpegPreference.isTwopassNeedAudio(this.format)) {
            commandList.add("-an");
        }
        commandList.add("-pass");
        commandList.add("1");
        commandList.add("-passlogfile");
        commandList.add(passlog);
        commandList.add(output);
        return commandList.toArray(new String[0]);
    }

    public String[] toCommandPass2(FFMpegInput[] inputs, String passlog, String output) {
        String[] tmp = this.toCommand(inputs, output);
        ArrayList<String> commandList = new ArrayList<String>();
        int i = 0;
        while (i < tmp.length - 1) {
            commandList.add(tmp[i]);
            ++i;
        }
        commandList.add("-pass");
        commandList.add("2");
        commandList.add("-passlogfile");
        commandList.add(passlog);
        commandList.add(output);
        return commandList.toArray(new String[0]);
    }

    public String[] toCommand(String input, String avsPath, String output) {
        if (input == null || output == null) {
            return null;
        }
        String[] inputs = avsPath == null ? new String[]{input} : new String[]{avsPath};
        return this.toCommand(inputs, output);
    }

    public String[] toCommand(String[] input, String output) {
        FFMpegInput[] ffmpegInputs = new FFMpegInput[input.length];
        int i = 0;
        while (i < ffmpegInputs.length) {
            ffmpegInputs[i] = new FFMpegInput(input[i]);
            ++i;
        }
        return this.toCommand(ffmpegInputs, output);
    }

    public static String toSuiteVideoCodec(String vcodec, int g) {
        String codec = vcodec;
        if (g == 2) {
            if (vcodec.equals("xvid")) {
                codec = "libxvid";
            } else if (vcodec.equals("h264")) {
                codec = "libx264";
            }
        }
        return codec;
    }

    public static String toSuiteAudioCodec(String acodec, int g) {
        String codec = acodec;
        if (g == 2) {
            if (acodec.equals("aac")) {
                codec = "libfaac";
            } else if (acodec.equals("mp3")) {
                codec = "libmp3lame";
            }
        }
        log.trace((Object)(String.valueOf(acodec) + " g=" + g + " new=" + codec));
        return codec;
    }

    public String[] toCommand(FFMpegInput[] inputs, String output) {
        ArrayList<String> params = new ArrayList<String>();
        if (this.ffmpegPath == null) {
            params.add("ffmpeg");
        } else {
            params.add(this.ffmpegPath);
        }
        this.addFirstOptions(params);
        if (this.forceOverwrite) {
            params.add("y");
        }
        int i = 0;
        while (i < inputs.length) {
            if (inputs[i].isLoop()) {
                params.add("loop_input");
            }
            if (inputs[i].getFormat() != null) {
                params.add("f");
                params.add(inputs[i].getFormat());
            }
            params.add("i");
            params.add(inputs[i].getPath());
            if (inputs[i].getMap() != null) {
                params.add("map");
                params.add(inputs[i].getMap());
            }
            ++i;
        }
        if (this.target != null) {
            params.add("target");
            params.add("ntsc-dvd");
        }
        if (this.format != null) {
            params.add("f");
            params.add(this.format);
        }
        if (this.enableAudio) {
            if (this.valid(this.audioCodec)) {
                params.add("acodec");
                params.add(this.audioCodec);
            }
            if (this.audioRate != 0) {
                params.add("ar");
                params.add("" + this.audioRate);
            }
            if (this.audioBitrate != 0) {
                params.add("ab");
                params.add(this.audioBitrate + "k");
            }
            if (this.audioChannel != 0) {
                params.add("ac");
                params.add("" + this.audioChannel);
            }
        } else {
            params.add("an");
        }
        if (this.enableVideo) {
            if (this.valid(this.videoCodec)) {
                params.add("vcodec");
                params.add(this.videoCodec);
            }
            if (this.videoRate != 0.0) {
                params.add("r");
                params.add("" + this.videoRate);
            }
            if (this.videoBitrate != 0) {
                params.add("b");
                params.add(this.videoBitrate + "k");
            }
            if (this.videoMaxBitrate != 0) {
                params.add("maxrate");
                params.add(this.videoMaxBitrate + "k");
                params.add("bufsize");
                params.add(this.videoMaxBitrate + 2 + "k");
            }
            if (this.videoMinBitrate != 0) {
                params.add("minrate");
                params.add(this.videoMinBitrate + "k");
            }
            if (this.valid(this.videoSize)) {
                params.add("s");
                params.add(this.videoSize);
            }
            if (this.valid(this.videoAspect)) {
                params.add("aspect");
                params.add(this.videoAspect);
            }
            if (this.samequality) {
                params.add("sameq");
            }
        } else {
            params.add("vn");
        }
        if (this.qmin > 0) {
            params.add("qmin");
            params.add("" + this.qmin);
        }
        if (this.qmax > 0) {
            params.add("qmax");
            params.add("" + this.qmax);
        }
        if (this.mbd > 0) {
            params.add("mbd");
            params.add("" + this.mbd);
        }
        if (this.flags != null && this.flags.length > 0) {
            params.add("flags");
            params.add(this.toOptionGroup(this.flags));
        }
        if (this.bt > 0) {
            params.add("bt");
            params.add(this.bt + "k");
        }
        if (this.maxRate > 0) {
            params.add("maxrate");
            params.add(this.maxRate + "k");
        }
        if (this.bufSize > 0) {
            params.add("bufsize");
            params.add(this.bufSize + "k");
        }
        if (this.level > 0) {
            params.add("level");
            params.add("" + this.level);
        }
        if (this.coder > 0) {
            params.add("coder");
            params.add("" + this.coder);
        }
        if (this.vtag != null) {
            params.add("vtag");
            params.add(this.vtag);
        }
        if (this.deinterlace) {
            params.add("deinterlace");
        }
        if (this.loop) {
            params.add("loop");
        }
        if (this.shortest) {
            params.add("shortest");
        }
        if (this.threads > 0) {
            params.add("threads");
            params.add("" + this.threads);
        }
        if (this.mapList.size() > 0) {
            i = 0;
            while (i < this.mapList.size()) {
                params.add("map");
                params.add(this.mapList.get(i));
                ++i;
            }
        }
        this.addLastOptions(inputs, params);
        params.add(output);
        return params.toArray(new String[0]);
    }

    public void addLastOptions(FFMpegInput[] inputs, List params) {
    }

    public void addFirstOptions(List params) {
    }

    private String toOptionGroup(String[] arg) {
        String ret = "";
        int i = 0;
        while (i < arg.length) {
            if (i != 0) {
                ret = String.valueOf(ret) + "+";
            }
            ret = String.valueOf(ret) + arg[i];
            ++i;
        }
        return ret;
    }

    private boolean valid(String param) {
        return param != null && param.length() > 0;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public int getAudioChannel() {
        return this.audioChannel;
    }

    public void setAudioChannel(int audioChannel) {
        this.audioChannel = audioChannel;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
    }

    public int getAudioRate() {
        return this.audioRate;
    }

    public void setAudioRate(int audioRate) {
        this.audioRate = audioRate;
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public String getVideoAspect() {
        return this.videoAspect;
    }

    public void setVideoAspect(String videoAspect) {
        this.videoAspect = videoAspect;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(String videoCodec) {
        this.videoCodec = videoCodec;
    }

    public double getVideoRate() {
        return this.videoRate;
    }

    public void setVideoRate(double videoRate) {
        this.videoRate = videoRate;
    }

    public String getVideoSize() {
        return this.videoSize;
    }

    public void setVideoSize(String videoSize) {
        this.videoSize = videoSize;
    }

    public int getVideoMaxBitrate() {
        return this.videoMaxBitrate;
    }

    public void setVideoMaxBitrate(int videoMaxBitrate) {
        this.videoMaxBitrate = videoMaxBitrate;
    }

    public int getVideoMinBitrate() {
        return this.videoMinBitrate;
    }

    public void setVideoMinBitrate(int videoMinBitrate) {
        this.videoMinBitrate = videoMinBitrate;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isEnableAudio() {
        return this.enableAudio;
    }

    public void setEnableAudio(boolean enableAudio) {
        this.enableAudio = enableAudio;
    }

    public boolean isEnableVideo() {
        return this.enableVideo;
    }

    public void setEnableVideo(boolean enableVideo) {
        this.enableVideo = enableVideo;
    }

    public static int toKBytes(String duration, int bps) {
        if (bps == 0) {
            return 0;
        }
        int result = 0;
        if (duration != null) {
            Pattern durationPattern = Pattern.compile("(\\d+):(\\d+):(\\d+)\\.(\\d)+$");
            long millisecond = 0L;
            Matcher match = durationPattern.matcher(duration);
            if (match.matches()) {
                int hour = Integer.parseInt(match.group(1));
                int minute = Integer.parseInt(match.group(2));
                int second = Integer.parseInt(match.group(3));
                int millis = Integer.parseInt(match.group(4));
                millisecond = hour * 60 * 60 * 1000;
                millisecond += (long)(minute * 60 * 1000);
                millisecond += (long)(second * 1000);
                millisecond += (long)millis;
            } else {
                log.warn((Object)("invalid duration:" + duration));
            }
            if (millisecond <= 0L) {
                log.warn((Object)("zero duration:" + duration + " maybe file is broken"));
            } else {
                result = (int)(millisecond * (long)bps / 8L / 1024L);
                log.info((Object)(String.valueOf(duration) + "," + millisecond / 1000L + "," + bps + "k" + " result=" + result));
            }
        } else {
            log.warn((Object)"duration==null");
        }
        return result;
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isSamequality() {
        return this.samequality;
    }

    public void setSamequality(boolean samequality) {
        this.samequality = samequality;
    }

    public int getQmax() {
        return this.qmax;
    }

    public void setQmax(int qmax) {
        this.qmax = qmax;
    }

    public int getQmin() {
        return this.qmin;
    }

    public void setQmin(int qmin) {
        this.qmin = qmin;
    }

    public int getBt() {
        return this.bt;
    }

    public void setBt(int bt) {
        this.bt = bt;
    }

    public int getBufSize() {
        return this.bufSize;
    }

    public void setBufSize(int bufSize) {
        this.bufSize = bufSize;
    }

    public int getMaxRate() {
        return this.maxRate;
    }

    public void setMaxRate(int maxRate) {
        this.maxRate = maxRate;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getCoder() {
        return this.coder;
    }

    public void setCoder(int coder) {
        this.coder = coder;
    }

    public String getVtag() {
        return this.vtag;
    }

    public void setVtag(String vtag) {
        this.vtag = vtag;
    }

    public void setVideoSize(int videoWidth, int videoHeight) {
        this.setVideoSize(String.valueOf(videoWidth) + "x" + videoHeight);
    }

    public static String[] parseCommand(String line) {
        ArrayList<String> list = new ArrayList<String>();
        String[] values = line.split(" ");
        int i = 0;
        while (i < values.length) {
            if (values[i].startsWith("\"") && values[i].endsWith("\"")) {
                String text = values[i].substring(1, values[i].length() - 1);
                if (!text.equals("")) {
                    list.add(text);
                }
            } else if (!values[i].equals("")) {
                list.add(values[i]);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean isDeinterlace() {
        return this.deinterlace;
    }

    public void setDeinterlace(boolean deinterlace) {
        this.deinterlace = deinterlace;
    }

    public void addMap(String map) {
        this.mapList.add(map);
    }
}

