/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.rcp.undo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;

public class RcpUndoUtils {
    public static void updateUndoRedoControls(IWorkbenchPartSite site, Control[] undos, Control[] redos) {
        IWorkbench workbench = site.getWorkbenchWindow().getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        int i = 0;
        while (i < undos.length) {
            undos[i].setEnabled(operationHistory.canUndo(undoContext));
            ++i;
        }
        i = 0;
        while (i < redos.length) {
            redos[i].setEnabled(operationHistory.canRedo(undoContext));
            ++i;
        }
    }

    public static void execOperation(IWorkbenchPartSite site, IUndoableOperation operation) {
        IWorkbench workbench = site.getWorkbenchWindow().getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        operation.addContext(undoContext);
        try {
            operationHistory.execute(operation, null, null);
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
    }

    public static void doUndo(IWorkbenchPartSite site) {
        IUndoContext undoContext;
        IWorkbench workbench = site.getWorkbenchWindow().getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        boolean can = operationHistory.canUndo(undoContext = workbench.getOperationSupport().getUndoContext());
        if (can) {
            try {
                operationHistory.undo(undoContext, null, null);
            }
            catch (ExecutionException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void doRedo(IWorkbenchPartSite site) {
        IUndoContext undoContext;
        IWorkbench workbench = site.getWorkbenchWindow().getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        boolean can = operationHistory.canRedo(undoContext = workbench.getOperationSupport().getUndoContext());
        if (can) {
            try {
                operationHistory.redo(undoContext, null, null);
            }
            catch (ExecutionException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void initializeUndoContext(IWorkbenchPartSite site, int limit) {
        IWorkbench workbench = site.getWorkbenchWindow().getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        operationHistory.setLimit(undoContext, limit);
    }
}

