/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.rcp.ui;

import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CanvasUtils {
    public static void asyncRedraw(Display display, Canvas canvas) {
        display.asyncExec((Runnable)new Redraw(canvas));
    }

    public static abstract class ActionRedrawLoop
    extends Thread {
        private Shell shell;
        private Canvas canvas;
        private boolean doLoop = true;
        private long frameTime = 33L;
        private long minSleepTime = 10L;
        private long lastDraw;

        public abstract void actionInLoop();

        public ActionRedrawLoop(Shell shell, Canvas canvas) {
            this.shell = shell;
            this.canvas = canvas;
        }

        @Override
        public void run() {
            while (this.doLoop) {
                this.lastDraw = System.currentTimeMillis();
                this.actionInLoop();
                if (this.shell != null && !this.shell.isDisposed() && !this.shell.getDisplay().isDisposed()) {
                    CanvasUtils.asyncRedraw(this.shell.getDisplay(), this.canvas);
                }
                long diff = this.frameTime - (System.currentTimeMillis() - this.lastDraw);
                try {
                    Thread.sleep(Math.max(diff, this.minSleepTime));
                }
                catch (InterruptedException e) {
                    this.doLoop = false;
                    e.printStackTrace();
                }
            }
        }

        public boolean isDoLoop() {
            return this.doLoop;
        }

        public void setDoLoop(boolean doLoop) {
            this.doLoop = doLoop;
        }
    }

    public static class Redraw
    implements Runnable {
        Canvas canvas;

        public Redraw(Canvas canvas) {
            this.canvas = canvas;
        }

        @Override
        public void run() {
            if (!this.canvas.isDisposed()) {
                this.canvas.redraw();
            }
        }
    }
}

