/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.commons.preset;

import com.akjava.lib.commons.preset.IPreSetIO;
import com.akjava.lib.commons.preset.PreSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultPreSetIO
implements IPreSetIO {
    protected String[] singleParams = new String[0];
    protected String[] customParams = new String[0];
    protected static String separator = ",";

    protected boolean isSingleParam(String key) {
        if (this.singleParams == null) {
            return false;
        }
        int i = 0;
        while (i < this.singleParams.length) {
            if (key.equals(this.singleParams[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String getCSVHeaderParamRemovedLine(String csv) {
        String[] values = csv.split(separator);
        String ret = "";
        int i = 0;
        while (i < values.length) {
            if (!PreSet.isCSVHeaderKey(values[i])) {
                ret = String.valueOf(ret) + values[i];
                if (i != values.length - 1) {
                    ret = String.valueOf(ret) + separator;
                }
            }
            ++i;
        }
        return ret;
    }

    protected boolean isCustomParam(String key) {
        if (this.customParams == null) {
            return false;
        }
        int i = 0;
        while (i < this.customParams.length) {
            if (key.equals(this.customParams[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String[] preSetToArgArray(PreSet param) {
        Map<String, String> parameters = param.getParameters();
        ArrayList<String> list = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            if (PreSet.isCSVHeaderKey(key) || this.isCustomParam(key)) continue;
            String value = parameters.get(key);
            if (this.isSingleParam(key)) {
                if (!value.equals("1") && !value.equals("true")) continue;
                list.add("-" + key);
                continue;
            }
            if (value.equals("")) continue;
            DefaultPreSetIO.addArgList(list, key, value);
        }
        return list.toArray(new String[list.size()]);
    }

    protected static void addArgList(List<String> list, String key, String value) {
        list.add("-" + key);
        list.add(value);
    }

    @Override
    public PreSet csvToPreSet(String csv) {
        csv = csv.replace("\n", "");
        csv = csv.replace("\r", "");
        PreSet parameters = new PreSet();
        String[] name_value = csv.split(separator);
        int i = 0;
        while (i < name_value.length) {
            if (name_value[0].length() > 0) {
                String[] n_v = name_value[i].split("=");
                if (n_v.length > 1) {
                    parameters.setValue(n_v[0], n_v[1]);
                } else if (PreSet.isCSVHeaderKey(n_v[0])) {
                    parameters.setValue(n_v[0], "");
                } else {
                    parameters.setValue(n_v[0], "");
                }
            }
            ++i;
        }
        return parameters;
    }

    @Override
    public String preSetToCsv(PreSet parameters) {
        return this.preSetToCsv(parameters, false);
    }

    @Override
    public String preSetToCsv(PreSet parameters, boolean removeHeader) {
        StringBuffer buffer = new StringBuffer();
        if (!removeHeader) {
            buffer.append(DefaultPreSetIO.toHeaderCSV(parameters));
            buffer.append(separator);
        }
        Map<String, String> map = parameters.getParameters();
        for (String key : map.keySet()) {
            if (PreSet.isCSVHeaderKey(key) || !this.isAddCSV(key)) continue;
            String value = map.get(key);
            if (value == null) {
                value = "";
            }
            if (!value.equals("")) {
                buffer.append(String.valueOf(key) + "=" + value);
            } else {
                buffer.append(key);
            }
            buffer.append(separator);
        }
        String v = buffer.toString();
        return v.substring(0, v.length() - 1);
    }

    public boolean isAddCSV(String key) {
        return true;
    }

    public boolean isAddArg(String key) {
        return !this.isCustomParam(key);
    }

    static String toHeaderCSV(PreSet parameters) {
        String v = "";
        v = String.valueOf(v) + PreSet.PARAM_NAME + "=" + DefaultPreSetIO.storeCharacters(parameters.getName()) + separator;
        v = String.valueOf(v) + PreSet.PARAM_COMMENT + "=" + DefaultPreSetIO.storeCharacters(parameters.getComment());
        return v;
    }

    protected static String restoreCharacters(String value) {
        String v = value.replace("\\n", "\n");
        v = v.replace("%2C", separator);
        return v;
    }

    protected static String storeCharacters(String value) {
        String v = value.replace("\n", "\\n");
        v = v.replace("\r", "");
        v = v.replace(separator, "%2C");
        return v;
    }

    public String[] getSingleParams() {
        return this.singleParams;
    }

    public void setSingleParams(String[] singleParams) {
        this.singleParams = singleParams;
    }

    public String[] getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(String[] customParams) {
        this.customParams = customParams;
    }
}

