/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.commons.color;

public class ColorUtils {
    public static int[] toARGB(int argb, int[] container) {
        container[0] = 0xFF & argb >> 24;
        container[1] = 0xFF & argb >> 16;
        container[2] = 0xFF & argb >> 8;
        container[3] = 0xFF & argb >> 0;
        return container;
    }

    public static float[] toARGBf(int a, int r, int g, int b, float[] container) {
        container[0] = (float)a / 255.0f;
        container[1] = (float)r / 255.0f;
        container[2] = (float)g / 255.0f;
        container[3] = (float)b / 255.0f;
        return container;
    }

    public static float[] toARGBf(int argb) {
        return ColorUtils.toARGBf(argb, new float[4]);
    }

    public static float[] toARGBf(int argb, float[] container) {
        container[0] = (float)(0xFF & argb >> 24) / 255.0f;
        container[1] = (float)(0xFF & argb >> 16) / 255.0f;
        container[2] = (float)(0xFF & argb >> 8) / 255.0f;
        container[3] = (float)(0xFF & argb >> 0) / 255.0f;
        return container;
    }

    public static int[] toARGB(int argb) {
        return ColorUtils.toARGB(argb, new int[4]);
    }

    public static int parseColor(String hex) {
        String h = hex;
        if (h.startsWith("#")) {
            h = hex.substring(1);
        }
        return Integer.parseInt(h, 16);
    }

    public static int toARGB(int rgb, int a) {
        return a >> 24 | rgb;
    }

    public static boolean isColorText(String text) {
        if (text == null) {
            return false;
        }
        if (text.startsWith("#")) {
            text = text.substring(1);
        }
        if (text.length() != 6) {
            return false;
        }
        char[] cchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'd', 'f'};
        String test = text.toLowerCase();
        int i = 0;
        while (i < text.length()) {
            boolean much = false;
            int j = 0;
            while (j < cchar.length) {
                if (test.charAt(i) == cchar[j]) {
                    much = true;
                }
                ++j;
            }
            if (!much) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

