/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.wizards.importimg;

import java.io.File;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.widget.LayoutDataBuilder;
import jp.sourceforge.akjrcp.commons.ui.widget.WidgetBuilder;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import jp.sourceforge.akjrcp.text_douga.rcp.Messages;
import jp.sourceforge.akjrcp.text_douga.rcp.TextDougaUtils;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImageInputPage
extends WizardPage {
    private CCombo size;
    private CCombo fps;
    private FileDirChoicer inputVideo;
    private CCombo duration;
    private CCombo wait;
    private CCombo fadein;
    private CCombo fadeout;
    private CCombo align;
    private CCombo valign;
    private CCombo loop;
    private Text timeLabelText;
    private Text imagesLabelText;
    private int imageIndex;

    protected ImageInputPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("importimg.input_title"));
        this.setDescription(Messages.getString("importimg.input_description"));
        this.setPageComplete(false);
    }

    public String getSize() {
        return this.size.getText();
    }

    public String getFps() {
        return this.fps.getText();
    }

    public String getPath() {
        return this.inputVideo.getAbsoluteFilePath();
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        this.setControl((Control)base);
        this.inputVideo = new FileDirChoicer(base, 0, 1, Messages.getString("importimg.input"));
        this.inputVideo.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputVideo.setFilterExtensions(ParserUtils.toMixFilterExtensions(ParserUtils.videos));
        this.inputVideo.addFileListChangeListener(new AbstractFileDirChoicer.FileStatusChangeListener(){

            public void addList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                ImageInputPage.this.setPageComplete(false);
                File dir = new File(event.getFilePath());
                String[] list = dir.list();
                ImageInputPage.this.imageIndex = 0;
                int i = 0;
                while (i < list.length) {
                    if (ParserUtils.isImageFile(list[i])) {
                        ImageInputPage imageInputPage = ImageInputPage.this;
                        imageInputPage.imageIndex = imageInputPage.imageIndex + 1;
                    }
                    ++i;
                }
                ImageInputPage.this.imagesLabelText.setText("" + ImageInputPage.this.imageIndex);
                ImageInputPage.this.calucurateTime();
                ImageInputPage.this.setPageComplete(true);
            }

            public void removeList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                ImageInputPage.this.size.setText("");
                ImageInputPage.this.fps.setText("");
            }
        });
        Composite buttons = WidgetBuilder.createGridLayoutComposite((Composite)base, (int)0, (int)4, (boolean)true);
        Button speedSlide = new Button(buttons, 0);
        speedSlide.setText(Messages.getString("importimg.speedSlide"));
        speedSlide.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImageInputPage.this.setSpeedValue();
                ImageInputPage.this.calucurateTime();
            }
        });
        Button simpleSlide = new Button(buttons, 0);
        simpleSlide.setText(Messages.getString("importimg.simpleSlide"));
        simpleSlide.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImageInputPage.this.setSimpleValue();
                ImageInputPage.this.calucurateTime();
            }
        });
        Button flashSlide = new Button(buttons, 0);
        flashSlide.setText(Messages.getString("importimg.flashSlide"));
        flashSlide.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImageInputPage.this.setFlashValue();
                ImageInputPage.this.calucurateTime();
            }
        });
        Button videoSlide = new Button(buttons, 0);
        videoSlide.setText(Messages.getString("importimg.videoSlide"));
        videoSlide.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImageInputPage.this.setVideoValue();
                ImageInputPage.this.calucurateTime();
            }
        });
        Composite labels = WidgetBuilder.createGridLayoutComposite((Composite)base, (int)0, (int)4, (boolean)true);
        Label label = new Label(labels, 0);
        label.setText(Messages.getString("importimg.timelabel"));
        this.timeLabelText = new Text(labels, 8);
        this.timeLabelText.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        Label label2 = new Label(labels, 0);
        label2.setText(Messages.getString("importimg.imagelabel"));
        this.imagesLabelText = new Text(labels, 8);
        this.imagesLabelText.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        Composite fields = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        SelectionListener doCaricurate = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImageInputPage.this.calucurateTime();
            }
        };
        this.duration = this.createCCombo(fields, Messages.getString("importimg.duration"), new String[]{"", "0.1", "0.3", "1", "2", "3", "5", "10", "30", "0.0334"}, 0);
        this.duration.addSelectionListener(doCaricurate);
        this.wait = this.createCCombo(fields, Messages.getString("importimg.wait"), new String[]{"", "0.1", "0.3", "1", "3", "5", "10"}, 0);
        this.wait.addSelectionListener(doCaricurate);
        this.fadein = this.createCCombo(fields, Messages.getString("importimg.fadein"), new String[]{"", "0.1", "0.3", "1", "3", "5", "10"}, 0);
        this.fadeout = this.createCCombo(fields, Messages.getString("importimg.fadeout"), new String[]{"", "0.1", "0.3", "1", "3", "5", "10"}, 0);
        this.size = this.createCCombo(fields, Messages.getString("exportimg.size"), new String[]{"", "160x120", "320x240", "640x480", "720x480"}, 0);
        int[] w_h = TextDougaUtils.getDefaultSize();
        this.size.setText(w_h[0] + "x" + w_h[1]);
        this.fps = this.createCCombo(fields, Messages.getString("exportimg.fps"), new String[]{"", "1", "5", "10", "12", "14.895", "15", "24", "25", "29.97", "30"}, 0);
        this.fps.setText("5");
        this.align = this.createCCombo(fields, Messages.getString("importimg.align"), new String[]{"", "left", "center", "right"}, 8);
        this.valign = this.createCCombo(fields, Messages.getString("importimg.valign"), new String[]{"", "top", "middle", "bottom"}, 8);
        this.loop = this.createCCombo(fields, Messages.getString("importimg.loop"), new String[]{"", "1", "3", "5", "10", "99"}, 0);
        this.loop.addSelectionListener(doCaricurate);
        this.setSpeedValue();
    }

    public double toDouble(String num, double defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        double ret = defaultValue;
        try {
            ret = Double.parseDouble(num);
        }
        catch (Exception exception) {}
        System.out.println(ret);
        return ret;
    }

    protected void calucurateTime() {
        double max = 0.0;
        if (this.imageIndex > 0) {
            max = (double)this.imageIndex * this.toDouble(this.duration.getText(), 1.0) + (double)(this.imageIndex - 1) * this.toDouble(this.wait.getText(), 0.1);
            max *= this.toDouble(this.loop.getText(), 1.0);
        }
        this.timeLabelText.setText((int)max + " " + Messages.getString("importimg.sec"));
    }

    private void setSimpleValue() {
        this.fadein.setText("0");
        this.fadeout.setText("0");
        this.wait.setText("0");
        this.duration.setText("2");
        this.fps.setText("5");
    }

    private void setSpeedValue() {
        this.fadein.setText("0");
        this.fadeout.setText("0");
        this.wait.setText("0");
        this.duration.setText("0.1");
        this.fps.setText("5");
    }

    private void setFlashValue() {
        this.fadein.setText("0.2");
        this.fadeout.setText("0.2");
        this.wait.setText("0.1");
        this.duration.setText("3");
        this.fps.setText("10");
    }

    private void setVideoValue() {
        this.fadein.setText("0");
        this.fadeout.setText("0");
        this.wait.setText("0");
        this.duration.setText("0.0334");
        this.fps.setText("29.97");
    }

    private CCombo createCCombo(Composite parent, String label, String[] values, int style) {
        Composite p2 = WidgetBuilder.createTwoGridLayoutComposite((Composite)parent, (int)0);
        WidgetBuilder.createLabel((Composite)p2, (String)label);
        CCombo combo = new CCombo(p2, style);
        combo.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)200, (int)0));
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
        return combo;
    }

    private void addSizeValue(String value) {
        String[] item = this.size.getItems();
        boolean match = false;
        int i = 0;
        while (i < item.length) {
            if (item[i].equals(value)) {
                match = true;
                break;
            }
            ++i;
        }
        if (!match) {
            this.size.add(value);
        }
    }

    public String getDuration() {
        return this.duration.getText();
    }

    public String getWait() {
        return this.wait.getText();
    }

    public String getFadein() {
        return this.fadein.getText();
    }

    public String getFadeout() {
        return this.fadeout.getText();
    }

    public String getValign() {
        return this.valign.getText();
    }

    public String getLoop() {
        return this.loop.getText();
    }

    public String getAlign() {
        return this.align.getText();
    }
}

