/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.wizards.exportimg;

import java.io.File;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.widget.LayoutDataBuilder;
import jp.sourceforge.akjrcp.commons.ui.widget.WidgetBuilder;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import jp.sourceforge.akjrcp.text_douga.rcp.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class VideoInputPage
extends WizardPage {
    private CCombo size;
    private CCombo fps;
    private FileDirChoicer inputVideo;

    protected VideoInputPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("exportimg.input_title"));
        this.setDescription(Messages.getString("exportimg.input_description"));
        this.setPageComplete(false);
    }

    public String getSize() {
        return this.size.getText();
    }

    public String getFps() {
        return this.fps.getText();
    }

    public String getPath() {
        return this.inputVideo.getAbsoluteFilePath();
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        this.setControl((Control)base);
        this.inputVideo = new FileDirChoicer(base, 0, 0, Messages.getString("exportimg.input"));
        this.inputVideo.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputVideo.setFilterExtensions(ParserUtils.toMixFilterExtensions(ParserUtils.videos));
        this.inputVideo.addFileListChangeListener(new AbstractFileDirChoicer.FileStatusChangeListener(){

            public void addList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                VideoInputPage.this.setPageComplete(false);
                String ffmpeg = FFMpegUI.getFFmpegOrPureFFMpeg();
                if (ffmpeg != null) {
                    FLVInfomation info = new FFMpegFLVParser(ffmpeg).parseFile(new File(event.getFilePath()));
                    String value = String.valueOf(info.getVideoWidth()) + "x" + info.getVideoHeight();
                    VideoInputPage.this.size.setText(value);
                    VideoInputPage.this.addSizeValue(value);
                    VideoInputPage.this.fps.setText("" + info.getVideoRate());
                }
                VideoInputPage.this.setPageComplete(true);
            }

            public void removeList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                VideoInputPage.this.size.setText("");
                VideoInputPage.this.fps.setText("");
            }
        });
        Composite p1 = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        WidgetBuilder.createLabel((Composite)p1, (String)Messages.getString("exportimg.size"));
        this.size = new CCombo(p1, 8);
        this.size.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)200, (int)0));
        String[] sizes = new String[]{"", "160x120", "320x240", "640x480", "720x480"};
        int i = 0;
        while (i < sizes.length) {
            this.size.add(sizes[i]);
            ++i;
        }
        Composite p2 = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        WidgetBuilder.createLabel((Composite)p2, (String)Messages.getString("exportimg.fps"));
        this.fps = new CCombo(p2, 8);
        this.fps.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)200, (int)0));
        String[] fpss = new String[]{"", "1", "5", "10", "12", "14.895", "15", "24", "25", "29.97", "30"};
        int i2 = 0;
        while (i2 < fpss.length) {
            this.fps.add(fpss[i2]);
            ++i2;
        }
    }

    private void addSizeValue(String value) {
        String[] item = this.size.getItems();
        boolean match = false;
        int i = 0;
        while (i < item.length) {
            if (item[i].equals(value)) {
                match = true;
                break;
            }
            ++i;
        }
        if (!match) {
            this.size.add(value);
        }
    }
}

