/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.math.BigDecimal;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.ItemData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractItem
implements ItemData {
    public static Log log = LogFactory.getLog(AbstractItem.class);
    protected int align;
    protected int valign;
    protected double startTime;
    protected double duration = 1.0;
    protected double fadeInTime = 0.2;
    protected double fadeOutTime = 0.2;
    protected float transparent = 1.0f;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int z;
    protected int marginLeft = 16;
    protected int marginRight = 16;
    protected int marginTop = 16;
    protected int marginBottom = 16;
    protected boolean keepAspect = true;
    protected double moveX;
    protected double moveY;
    protected double moveWidth;
    protected double moveHeight;
    protected double shearX;
    protected double shearY;
    protected int rotate;
    protected int moveRotate;

    public AbstractItem(AbstractItem base) {
        this.align = base.align;
        this.valign = base.valign;
        this.startTime = base.startTime;
        this.duration = base.duration;
        this.fadeInTime = base.fadeInTime;
        this.fadeOutTime = base.fadeOutTime;
        this.transparent = base.transparent;
        this.x = base.x;
        this.y = base.y;
        this.z = base.z;
        this.width = base.width;
        this.height = base.height;
        this.marginLeft = base.marginLeft;
        this.marginRight = base.marginRight;
        this.marginTop = base.marginTop;
        this.marginBottom = base.marginBottom;
        this.keepAspect = base.keepAspect;
        this.moveX = base.moveX;
        this.moveY = base.moveY;
        this.moveWidth = base.moveWidth;
        this.moveHeight = base.moveHeight;
        this.shearX = base.shearX;
        this.shearY = base.shearY;
        this.rotate = base.rotate;
        this.moveRotate = base.moveRotate;
    }

    public AbstractItem() {
    }

    protected double getFrameTime(int frame, double fps) {
        if (frame == 1) {
            return 0.0;
        }
        return (double)(frame - 1) / fps;
    }

    public double getMoveX() {
        return this.moveX;
    }

    public void setMoveX(double moveX) {
        this.moveX = moveX;
    }

    public double getMoveY() {
        return this.moveY;
    }

    public void setMoveY(double moveY) {
        this.moveY = moveY;
    }

    public int getMovedX(DougaPreference preference, double currentTime) {
        if (this.moveX == 0.0) {
            return 0;
        }
        double diffTime = currentTime - this.getStartTime();
        return new BigDecimal("" + this.moveX).multiply(new BigDecimal("" + diffTime)).intValue();
    }

    public int getMovedRotate(DougaPreference preference, double currentTime) {
        if (this.moveRotate == 0) {
            return this.rotate;
        }
        double diffTime = currentTime - this.getStartTime();
        return new BigDecimal("" + this.moveRotate).multiply(new BigDecimal("" + diffTime)).intValue() % 360;
    }

    public int getMovedWidth(DougaPreference preference, double currentTime) {
        if (this.moveHeight == 0.0) {
            return 0;
        }
        double diffTime = currentTime - this.getStartTime();
        return new BigDecimal("" + this.moveHeight).multiply(new BigDecimal("" + diffTime)).intValue();
    }

    public int getMovedHeight(DougaPreference preference, double currentTime) {
        if (this.moveWidth == 0.0) {
            return 0;
        }
        double diffTime = currentTime - this.getStartTime();
        return new BigDecimal("" + this.moveWidth).multiply(new BigDecimal("" + diffTime)).intValue();
    }

    public int getMovedY(DougaPreference preference, double currentTime) {
        if (this.moveY == 0.0) {
            return 0;
        }
        double diffTime = currentTime - this.getStartTime();
        return new BigDecimal("" + this.moveY).multiply(new BigDecimal("" + diffTime)).intValue();
    }

    public static boolean isOverwrapTime(AbstractItem item1, AbstractItem item2) {
        if (item1.getDuration() == -1.0 || item2.getDuration() == -1.0) {
            return true;
        }
        if (item1.getStartTime() >= item2.getStartTime() && item1.getStartTime() < item2.getStartTime() + item2.getDuration()) {
            return true;
        }
        return item1.getStartTime() + item1.getDuration() > item2.getStartTime() && item1.getStartTime() + item1.getDuration() <= item2.getStartTime() + item2.getDuration();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public String toString() {
        return "startTime=" + this.startTime + " duration=" + this.duration + " fadeInTime=" + this.fadeInTime + " fadeOutTime=" + this.fadeOutTime + " transparent=" + this.transparent + " x=" + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height + " z=" + this.z + " align=" + this.align + " valign=" + this.valign + " keepAspect=" + this.keepAspect;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public float getFrameTransparent(DougaPreference preference, double time) {
        if (this.duration == -1.0) {
            return this.transparent;
        }
        if (this.fadeInTime == 0.0 && this.fadeOutTime == 0.0) {
            return this.transparent;
        }
        double drawTransparent = this.transparent;
        double t = time - this.startTime;
        if (t <= 0.0 || t >= this.duration) {
            if (t < 0.0 || t > this.duration) {
                log.warn((Object)("invalid t:" + t));
            }
            if (this.fadeInTime == 0.0 && t <= 0.0) {
                return this.transparent;
            }
            if (this.fadeOutTime == 0.0 && t >= this.duration) {
                return this.transparent;
            }
            if (t == 0.0 && 1.0 / preference.getFps() > this.fadeInTime) {
                return (float)drawTransparent;
            }
            return 0.03f;
        }
        if (t > 0.0 && t < this.fadeInTime) {
            drawTransparent = t / this.fadeInTime * (double)this.transparent;
            if (drawTransparent < 0.0 || drawTransparent > 1.0) {
                log.warn((Object)("invalid fadeIn:time=" + t + "," + drawTransparent));
            }
        } else if (t > this.duration - this.fadeOutTime && ((drawTransparent = (this.duration - t) / this.fadeOutTime * (double)this.transparent) < 0.0 || drawTransparent > 1.0)) {
            log.warn((Object)("invalid fadeOut:time=" + t + "," + drawTransparent));
        }
        return (float)drawTransparent;
    }

    public float getTransparent() {
        return this.transparent;
    }

    public void setTransparent(float transparent) {
        this.transparent = transparent;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public double getFadeInTime() {
        return this.fadeInTime;
    }

    public void setFadeInTime(double fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    public double getFadeOutTime() {
        return this.fadeOutTime;
    }

    public void setFadeOutTime(double fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }

    public boolean isKeepAspect() {
        return this.keepAspect;
    }

    public void setKeepAspect(boolean keepAspect) {
        this.keepAspect = keepAspect;
    }

    @Override
    public double getLastTime() {
        if (this.duration != -1.0) {
            return this.startTime + this.duration;
        }
        return 0.0;
    }

    public boolean isInFrame(DougaPreference preference, int frame) {
        double frameTime = (double)(frame - 1) / preference.getFps();
        if (frameTime >= this.startTime && frameTime < this.startTime + this.duration) {
            log.trace((Object)("intime:" + frameTime + " start=" + this.startTime + " end=" + (this.startTime + this.duration)));
            return true;
        }
        return false;
    }

    public double getMoveWidth() {
        return this.moveWidth;
    }

    public void setMoveWidth(double moveWidth) {
        this.moveWidth = moveWidth;
    }

    public double getMoveHeight() {
        return this.moveHeight;
    }

    public void setMoveHeight(double moveHeight) {
        this.moveHeight = moveHeight;
    }

    public double getShearX() {
        return this.shearX;
    }

    public void setShearX(double shearX) {
        this.shearX = shearX;
    }

    public double getShearY() {
        return this.shearY;
    }

    public void setShearY(double shearY) {
        this.shearY = shearY;
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        this.rotate = rotate;
    }

    public int getMoveRotate() {
        return this.moveRotate;
    }

    public void setMoveRotate(int move_rorate) {
        this.moveRotate = move_rorate;
    }
}

