/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.srt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.subtitle.srt.SRTObject;
import jp.sourceforge.akjrcp.subtitle.srt.TimeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SRTParser {
    private static int INDEX = 0;
    private static int TIME = 1;
    private static int TEXT = 2;
    private int mode = INDEX;
    static Log log = LogFactory.getLog(SRTParser.class);

    public SRTList parse(Reader reader) {
        SRTList data = new SRTList();
        try {
            String line;
            BufferedReader breader = new BufferedReader(reader);
            SRTObject srtObject = new SRTObject();
            SRTObject preObject = null;
            String headerLine = "";
            while ((line = breader.readLine()) != null) {
                if (this.mode == INDEX) {
                    log.info((Object)("INDEX:" + line));
                    if (line.equals("") && srtObject != null && preObject != null) continue;
                    if (!SRTParser.isDigitOnly(line)) {
                        if (preObject == null) continue;
                        log.info((Object)("append-pre:" + line));
                        preObject.setText(String.valueOf(preObject.getText()) + "\r\n" + "\r\n" + line);
                        continue;
                    }
                    if (headerLine.length() >= 2) {
                        log.info((Object)"add empty");
                        data.add(srtObject);
                        srtObject.setText(headerLine.substring(2));
                        preObject = srtObject;
                        srtObject = new SRTObject();
                        headerLine = "";
                    }
                    int index = 0;
                    try {
                        index = Integer.parseInt(line);
                        log.info((Object)("parsed:" + index));
                    }
                    catch (Exception exception) {
                        index = 0;
                    }
                    srtObject.setIndex(index);
                    this.mode = TIME;
                    continue;
                }
                if (this.mode == TIME) {
                    log.info((Object)("TIME:" + line));
                    if (line.length() != 29) continue;
                    TimeData start = this.parseTime(line.substring(0, 12));
                    TimeData end = this.parseTime(line.substring(17));
                    srtObject.setStartTime(start);
                    srtObject.setEndTime(end);
                    this.mode = TEXT;
                    continue;
                }
                if (this.mode == TEXT) {
                    log.info((Object)("TEXT:" + line));
                    if (line.equals("")) {
                        if (srtObject.getText() == null) {
                            if (headerLine.equals("")) {
                                headerLine = String.valueOf(headerLine) + "\r\n";
                                log.info((Object)"add-header");
                                continue;
                            }
                            this.mode = INDEX;
                            continue;
                        }
                        if (this.isValid(srtObject)) {
                            data.add(srtObject);
                            log.info((Object)"add-sub");
                        }
                        preObject = srtObject;
                        srtObject = new SRTObject();
                        this.mode = INDEX;
                        headerLine = "";
                        continue;
                    }
                    String text = srtObject.getText();
                    if (text == null) {
                        text = String.valueOf(headerLine) + line;
                        headerLine = "";
                    } else {
                        text = String.valueOf(text) + "\r\n" + line;
                    }
                    srtObject.setText(text);
                    continue;
                }
                log.info((Object)("WARN:" + line));
            }
            if (this.isValid(srtObject)) {
                data.add(srtObject);
            }
            reader.close();
            this.mode = INDEX;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    private TimeData parseTime(String line) {
        TimeData timeData = new TimeData(line);
        return timeData;
    }

    private boolean isValid(SRTObject srtObject) {
        return srtObject.getIndex() != 0 && srtObject.getStartTime() != null && srtObject.getEndTime() != null;
    }

    public static boolean isDigitOnly(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

