/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.srt;

import jp.sourceforge.akjrcp.subtitle.srt.TimeData;

public class SRTObject
implements Comparable {
    private TimeData startTime;
    private TimeData endTime;
    private int index;
    private String text = null;

    public String toString() {
        String result = this.index + "\r\n";
        result = String.valueOf(result) + this.startTime + " --> " + this.endTime + "\r\n";
        result = String.valueOf(result) + this.text + "\r\n";
        return result;
    }

    public TimeData getEndTime() {
        return this.endTime;
    }

    public int getIndex() {
        return this.index;
    }

    public TimeData getStartTime() {
        return this.startTime;
    }

    public String getText() {
        return this.text;
    }

    public void setEndTime(TimeData data) {
        this.endTime = data;
    }

    public void setEndTime(long time) {
        this.endTime = new TimeData(time);
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setStartTime(TimeData data) {
        this.startTime = data;
    }

    public void setStartTime(long time) {
        this.startTime = new TimeData(time);
    }

    public void setText(String string) {
        this.text = string;
    }

    public int compareTo(Object o) {
        if (o instanceof SRTObject) {
            SRTObject srt = (SRTObject)o;
            if (srt.getStartTime().getTime() == this.getStartTime().getTime()) {
                if (srt.getEndTime().getTime() > this.getEndTime().getTime()) {
                    return -1;
                }
                return 1;
            }
            if (srt.getStartTime().getTime() > this.getStartTime().getTime()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public boolean intersect(SRTObject srt) {
        if (srt == null) {
            return false;
        }
        if (srt.getEndTime().getTime() > this.getStartTime().getTime() && srt.getEndTime().getTime() < this.getEndTime().getTime()) {
            return true;
        }
        return srt.getStartTime().getTime() > this.getStartTime().getTime() && srt.getStartTime().getTime() < this.getEndTime().getTime();
    }
}

