/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTVetoableValue;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextObservableValue
extends AbstractSWTVetoableValue {
    private final Text text;
    private boolean updating = false;
    private final int updateEventType;
    private static final int[] validUpdateEventTypes;
    private String oldValue;
    private Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            String newValue;
            if (!TextObservableValue.this.updating && !(newValue = TextObservableValue.this.text.getText()).equals(TextObservableValue.this.oldValue)) {
                TextObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)TextObservableValue.this.oldValue, (Object)newValue));
                TextObservableValue.this.oldValue = newValue;
            }
        }
    };
    private VerifyListener verifyListener;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[0] = 24;
        nArray[1] = 16;
        validUpdateEventTypes = nArray;
    }

    public TextObservableValue(Text text, int updateEventType) {
        super((Widget)text);
        boolean eventValid = false;
        int i = 0;
        while (!eventValid && i < validUpdateEventTypes.length) {
            eventValid = updateEventType == validUpdateEventTypes[i];
            ++i;
        }
        if (!eventValid) {
            throw new IllegalArgumentException("UpdateEventType [" + updateEventType + "] is not supported.");
        }
        this.text = text;
        this.updateEventType = updateEventType;
        if (updateEventType != 0) {
            text.addListener(updateEventType, this.updateListener);
        }
        this.oldValue = text.getText();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String newText;
                String currentText;
                if (!TextObservableValue.this.updating && !TextObservableValue.this.fireValueChanging(Diffs.createValueDiff((Object)(currentText = TextObservableValue.this.text.getText()), (Object)(newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end))))) {
                    e.doit = false;
                }
            }
        };
        text.addVerifyListener(this.verifyListener);
    }

    protected void doSetApprovedValue(Object value) {
        try {
            this.updating = true;
            this.text.setText(value == null ? "" : value.toString());
            this.oldValue = this.text.getText();
        }
        finally {
            this.updating = false;
        }
    }

    public Object doGetValue() {
        this.oldValue = this.text.getText();
        return this.oldValue;
    }

    public Object getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void dispose() {
        if (!this.text.isDisposed()) {
            if (this.updateEventType != 0) {
                this.text.removeListener(this.updateEventType, this.updateListener);
            }
            this.text.removeVerifyListener(this.verifyListener);
        }
        super.dispose();
    }
}

